/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Objects;
import org.rocksdb.WriteStallCondition;

public class WriteStallInfo {
    private final String columnFamilyName;
    private final WriteStallCondition currentCondition;
    private final WriteStallCondition previousCondition;

    WriteStallInfo(String columnFamilyName, byte currentConditionValue, byte previousConditionValue) {
        this.columnFamilyName = columnFamilyName;
        this.currentCondition = WriteStallCondition.fromValue(currentConditionValue);
        this.previousCondition = WriteStallCondition.fromValue(previousConditionValue);
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public WriteStallCondition getCurrentCondition() {
        return this.currentCondition;
    }

    public WriteStallCondition getPreviousCondition() {
        return this.previousCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteStallInfo that = (WriteStallInfo)o;
        return Objects.equals(this.columnFamilyName, that.columnFamilyName) && this.currentCondition == that.currentCondition && this.previousCondition == that.previousCondition;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnFamilyName, this.currentCondition, this.previousCondition});
    }

    public String toString() {
        return "WriteStallInfo{columnFamilyName='" + this.columnFamilyName + '\'' + ", currentCondition=" + (Object)((Object)this.currentCondition) + ", previousCondition=" + (Object)((Object)this.previousCondition) + '}';
    }
}

