/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Map;
import org.rocksdb.Env;
import org.rocksdb.Logger;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;

public final class SstFileManager
extends RocksObject {
    public static final long RATE_BYTES_PER_SEC_DEFAULT = 0L;
    public static final boolean DELETE_EXISTING_TRASH_DEFAULT = true;
    public static final double MAX_TRASH_DB_RATION_DEFAULT = 0.25;
    public static final long BYTES_MAX_DELETE_CHUNK_DEFAULT = 0x4000000L;

    public SstFileManager(Env env) throws RocksDBException {
        this(env, null);
    }

    public SstFileManager(Env env, Logger logger) throws RocksDBException {
        this(env, logger, 0L);
    }

    public SstFileManager(Env env, Logger logger, long rateBytesPerSec) throws RocksDBException {
        this(env, logger, rateBytesPerSec, 0.25);
    }

    public SstFileManager(Env env, Logger logger, long rateBytesPerSec, double maxTrashDbRatio) throws RocksDBException {
        this(env, logger, rateBytesPerSec, maxTrashDbRatio, 0x4000000L);
    }

    public SstFileManager(Env env, Logger logger, long rateBytesPerSec, double maxTrashDbRatio, long bytesMaxDeleteChunk) throws RocksDBException {
        super(SstFileManager.newSstFileManager(env.nativeHandle_, logger != null ? logger.nativeHandle_ : 0L, rateBytesPerSec, maxTrashDbRatio, bytesMaxDeleteChunk));
    }

    public void setMaxAllowedSpaceUsage(long maxAllowedSpace) {
        this.setMaxAllowedSpaceUsage(this.nativeHandle_, maxAllowedSpace);
    }

    public void setCompactionBufferSize(long compactionBufferSize) {
        this.setCompactionBufferSize(this.nativeHandle_, compactionBufferSize);
    }

    public boolean isMaxAllowedSpaceReached() {
        return this.isMaxAllowedSpaceReached(this.nativeHandle_);
    }

    public boolean isMaxAllowedSpaceReachedIncludingCompactions() {
        return this.isMaxAllowedSpaceReachedIncludingCompactions(this.nativeHandle_);
    }

    public long getTotalSize() {
        return this.getTotalSize(this.nativeHandle_);
    }

    public Map<String, Long> getTrackedFiles() {
        return this.getTrackedFiles(this.nativeHandle_);
    }

    public long getDeleteRateBytesPerSecond() {
        return this.getDeleteRateBytesPerSecond(this.nativeHandle_);
    }

    public void setDeleteRateBytesPerSecond(long deleteRate) {
        this.setDeleteRateBytesPerSecond(this.nativeHandle_, deleteRate);
    }

    public double getMaxTrashDBRatio() {
        return this.getMaxTrashDBRatio(this.nativeHandle_);
    }

    public void setMaxTrashDBRatio(double ratio) {
        this.setMaxTrashDBRatio(this.nativeHandle_, ratio);
    }

    private static native long newSstFileManager(long var0, long var2, long var4, double var6, long var8) throws RocksDBException;

    private native void setMaxAllowedSpaceUsage(long var1, long var3);

    private native void setCompactionBufferSize(long var1, long var3);

    private native boolean isMaxAllowedSpaceReached(long var1);

    private native boolean isMaxAllowedSpaceReachedIncludingCompactions(long var1);

    private native long getTotalSize(long var1);

    private native Map<String, Long> getTrackedFiles(long var1);

    private native long getDeleteRateBytesPerSecond(long var1);

    private native void setDeleteRateBytesPerSecond(long var1, long var3);

    private native double getMaxTrashDBRatio(long var1);

    private native void setMaxTrashDBRatio(long var1, double var3);

    @Override
    protected final native void disposeInternal(long var1);
}

