/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import org.rocksdb.AbstractRocksIterator;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksIterator
extends AbstractRocksIterator<RocksDB> {
    protected RocksIterator(RocksDB rocksDB, long nativeHandle) {
        super(rocksDB, nativeHandle);
    }

    public byte[] key() {
        assert (this.isOwningHandle());
        return this.key0(this.nativeHandle_);
    }

    public int key(ByteBuffer key) {
        assert (this.isOwningHandle() && key.isDirect());
        int result = this.keyDirect0(this.nativeHandle_, key, key.position(), key.remaining());
        key.limit(Math.min(key.position() + result, key.limit()));
        return result;
    }

    public byte[] value() {
        assert (this.isOwningHandle());
        return this.value0(this.nativeHandle_);
    }

    public int value(ByteBuffer value) {
        assert (this.isOwningHandle() && value.isDirect());
        int result = this.valueDirect0(this.nativeHandle_, value, value.position(), value.remaining());
        value.limit(Math.min(value.position() + result, value.limit()));
        return result;
    }

    @Override
    protected final native void disposeInternal(long var1);

    @Override
    final native boolean isValid0(long var1);

    @Override
    final native void seekToFirst0(long var1);

    @Override
    final native void seekToLast0(long var1);

    @Override
    final native void next0(long var1);

    @Override
    final native void prev0(long var1);

    @Override
    final native void refresh0(long var1);

    @Override
    final native void seek0(long var1, byte[] var3, int var4);

    @Override
    final native void seekForPrev0(long var1, byte[] var3, int var4);

    @Override
    final native void seekDirect0(long var1, ByteBuffer var3, int var4, int var5);

    @Override
    final native void seekForPrevDirect0(long var1, ByteBuffer var3, int var4, int var5);

    @Override
    final native void status0(long var1) throws RocksDBException;

    private native byte[] key0(long var1);

    private native byte[] value0(long var1);

    private native int keyDirect0(long var1, ByteBuffer var3, int var4, int var5);

    private native int valueDirect0(long var1, ByteBuffer var3, int var4, int var5);
}

