/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.AbstractSlice;
import org.rocksdb.AbstractTableFilter;
import org.rocksdb.ReadTier;
import org.rocksdb.RocksObject;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;

public class ReadOptions
extends RocksObject {
    private AbstractSlice<?> iterateLowerBoundSlice_;
    private AbstractSlice<?> iterateUpperBoundSlice_;
    private AbstractSlice<?> timestampSlice_;
    private AbstractSlice<?> iterStartTs_;

    public ReadOptions() {
        super(ReadOptions.newReadOptions());
    }

    public ReadOptions(boolean verifyChecksums, boolean fillCache) {
        super(ReadOptions.newReadOptions(verifyChecksums, fillCache));
    }

    public ReadOptions(ReadOptions other) {
        super(ReadOptions.copyReadOptions(other.nativeHandle_));
        this.iterateLowerBoundSlice_ = other.iterateLowerBoundSlice_;
        this.iterateUpperBoundSlice_ = other.iterateUpperBoundSlice_;
        this.timestampSlice_ = other.timestampSlice_;
        this.iterStartTs_ = other.iterStartTs_;
    }

    public boolean verifyChecksums() {
        assert (this.isOwningHandle());
        return this.verifyChecksums(this.nativeHandle_);
    }

    public ReadOptions setVerifyChecksums(boolean verifyChecksums) {
        assert (this.isOwningHandle());
        this.setVerifyChecksums(this.nativeHandle_, verifyChecksums);
        return this;
    }

    public boolean fillCache() {
        assert (this.isOwningHandle());
        return this.fillCache(this.nativeHandle_);
    }

    public ReadOptions setFillCache(boolean fillCache) {
        assert (this.isOwningHandle());
        this.setFillCache(this.nativeHandle_, fillCache);
        return this;
    }

    public Snapshot snapshot() {
        assert (this.isOwningHandle());
        long snapshotHandle = this.snapshot(this.nativeHandle_);
        if (snapshotHandle != 0L) {
            return new Snapshot(snapshotHandle);
        }
        return null;
    }

    public ReadOptions setSnapshot(Snapshot snapshot) {
        assert (this.isOwningHandle());
        if (snapshot != null) {
            this.setSnapshot(this.nativeHandle_, snapshot.nativeHandle_);
        } else {
            this.setSnapshot(this.nativeHandle_, 0L);
        }
        return this;
    }

    public ReadTier readTier() {
        assert (this.isOwningHandle());
        return ReadTier.getReadTier(this.readTier(this.nativeHandle_));
    }

    public ReadOptions setReadTier(ReadTier readTier) {
        assert (this.isOwningHandle());
        this.setReadTier(this.nativeHandle_, readTier.getValue());
        return this;
    }

    public boolean tailing() {
        assert (this.isOwningHandle());
        return this.tailing(this.nativeHandle_);
    }

    public ReadOptions setTailing(boolean tailing) {
        assert (this.isOwningHandle());
        this.setTailing(this.nativeHandle_, tailing);
        return this;
    }

    @Deprecated
    public boolean managed() {
        assert (this.isOwningHandle());
        return this.managed(this.nativeHandle_);
    }

    @Deprecated
    public ReadOptions setManaged(boolean managed) {
        assert (this.isOwningHandle());
        this.setManaged(this.nativeHandle_, managed);
        return this;
    }

    public boolean totalOrderSeek() {
        assert (this.isOwningHandle());
        return this.totalOrderSeek(this.nativeHandle_);
    }

    public ReadOptions setTotalOrderSeek(boolean totalOrderSeek) {
        assert (this.isOwningHandle());
        this.setTotalOrderSeek(this.nativeHandle_, totalOrderSeek);
        return this;
    }

    public boolean prefixSameAsStart() {
        assert (this.isOwningHandle());
        return this.prefixSameAsStart(this.nativeHandle_);
    }

    public ReadOptions setPrefixSameAsStart(boolean prefixSameAsStart) {
        assert (this.isOwningHandle());
        this.setPrefixSameAsStart(this.nativeHandle_, prefixSameAsStart);
        return this;
    }

    public boolean pinData() {
        assert (this.isOwningHandle());
        return this.pinData(this.nativeHandle_);
    }

    public ReadOptions setPinData(boolean pinData) {
        assert (this.isOwningHandle());
        this.setPinData(this.nativeHandle_, pinData);
        return this;
    }

    public boolean backgroundPurgeOnIteratorCleanup() {
        assert (this.isOwningHandle());
        return this.backgroundPurgeOnIteratorCleanup(this.nativeHandle_);
    }

    public ReadOptions setBackgroundPurgeOnIteratorCleanup(boolean backgroundPurgeOnIteratorCleanup) {
        assert (this.isOwningHandle());
        this.setBackgroundPurgeOnIteratorCleanup(this.nativeHandle_, backgroundPurgeOnIteratorCleanup);
        return this;
    }

    public long readaheadSize() {
        assert (this.isOwningHandle());
        return this.readaheadSize(this.nativeHandle_);
    }

    public ReadOptions setReadaheadSize(long readaheadSize) {
        assert (this.isOwningHandle());
        this.setReadaheadSize(this.nativeHandle_, readaheadSize);
        return this;
    }

    public long maxSkippableInternalKeys() {
        assert (this.isOwningHandle());
        return this.maxSkippableInternalKeys(this.nativeHandle_);
    }

    public ReadOptions setMaxSkippableInternalKeys(long maxSkippableInternalKeys) {
        assert (this.isOwningHandle());
        this.setMaxSkippableInternalKeys(this.nativeHandle_, maxSkippableInternalKeys);
        return this;
    }

    public boolean ignoreRangeDeletions() {
        assert (this.isOwningHandle());
        return this.ignoreRangeDeletions(this.nativeHandle_);
    }

    public ReadOptions setIgnoreRangeDeletions(boolean ignoreRangeDeletions) {
        assert (this.isOwningHandle());
        this.setIgnoreRangeDeletions(this.nativeHandle_, ignoreRangeDeletions);
        return this;
    }

    public ReadOptions setIterateLowerBound(AbstractSlice<?> iterateLowerBound) {
        assert (this.isOwningHandle());
        this.setIterateLowerBound(this.nativeHandle_, iterateLowerBound == null ? 0L : iterateLowerBound.getNativeHandle());
        this.iterateLowerBoundSlice_ = iterateLowerBound;
        return this;
    }

    public Slice iterateLowerBound() {
        assert (this.isOwningHandle());
        long lowerBoundSliceHandle = this.iterateLowerBound(this.nativeHandle_);
        if (lowerBoundSliceHandle != 0L) {
            return new Slice(lowerBoundSliceHandle, false);
        }
        return null;
    }

    public ReadOptions setIterateUpperBound(AbstractSlice<?> iterateUpperBound) {
        assert (this.isOwningHandle());
        this.setIterateUpperBound(this.nativeHandle_, iterateUpperBound == null ? 0L : iterateUpperBound.getNativeHandle());
        this.iterateUpperBoundSlice_ = iterateUpperBound;
        return this;
    }

    public Slice iterateUpperBound() {
        assert (this.isOwningHandle());
        long upperBoundSliceHandle = this.iterateUpperBound(this.nativeHandle_);
        if (upperBoundSliceHandle != 0L) {
            return new Slice(upperBoundSliceHandle, false);
        }
        return null;
    }

    public ReadOptions setTableFilter(AbstractTableFilter tableFilter) {
        assert (this.isOwningHandle());
        this.setTableFilter(this.nativeHandle_, tableFilter.nativeHandle_);
        return this;
    }

    public ReadOptions setIterStartSeqnum(long startSeqnum) {
        assert (this.isOwningHandle());
        this.setIterStartSeqnum(this.nativeHandle_, startSeqnum);
        return this;
    }

    public long iterStartSeqnum() {
        assert (this.isOwningHandle());
        return this.iterStartSeqnum(this.nativeHandle_);
    }

    public boolean autoPrefixMode() {
        assert (this.isOwningHandle());
        return this.autoPrefixMode(this.nativeHandle_);
    }

    public ReadOptions setAutoPrefixMode(boolean mode) {
        assert (this.isOwningHandle());
        this.setAutoPrefixMode(this.nativeHandle_, mode);
        return this;
    }

    public Slice timestamp() {
        assert (this.isOwningHandle());
        long timestampSliceHandle = this.timestamp(this.nativeHandle_);
        if (timestampSliceHandle != 0L) {
            return new Slice(timestampSliceHandle);
        }
        return null;
    }

    public ReadOptions setTimestamp(AbstractSlice<?> timestamp) {
        assert (this.isOwningHandle());
        this.setTimestamp(this.nativeHandle_, timestamp == null ? 0L : timestamp.getNativeHandle());
        this.timestampSlice_ = timestamp;
        return this;
    }

    public Slice iterStartTs() {
        assert (this.isOwningHandle());
        long iterStartTsHandle = this.iterStartTs(this.nativeHandle_);
        if (iterStartTsHandle != 0L) {
            return new Slice(iterStartTsHandle);
        }
        return null;
    }

    public ReadOptions setIterStartTs(AbstractSlice<?> iterStartTs) {
        assert (this.isOwningHandle());
        this.setIterStartTs(this.nativeHandle_, iterStartTs == null ? 0L : iterStartTs.getNativeHandle());
        this.iterStartTs_ = iterStartTs;
        return this;
    }

    public long deadline() {
        assert (this.isOwningHandle());
        return this.deadline(this.nativeHandle_);
    }

    public ReadOptions setDeadline(long deadlineTime) {
        assert (this.isOwningHandle());
        this.setDeadline(this.nativeHandle_, deadlineTime);
        return this;
    }

    public long ioTimeout() {
        assert (this.isOwningHandle());
        return this.ioTimeout(this.nativeHandle_);
    }

    public ReadOptions setIoTimeout(long ioTimeout) {
        assert (this.isOwningHandle());
        this.setIoTimeout(this.nativeHandle_, ioTimeout);
        return this;
    }

    public long valueSizeSoftLimit() {
        assert (this.isOwningHandle());
        return this.valueSizeSoftLimit(this.nativeHandle_);
    }

    public ReadOptions setValueSizeSoftLimit(long valueSizeSoftLimit) {
        assert (this.isOwningHandle());
        this.setValueSizeSoftLimit(this.nativeHandle_, valueSizeSoftLimit);
        return this;
    }

    private static native long newReadOptions();

    private static native long newReadOptions(boolean var0, boolean var1);

    private static native long copyReadOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native boolean verifyChecksums(long var1);

    private native void setVerifyChecksums(long var1, boolean var3);

    private native boolean fillCache(long var1);

    private native void setFillCache(long var1, boolean var3);

    private native long snapshot(long var1);

    private native void setSnapshot(long var1, long var3);

    private native byte readTier(long var1);

    private native void setReadTier(long var1, byte var3);

    private native boolean tailing(long var1);

    private native void setTailing(long var1, boolean var3);

    private native boolean managed(long var1);

    private native void setManaged(long var1, boolean var3);

    private native boolean totalOrderSeek(long var1);

    private native void setTotalOrderSeek(long var1, boolean var3);

    private native boolean prefixSameAsStart(long var1);

    private native void setPrefixSameAsStart(long var1, boolean var3);

    private native boolean pinData(long var1);

    private native void setPinData(long var1, boolean var3);

    private native boolean backgroundPurgeOnIteratorCleanup(long var1);

    private native void setBackgroundPurgeOnIteratorCleanup(long var1, boolean var3);

    private native long readaheadSize(long var1);

    private native void setReadaheadSize(long var1, long var3);

    private native long maxSkippableInternalKeys(long var1);

    private native void setMaxSkippableInternalKeys(long var1, long var3);

    private native boolean ignoreRangeDeletions(long var1);

    private native void setIgnoreRangeDeletions(long var1, boolean var3);

    private native void setIterateUpperBound(long var1, long var3);

    private native long iterateUpperBound(long var1);

    private native void setIterateLowerBound(long var1, long var3);

    private native long iterateLowerBound(long var1);

    private native void setTableFilter(long var1, long var3);

    private native void setIterStartSeqnum(long var1, long var3);

    private native long iterStartSeqnum(long var1);

    private native boolean autoPrefixMode(long var1);

    private native void setAutoPrefixMode(long var1, boolean var3);

    private native long timestamp(long var1);

    private native void setTimestamp(long var1, long var3);

    private native long iterStartTs(long var1);

    private native void setIterStartTs(long var1, long var3);

    private native long deadline(long var1);

    private native void setDeadline(long var1, long var3);

    private native long ioTimeout(long var1);

    private native void setIoTimeout(long var1, long var3);

    private native long valueSizeSoftLimit(long var1);

    private native void setValueSizeSoftLimit(long var1, long var3);
}

