/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ConfigOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.RocksDBException;

public class OptionsUtil {
    public static void loadLatestOptions(String dbPath, Env env, DBOptions dbOptions, List<ColumnFamilyDescriptor> cfDescs) throws RocksDBException {
        OptionsUtil.loadLatestOptions(dbPath, env, dbOptions, cfDescs, false);
    }

    public static void loadLatestOptions(String dbPath, Env env, DBOptions dbOptions, List<ColumnFamilyDescriptor> cfDescs, boolean ignoreUnknownOptions) throws RocksDBException {
        OptionsUtil.loadLatestOptions(dbPath, env.nativeHandle_, dbOptions.nativeHandle_, cfDescs, ignoreUnknownOptions);
    }

    public static void loadLatestOptions(ConfigOptions configOptions, String dbPath, DBOptions dbOptions, List<ColumnFamilyDescriptor> cfDescs) throws RocksDBException {
        OptionsUtil.loadLatestOptions(configOptions.nativeHandle_, dbPath, dbOptions.nativeHandle_, cfDescs);
    }

    public static void loadOptionsFromFile(String optionsFileName, Env env, DBOptions dbOptions, List<ColumnFamilyDescriptor> cfDescs) throws RocksDBException {
        OptionsUtil.loadOptionsFromFile(optionsFileName, env, dbOptions, cfDescs, false);
    }

    public static void loadOptionsFromFile(String optionsFileName, Env env, DBOptions dbOptions, List<ColumnFamilyDescriptor> cfDescs, boolean ignoreUnknownOptions) throws RocksDBException {
        OptionsUtil.loadOptionsFromFile(optionsFileName, env.nativeHandle_, dbOptions.nativeHandle_, cfDescs, ignoreUnknownOptions);
    }

    public static void loadOptionsFromFile(ConfigOptions configOptions, String optionsFileName, DBOptions dbOptions, List<ColumnFamilyDescriptor> cfDescs) throws RocksDBException {
        OptionsUtil.loadOptionsFromFile(configOptions.nativeHandle_, optionsFileName, dbOptions.nativeHandle_, cfDescs);
    }

    public static String getLatestOptionsFileName(String dbPath, Env env) throws RocksDBException {
        return OptionsUtil.getLatestOptionsFileName(dbPath, env.nativeHandle_);
    }

    private OptionsUtil() {
    }

    private static native void loadLatestOptions(String var0, long var1, long var3, List<ColumnFamilyDescriptor> var5, boolean var6) throws RocksDBException;

    private static native void loadLatestOptions(long var0, String var2, long var3, List<ColumnFamilyDescriptor> var5) throws RocksDBException;

    private static native void loadOptionsFromFile(String var0, long var1, long var3, List<ColumnFamilyDescriptor> var5, boolean var6) throws RocksDBException;

    private static native void loadOptionsFromFile(long var0, String var2, long var3, List<ColumnFamilyDescriptor> var5) throws RocksDBException;

    private static native String getLatestOptionsFileName(String var0, long var1) throws RocksDBException;
}

