/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;

public class Checkpoint
extends RocksObject {
    private final RocksDB db_;

    public static Checkpoint create(RocksDB db) {
        if (db == null) {
            throw new IllegalArgumentException("RocksDB instance shall not be null.");
        }
        if (!db.isOwningHandle()) {
            throw new IllegalStateException("RocksDB instance must be initialized.");
        }
        Checkpoint checkpoint = new Checkpoint(db);
        return checkpoint;
    }

    public void createCheckpoint(String checkpointPath) throws RocksDBException {
        this.createCheckpoint(this.nativeHandle_, checkpointPath);
    }

    private Checkpoint(RocksDB db) {
        super(Checkpoint.newCheckpoint(db.nativeHandle_));
        this.db_ = db;
    }

    private static native long newCheckpoint(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native void createCheckpoint(long var1, String var3) throws RocksDBException;
}

