/*
 * Decompiled with CFR 0.152.
 */
package net.volcanite.util;

import java.util.Arrays;
import java.util.Objects;
import net.volcanite.util.Hash;

public final class Byte8Key {
    private static final byte[] MIN_KEY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] MAX_KEY = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
    private long curr;

    public static byte[] minKey() {
        return (byte[])MIN_KEY.clone();
    }

    public static byte[] maxKey() {
        return (byte[])MAX_KEY.clone();
    }

    public Byte8Key() {
        this.curr = Long.MIN_VALUE;
    }

    public Byte8Key(long startAt) {
        this.curr = startAt;
    }

    public Byte8Key(byte[] key) {
        if (Objects.requireNonNull(key).length != 8) {
            throw new IllegalArgumentException("wrong key length: " + key.length);
        }
        this.curr = Byte8Key.getLongB(key);
    }

    public byte[] next() {
        return Byte8Key.create(this.curr++);
    }

    public byte[] current() {
        return Byte8Key.create(this.curr);
    }

    public long currentValue() {
        return this.curr;
    }

    public void increment() {
        ++this.curr;
    }

    public void decrement() {
        --this.curr;
    }

    public long minus(Byte8Key other) {
        return this.curr - Objects.requireNonNull(other, (String)"other").curr;
    }

    public String toString() {
        return Arrays.toString(this.current());
    }

    public int hashCode() {
        int h = 524287 + (int)(this.curr ^ this.curr >>> 32);
        return Hash.hash32((h << 19) - h);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Byte8Key other = (Byte8Key)obj;
        return this.curr == other.curr;
    }

    private static byte[] create(long val) {
        return Byte8Key.putLongB(val, new byte[8]);
    }

    private static byte[] putLongB(long x, byte[] bytes) {
        bytes[0] = (byte)(x >> 56);
        bytes[1] = (byte)(x >> 48);
        bytes[2] = (byte)(x >> 40);
        bytes[3] = (byte)(x >> 32);
        bytes[4] = (byte)(x >> 24);
        bytes[5] = (byte)(x >> 16);
        bytes[6] = (byte)(x >> 8);
        bytes[7] = (byte)x;
        return bytes;
    }

    private static long getLongB(byte[] bytes) {
        return Byte8Key.makeLong(bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]);
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }
}

