/*
 * Decompiled with CFR 0.152.
 */
package net.volcanite.task;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.volcanite.task.AsyncTask;
import net.volcanite.util.DiscardOverflowsQueue;

public final class AsyncExecutor {
    private static final Logger logger = Logger.getLogger(AsyncExecutor.class.getName());
    private volatile ExecutorService executor = null;
    private volatile int queueCapacityDefault = 15000000;
    private volatile BlockingQueue<Runnable> queue = null;
    volatile String name;
    private static final AtomicInteger threadNumber = new AtomicInteger(1);

    public AsyncExecutor() {
        this("");
    }

    public AsyncExecutor(int queueCapacity) {
        this("", queueCapacity);
    }

    public AsyncExecutor(String name) {
        this.name = name == null || name.isEmpty() ? "" : name.trim();
    }

    public AsyncExecutor(String name, int queueCapacity) {
        this(name);
        this.queueCapacityDefault = queueCapacity <= 0 ? 1 : queueCapacity;
    }

    public void start() {
        if (this.executor == null || !this.isRunning()) {
            this.executor = this.newExecutorService(this.queueCapacityDefault);
        }
    }

    public void stop() {
        List<Runnable> tasksRemaining;
        if (this.isRunning() && (tasksRemaining = this.executor.shutdownNow()) != null && tasksRemaining.size() > 0) {
            logger.log(Level.WARNING, this.name + " was stopped. " + tasksRemaining.size() + " AsyncTasks haven't been processed.");
        }
        this.executor = null;
        this.queue = null;
    }

    public long stop(long timeoutMillis) {
        long elapsed = 0L;
        if (this.isRunning()) {
            long now;
            long millisRemaining;
            timeoutMillis = timeoutMillis < 31L ? 31L : timeoutMillis;
            long lastTime = System.nanoTime();
            long nanosTimeout = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
            while (this.queue != null && this.queue.size() > 0 && (millisRemaining = TimeUnit.NANOSECONDS.toMillis(nanosTimeout -= (now = System.nanoTime()) - (lastTime = now))) > 0L) {
                millisRemaining = millisRemaining > 16L ? 16L : millisRemaining;
                try {
                    Thread.sleep(millisRemaining);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                elapsed += (System.nanoTime() - lastTime) / 1000000L;
            }
            this.stop();
        }
        return elapsed;
    }

    public void execute(AsyncTask task) {
        if (task != null && this.isRunning()) {
            this.executor.execute(task);
        }
    }

    private boolean isRunning() {
        return this.executor != null && !this.executor.isShutdown();
    }

    public String getName() {
        return this.name;
    }

    private ExecutorService newExecutorService(int queueCapacity) {
        this.queue = new DiscardOverflowsQueue(queueCapacity);
        this.name = (this.name.isEmpty() ? AsyncExecutor.class.getSimpleName() : this.name) + "-Thread-" + threadNumber.getAndIncrement();
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.queue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(AsyncExecutor.this.name);
                return t;
            }
        }, new ThreadPoolExecutor.DiscardPolicy());
    }
}

