/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv.kueue;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.volcanite.util.Byte8Key;
import org.schwefel.kv.Kind;
import org.schwefel.kv.StoreOps;
import org.schwefel.kv.kueue.Kueue;
import org.schwefel.kv.kueue.KueueMsgConsumer;

class KueueImpl
implements Kueue {
    private Byte8Key minKey = new Byte8Key(Byte8Key.minKey());
    private Byte8Key maxKey = new Byte8Key(Byte8Key.minKey());
    private final StoreOps ops;
    private final Kind id;
    private final ReentrantLock putLock = new ReentrantLock(true);
    private final ReentrantLock takeLock = new ReentrantLock(true);
    private final Condition notEmpty = this.takeLock.newCondition();
    private final AtomicLong count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KueueImpl(StoreOps store, String identifier) {
        this.ops = Objects.requireNonNull(store, "store");
        this.id = store.getKindManagement().getOrCreateKind(Objects.requireNonNull(identifier, "identifier"));
        Byte8Key lastMax = this.maxKey;
        byte[] currentMin = null;
        byte[] currentMax = null;
        StoreOps storeOps = this.ops;
        synchronized (storeOps) {
            currentMin = this.ops.findMinKey(this.id);
            currentMax = this.ops.findMaxKey(this.id);
        }
        if (currentMin != null) {
            this.minKey = new Byte8Key(currentMin);
        }
        if (currentMax != null) {
            Byte8Key nextMax = new Byte8Key(currentMax);
            lastMax = new Byte8Key(nextMax.currentValue());
            nextMax.increment();
            this.maxKey = nextMax;
        }
        if (lastMax.currentValue() < this.minKey.currentValue()) {
            throw new IllegalStateException("maxKey < minKey");
        }
        long quantity = this.maxKey.minus(this.minKey);
        this.count = new AtomicLong(quantity);
    }

    @Override
    public long size() {
        return this.count.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public boolean isClosed() {
        return !this.ops.isOpen();
    }

    @Override
    public String identifier() {
        return this.id.name();
    }

    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    private void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    private void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    @Override
    public void put(byte[] value) {
        Objects.requireNonNull(value, "value");
        long c = -1L;
        ReentrantLock putLock = this.putLock;
        AtomicLong count = this.count;
        putLock.lock();
        try {
            this.ops.put(this.id, this.maxKey.next(), value);
            c = count.getAndIncrement();
        }
        catch (Throwable t) {
            this.maxKey.decrement();
            throw t;
        }
        finally {
            putLock.unlock();
        }
        if (c == 0L) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] take() throws InterruptedException {
        byte[] value;
        long c = -1L;
        ReentrantLock takeLock = this.takeLock;
        AtomicLong count = this.count;
        takeLock.lock();
        try {
            while (count.get() == 0L) {
                this.notEmpty.await();
            }
            value = this.ops.singleDeleteIfPresent(this.id, this.minKey.current());
            if (value != null) {
                c = count.getAndDecrement();
            }
            this.minKey.increment();
            if (c > 1L) {
                this.notEmpty.signal();
            }
        }
        finally {
            takeLock.unlock();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(KueueMsgConsumer consumer) {
        if (consumer == null) {
            return false;
        }
        if (this.count.get() == 0L) {
            return false;
        }
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            byte[] key = this.minKey.current();
            byte[] msg = this.ops.get(this.id, key);
            if (msg != null && consumer.accept(msg)) {
                this.ops.singleDelete(this.id, key);
                if (this.count.getAndDecrement() > 1L) {
                    this.notEmpty.signal();
                }
                this.minKey.increment();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            takeLock.unlock();
        }
        return false;
    }

    @Override
    public void clear() {
        this.fullyLock();
        try {
            AtomicLong count = this.count;
            while (count.get() > 0L) {
                byte[] value = this.ops.singleDeleteIfPresent(this.id, this.minKey.current());
                if (value != null) {
                    count.getAndDecrement();
                }
                this.minKey.increment();
            }
        }
        finally {
            this.fullyUnlock();
        }
    }
}

