/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.volcanite.task.AsyncTask;
import org.schwefel.kv.Batch;
import org.schwefel.kv.Kind;
import org.schwefel.kv.KindImpl;
import org.schwefel.kv.SortedByteArrayMap;
import org.schwefel.kv.StoreOps;

public final class TransmitBatchTask
implements AsyncTask {
    static final Logger logger = Logger.getLogger(TransmitBatchTask.class.getName());
    private final StoreOps store;
    private final KindImpl kind;
    private final SortedByteArrayMap keysValues;

    public TransmitBatchTask(StoreOps store, Kind kind, SortedByteArrayMap keysValues) {
        this.store = Objects.requireNonNull(store);
        this.kind = Objects.requireNonNull((KindImpl)kind);
        this.keysValues = Objects.requireNonNull(keysValues);
    }

    @Override
    public void run() {
        try {
            Batch batch = this.store.createBatch();
            this.keysValues.forEach(new BatchWriter(batch, this.kind));
            this.store.writeBatch(batch);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "", t);
        }
    }

    private static final class BatchWriter
    implements BiConsumer<byte[], byte[]> {
        private final Batch batch;
        private final KindImpl kind;

        BatchWriter(Batch batch, KindImpl kind) {
            this.batch = batch;
            this.kind = kind;
        }

        @Override
        public void accept(byte[] key, byte[] value) {
            if (key != null && key.length > 0) {
                try {
                    this.batch.put(this.kind, key, value);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "", t);
                }
            }
        }
    }
}

