/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class TableProperties {
    private final long dataSize;
    private final long indexSize;
    private final long indexPartitions;
    private final long topLevelIndexSize;
    private final long indexKeyIsUserKey;
    private final long indexValueIsDeltaEncoded;
    private final long filterSize;
    private final long rawKeySize;
    private final long rawValueSize;
    private final long numDataBlocks;
    private final long numEntries;
    private final long numDeletions;
    private final long numMergeOperands;
    private final long numRangeDeletions;
    private final long formatVersion;
    private final long fixedKeyLen;
    private final long columnFamilyId;
    private final long creationTime;
    private final long oldestKeyTime;
    private final long slowCompressionEstimatedDataSize;
    private final long fastCompressionEstimatedDataSize;
    private final byte[] columnFamilyName;
    private final String filterPolicyName;
    private final String comparatorName;
    private final String mergeOperatorName;
    private final String prefixExtractorName;
    private final String propertyCollectorsNames;
    private final String compressionName;
    private final Map<String, String> userCollectedProperties;
    private final Map<String, String> readableProperties;
    private final Map<String, Long> propertiesOffsets;

    TableProperties(long dataSize, long indexSize, long indexPartitions, long topLevelIndexSize, long indexKeyIsUserKey, long indexValueIsDeltaEncoded, long filterSize, long rawKeySize, long rawValueSize, long numDataBlocks, long numEntries, long numDeletions, long numMergeOperands, long numRangeDeletions, long formatVersion, long fixedKeyLen, long columnFamilyId, long creationTime, long oldestKeyTime, long slowCompressionEstimatedDataSize, long fastCompressionEstimatedDataSize, byte[] columnFamilyName, String filterPolicyName, String comparatorName, String mergeOperatorName, String prefixExtractorName, String propertyCollectorsNames, String compressionName, Map<String, String> userCollectedProperties, Map<String, String> readableProperties, Map<String, Long> propertiesOffsets) {
        this.dataSize = dataSize;
        this.indexSize = indexSize;
        this.indexPartitions = indexPartitions;
        this.topLevelIndexSize = topLevelIndexSize;
        this.indexKeyIsUserKey = indexKeyIsUserKey;
        this.indexValueIsDeltaEncoded = indexValueIsDeltaEncoded;
        this.filterSize = filterSize;
        this.rawKeySize = rawKeySize;
        this.rawValueSize = rawValueSize;
        this.numDataBlocks = numDataBlocks;
        this.numEntries = numEntries;
        this.numDeletions = numDeletions;
        this.numMergeOperands = numMergeOperands;
        this.numRangeDeletions = numRangeDeletions;
        this.formatVersion = formatVersion;
        this.fixedKeyLen = fixedKeyLen;
        this.columnFamilyId = columnFamilyId;
        this.creationTime = creationTime;
        this.oldestKeyTime = oldestKeyTime;
        this.slowCompressionEstimatedDataSize = slowCompressionEstimatedDataSize;
        this.fastCompressionEstimatedDataSize = fastCompressionEstimatedDataSize;
        this.columnFamilyName = columnFamilyName;
        this.filterPolicyName = filterPolicyName;
        this.comparatorName = comparatorName;
        this.mergeOperatorName = mergeOperatorName;
        this.prefixExtractorName = prefixExtractorName;
        this.propertyCollectorsNames = propertyCollectorsNames;
        this.compressionName = compressionName;
        this.userCollectedProperties = userCollectedProperties;
        this.readableProperties = readableProperties;
        this.propertiesOffsets = propertiesOffsets;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getIndexSize() {
        return this.indexSize;
    }

    public long getIndexPartitions() {
        return this.indexPartitions;
    }

    public long getTopLevelIndexSize() {
        return this.topLevelIndexSize;
    }

    public long getIndexKeyIsUserKey() {
        return this.indexKeyIsUserKey;
    }

    public long getIndexValueIsDeltaEncoded() {
        return this.indexValueIsDeltaEncoded;
    }

    public long getFilterSize() {
        return this.filterSize;
    }

    public long getRawKeySize() {
        return this.rawKeySize;
    }

    public long getRawValueSize() {
        return this.rawValueSize;
    }

    public long getNumDataBlocks() {
        return this.numDataBlocks;
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public long getNumDeletions() {
        return this.numDeletions;
    }

    public long getNumMergeOperands() {
        return this.numMergeOperands;
    }

    public long getNumRangeDeletions() {
        return this.numRangeDeletions;
    }

    public long getFormatVersion() {
        return this.formatVersion;
    }

    public long getFixedKeyLen() {
        return this.fixedKeyLen;
    }

    public long getColumnFamilyId() {
        return this.columnFamilyId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getOldestKeyTime() {
        return this.oldestKeyTime;
    }

    public long getSlowCompressionEstimatedDataSize() {
        return this.slowCompressionEstimatedDataSize;
    }

    public long getFastCompressionEstimatedDataSize() {
        return this.fastCompressionEstimatedDataSize;
    }

    public byte[] getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public String getFilterPolicyName() {
        return this.filterPolicyName;
    }

    public String getComparatorName() {
        return this.comparatorName;
    }

    public String getMergeOperatorName() {
        return this.mergeOperatorName;
    }

    public String getPrefixExtractorName() {
        return this.prefixExtractorName;
    }

    public String getPropertyCollectorsNames() {
        return this.propertyCollectorsNames;
    }

    public String getCompressionName() {
        return this.compressionName;
    }

    public Map<String, String> getUserCollectedProperties() {
        return this.userCollectedProperties;
    }

    public Map<String, String> getReadableProperties() {
        return this.readableProperties;
    }

    public Map<String, Long> getPropertiesOffsets() {
        return this.propertiesOffsets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableProperties that = (TableProperties)o;
        return this.dataSize == that.dataSize && this.indexSize == that.indexSize && this.indexPartitions == that.indexPartitions && this.topLevelIndexSize == that.topLevelIndexSize && this.indexKeyIsUserKey == that.indexKeyIsUserKey && this.indexValueIsDeltaEncoded == that.indexValueIsDeltaEncoded && this.filterSize == that.filterSize && this.rawKeySize == that.rawKeySize && this.rawValueSize == that.rawValueSize && this.numDataBlocks == that.numDataBlocks && this.numEntries == that.numEntries && this.numDeletions == that.numDeletions && this.numMergeOperands == that.numMergeOperands && this.numRangeDeletions == that.numRangeDeletions && this.formatVersion == that.formatVersion && this.fixedKeyLen == that.fixedKeyLen && this.columnFamilyId == that.columnFamilyId && this.creationTime == that.creationTime && this.oldestKeyTime == that.oldestKeyTime && this.slowCompressionEstimatedDataSize == that.slowCompressionEstimatedDataSize && this.fastCompressionEstimatedDataSize == that.fastCompressionEstimatedDataSize && Arrays.equals(this.columnFamilyName, that.columnFamilyName) && Objects.equals(this.filterPolicyName, that.filterPolicyName) && Objects.equals(this.comparatorName, that.comparatorName) && Objects.equals(this.mergeOperatorName, that.mergeOperatorName) && Objects.equals(this.prefixExtractorName, that.prefixExtractorName) && Objects.equals(this.propertyCollectorsNames, that.propertyCollectorsNames) && Objects.equals(this.compressionName, that.compressionName) && Objects.equals(this.userCollectedProperties, that.userCollectedProperties) && Objects.equals(this.readableProperties, that.readableProperties) && Objects.equals(this.propertiesOffsets, that.propertiesOffsets);
    }

    public int hashCode() {
        int result = Objects.hash(this.dataSize, this.indexSize, this.indexPartitions, this.topLevelIndexSize, this.indexKeyIsUserKey, this.indexValueIsDeltaEncoded, this.filterSize, this.rawKeySize, this.rawValueSize, this.numDataBlocks, this.numEntries, this.numDeletions, this.numMergeOperands, this.numRangeDeletions, this.formatVersion, this.fixedKeyLen, this.columnFamilyId, this.creationTime, this.oldestKeyTime, this.slowCompressionEstimatedDataSize, this.fastCompressionEstimatedDataSize, this.filterPolicyName, this.comparatorName, this.mergeOperatorName, this.prefixExtractorName, this.propertyCollectorsNames, this.compressionName, this.userCollectedProperties, this.readableProperties, this.propertiesOffsets);
        result = 31 * result + Arrays.hashCode(this.columnFamilyName);
        return result;
    }
}

