/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.rocksdb.util.Environment;

public class NativeLibraryLoader {
    private static final NativeLibraryLoader instance = new NativeLibraryLoader();
    private static boolean initialized = false;
    private static final String sharedLibraryName = Environment.getSharedLibraryName("rocksdb");
    private static final String jniLibraryName = Environment.getJniLibraryName("rocksdb");
    private static final String jniLibraryFileName = Environment.getJniLibraryFileName("rocksdb");
    private static final String tempFilePrefix = "librocksdbjni";
    private static final String tempFileSuffix = Environment.getJniLibraryExtension();

    public static NativeLibraryLoader getInstance() {
        return instance;
    }

    public synchronized void loadLibrary(String tmpDir) throws IOException {
        try {
            System.loadLibrary(sharedLibraryName);
        }
        catch (UnsatisfiedLinkError ule1) {
            try {
                System.loadLibrary(jniLibraryName);
            }
            catch (UnsatisfiedLinkError ule2) {
                this.loadLibraryFromJar(tmpDir);
            }
        }
    }

    void loadLibraryFromJar(String tmpDir) throws IOException {
        if (!initialized) {
            System.load(this.loadLibraryFromJarToTemp(tmpDir).getAbsolutePath());
            initialized = true;
        }
    }

    File loadLibraryFromJarToTemp(String tmpDir) throws IOException {
        File temp;
        if (tmpDir == null || tmpDir.isEmpty()) {
            temp = File.createTempFile(tempFilePrefix, tempFileSuffix);
        } else {
            File parentDir = new File(tmpDir);
            if (!parentDir.exists()) {
                throw new RuntimeException("Directory: " + parentDir.getAbsolutePath() + " does not exist!");
            }
            temp = new File(parentDir, jniLibraryFileName);
            if (temp.exists() && !temp.delete()) {
                throw new RuntimeException("File: " + temp.getAbsolutePath() + " already exists and cannot be removed.");
            }
            if (!temp.createNewFile()) {
                throw new RuntimeException("File: " + temp.getAbsolutePath() + " could not be created.");
            }
        }
        if (!temp.exists()) {
            throw new RuntimeException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        temp.deleteOnExit();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(jniLibraryFileName);){
            if (is == null) {
                throw new RuntimeException(jniLibraryFileName + " was not found inside JAR.");
            }
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return temp;
    }

    private NativeLibraryLoader() {
    }
}

