/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptionsInterface;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.ConcurrentTaskLimiter;
import org.rocksdb.ConfigOptions;
import org.rocksdb.DbPath;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.MutableColumnFamilyOptionsInterface;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.rocksdb.SstPartitionerFactory;
import org.rocksdb.TableFormatConfig;

public class ColumnFamilyOptions
extends RocksObject
implements ColumnFamilyOptionsInterface<ColumnFamilyOptions>,
MutableColumnFamilyOptionsInterface<ColumnFamilyOptions> {
    private MemTableConfig memTableConfig_;
    private TableFormatConfig tableFormatConfig_;
    private AbstractComparator comparator_;
    private AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter_;
    private AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory_;
    private CompactionOptionsUniversal compactionOptionsUniversal_;
    private CompactionOptionsFIFO compactionOptionsFIFO_;
    private CompressionOptions bottommostCompressionOptions_;
    private CompressionOptions compressionOptions_;
    private SstPartitionerFactory sstPartitionerFactory_;
    private ConcurrentTaskLimiter compactionThreadLimiter_;

    public ColumnFamilyOptions() {
        super(ColumnFamilyOptions.newColumnFamilyOptions());
    }

    public ColumnFamilyOptions(ColumnFamilyOptions other) {
        super(ColumnFamilyOptions.copyColumnFamilyOptions(other.nativeHandle_));
        this.memTableConfig_ = other.memTableConfig_;
        this.tableFormatConfig_ = other.tableFormatConfig_;
        this.comparator_ = other.comparator_;
        this.compactionFilter_ = other.compactionFilter_;
        this.compactionFilterFactory_ = other.compactionFilterFactory_;
        this.compactionOptionsUniversal_ = other.compactionOptionsUniversal_;
        this.compactionOptionsFIFO_ = other.compactionOptionsFIFO_;
        this.bottommostCompressionOptions_ = other.bottommostCompressionOptions_;
        this.compressionOptions_ = other.compressionOptions_;
        this.compactionThreadLimiter_ = other.compactionThreadLimiter_;
        this.sstPartitionerFactory_ = other.sstPartitionerFactory_;
    }

    public ColumnFamilyOptions(Options options) {
        super(ColumnFamilyOptions.newColumnFamilyOptionsFromOptions(options.nativeHandle_));
    }

    ColumnFamilyOptions(long handle) {
        super(handle);
    }

    public static ColumnFamilyOptions getColumnFamilyOptionsFromProps(Properties properties) {
        ColumnFamilyOptions columnFamilyOptions = null;
        long handle = ColumnFamilyOptions.getColumnFamilyOptionsFromProps(Options.getOptionStringFromProps(properties));
        if (handle != 0L) {
            columnFamilyOptions = new ColumnFamilyOptions(handle);
        }
        return columnFamilyOptions;
    }

    public static ColumnFamilyOptions getColumnFamilyOptionsFromProps(ConfigOptions cfgOpts, Properties properties) {
        ColumnFamilyOptions columnFamilyOptions = null;
        long handle = ColumnFamilyOptions.getColumnFamilyOptionsFromProps(cfgOpts.nativeHandle_, Options.getOptionStringFromProps(properties));
        if (handle != 0L) {
            columnFamilyOptions = new ColumnFamilyOptions(handle);
        }
        return columnFamilyOptions;
    }

    @Override
    public ColumnFamilyOptions oldDefaults(int majorVersion, int minorVersion) {
        ColumnFamilyOptions.oldDefaults(this.nativeHandle_, majorVersion, minorVersion);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeForSmallDb() {
        this.optimizeForSmallDb(this.nativeHandle_);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeForSmallDb(Cache cache) {
        ColumnFamilyOptions.optimizeForSmallDb(this.nativeHandle_, cache.getNativeHandle());
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeForPointLookup(long blockCacheSizeMb) {
        this.optimizeForPointLookup(this.nativeHandle_, blockCacheSizeMb);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeLevelStyleCompaction() {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeLevelStyleCompaction(long memtableMemoryBudget) {
        this.optimizeLevelStyleCompaction(this.nativeHandle_, memtableMemoryBudget);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeUniversalStyleCompaction() {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, 0x20000000L);
        return this;
    }

    @Override
    public ColumnFamilyOptions optimizeUniversalStyleCompaction(long memtableMemoryBudget) {
        this.optimizeUniversalStyleCompaction(this.nativeHandle_, memtableMemoryBudget);
        return this;
    }

    @Override
    public ColumnFamilyOptions setComparator(BuiltinComparator builtinComparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, builtinComparator.ordinal());
        return this;
    }

    @Override
    public ColumnFamilyOptions setComparator(AbstractComparator comparator) {
        assert (this.isOwningHandle());
        this.setComparatorHandle(this.nativeHandle_, comparator.nativeHandle_, comparator.getComparatorType().getValue());
        this.comparator_ = comparator;
        return this;
    }

    @Override
    public ColumnFamilyOptions setMergeOperatorName(String name) {
        assert (this.isOwningHandle());
        if (name == null) {
            throw new IllegalArgumentException("Merge operator name must not be null.");
        }
        this.setMergeOperatorName(this.nativeHandle_, name);
        return this;
    }

    @Override
    public ColumnFamilyOptions setMergeOperator(MergeOperator mergeOperator) {
        this.setMergeOperator(this.nativeHandle_, mergeOperator.nativeHandle_);
        return this;
    }

    @Override
    public ColumnFamilyOptions setCompactionFilter(AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter) {
        this.setCompactionFilterHandle(this.nativeHandle_, compactionFilter.nativeHandle_);
        this.compactionFilter_ = compactionFilter;
        return this;
    }

    @Override
    public AbstractCompactionFilter<? extends AbstractSlice<?>> compactionFilter() {
        assert (this.isOwningHandle());
        return this.compactionFilter_;
    }

    @Override
    public ColumnFamilyOptions setCompactionFilterFactory(AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory) {
        assert (this.isOwningHandle());
        this.setCompactionFilterFactoryHandle(this.nativeHandle_, compactionFilterFactory.nativeHandle_);
        this.compactionFilterFactory_ = compactionFilterFactory;
        return this;
    }

    @Override
    public AbstractCompactionFilterFactory<? extends AbstractCompactionFilter<?>> compactionFilterFactory() {
        assert (this.isOwningHandle());
        return this.compactionFilterFactory_;
    }

    public ColumnFamilyOptions setWriteBufferSize(long writeBufferSize) {
        assert (this.isOwningHandle());
        this.setWriteBufferSize(this.nativeHandle_, writeBufferSize);
        return this;
    }

    @Override
    public long writeBufferSize() {
        assert (this.isOwningHandle());
        return this.writeBufferSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxWriteBufferNumber(int maxWriteBufferNumber) {
        assert (this.isOwningHandle());
        this.setMaxWriteBufferNumber(this.nativeHandle_, maxWriteBufferNumber);
        return this;
    }

    @Override
    public int maxWriteBufferNumber() {
        assert (this.isOwningHandle());
        return this.maxWriteBufferNumber(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMinWriteBufferNumberToMerge(int minWriteBufferNumberToMerge) {
        this.setMinWriteBufferNumberToMerge(this.nativeHandle_, minWriteBufferNumberToMerge);
        return this;
    }

    @Override
    public int minWriteBufferNumberToMerge() {
        return this.minWriteBufferNumberToMerge(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions useFixedLengthPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useFixedLengthPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public ColumnFamilyOptions useCappedPrefixExtractor(int n) {
        assert (this.isOwningHandle());
        this.useCappedPrefixExtractor(this.nativeHandle_, n);
        return this;
    }

    @Override
    public ColumnFamilyOptions setCompressionType(CompressionType compressionType) {
        this.setCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompressionType compressionType() {
        return CompressionType.getCompressionType(this.compressionType(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setCompressionPerLevel(List<CompressionType> compressionLevels) {
        byte[] byteCompressionTypes = new byte[compressionLevels.size()];
        for (int i = 0; i < compressionLevels.size(); ++i) {
            byteCompressionTypes[i] = compressionLevels.get(i).getValue();
        }
        this.setCompressionPerLevel(this.nativeHandle_, byteCompressionTypes);
        return this;
    }

    @Override
    public List<CompressionType> compressionPerLevel() {
        byte[] byteCompressionTypes = this.compressionPerLevel(this.nativeHandle_);
        ArrayList<CompressionType> compressionLevels = new ArrayList<CompressionType>();
        for (byte byteCompressionType : byteCompressionTypes) {
            compressionLevels.add(CompressionType.getCompressionType(byteCompressionType));
        }
        return compressionLevels;
    }

    @Override
    public ColumnFamilyOptions setBottommostCompressionType(CompressionType bottommostCompressionType) {
        this.setBottommostCompressionType(this.nativeHandle_, bottommostCompressionType.getValue());
        return this;
    }

    @Override
    public CompressionType bottommostCompressionType() {
        return CompressionType.getCompressionType(this.bottommostCompressionType(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setBottommostCompressionOptions(CompressionOptions bottommostCompressionOptions) {
        this.setBottommostCompressionOptions(this.nativeHandle_, bottommostCompressionOptions.nativeHandle_);
        this.bottommostCompressionOptions_ = bottommostCompressionOptions;
        return this;
    }

    @Override
    public CompressionOptions bottommostCompressionOptions() {
        return this.bottommostCompressionOptions_;
    }

    @Override
    public ColumnFamilyOptions setCompressionOptions(CompressionOptions compressionOptions) {
        this.setCompressionOptions(this.nativeHandle_, compressionOptions.nativeHandle_);
        this.compressionOptions_ = compressionOptions;
        return this;
    }

    @Override
    public CompressionOptions compressionOptions() {
        return this.compressionOptions_;
    }

    @Override
    public ColumnFamilyOptions setNumLevels(int numLevels) {
        this.setNumLevels(this.nativeHandle_, numLevels);
        return this;
    }

    @Override
    public int numLevels() {
        return this.numLevels(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroFileNumCompactionTrigger(int numFiles) {
        this.setLevelZeroFileNumCompactionTrigger(this.nativeHandle_, numFiles);
        return this;
    }

    @Override
    public int levelZeroFileNumCompactionTrigger() {
        return this.levelZeroFileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroSlowdownWritesTrigger(int numFiles) {
        this.setLevelZeroSlowdownWritesTrigger(this.nativeHandle_, numFiles);
        return this;
    }

    @Override
    public int levelZeroSlowdownWritesTrigger() {
        return this.levelZeroSlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelZeroStopWritesTrigger(int numFiles) {
        this.setLevelZeroStopWritesTrigger(this.nativeHandle_, numFiles);
        return this;
    }

    @Override
    public int levelZeroStopWritesTrigger() {
        return this.levelZeroStopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTargetFileSizeBase(long targetFileSizeBase) {
        this.setTargetFileSizeBase(this.nativeHandle_, targetFileSizeBase);
        return this;
    }

    @Override
    public long targetFileSizeBase() {
        return this.targetFileSizeBase(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTargetFileSizeMultiplier(int multiplier) {
        this.setTargetFileSizeMultiplier(this.nativeHandle_, multiplier);
        return this;
    }

    @Override
    public int targetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelBase(long maxBytesForLevelBase) {
        this.setMaxBytesForLevelBase(this.nativeHandle_, maxBytesForLevelBase);
        return this;
    }

    @Override
    public long maxBytesForLevelBase() {
        return this.maxBytesForLevelBase(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevelCompactionDynamicLevelBytes(boolean enableLevelCompactionDynamicLevelBytes) {
        this.setLevelCompactionDynamicLevelBytes(this.nativeHandle_, enableLevelCompactionDynamicLevelBytes);
        return this;
    }

    @Override
    public boolean levelCompactionDynamicLevelBytes() {
        return this.levelCompactionDynamicLevelBytes(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelMultiplier(double multiplier) {
        this.setMaxBytesForLevelMultiplier(this.nativeHandle_, multiplier);
        return this;
    }

    @Override
    public double maxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxCompactionBytes(long maxCompactionBytes) {
        this.setMaxCompactionBytes(this.nativeHandle_, maxCompactionBytes);
        return this;
    }

    @Override
    public long maxCompactionBytes() {
        return this.maxCompactionBytes(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setArenaBlockSize(long arenaBlockSize) {
        this.setArenaBlockSize(this.nativeHandle_, arenaBlockSize);
        return this;
    }

    @Override
    public long arenaBlockSize() {
        return this.arenaBlockSize(this.nativeHandle_);
    }

    public ColumnFamilyOptions setDisableAutoCompactions(boolean disableAutoCompactions) {
        this.setDisableAutoCompactions(this.nativeHandle_, disableAutoCompactions);
        return this;
    }

    @Override
    public boolean disableAutoCompactions() {
        return this.disableAutoCompactions(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCompactionStyle(CompactionStyle compactionStyle) {
        this.setCompactionStyle(this.nativeHandle_, compactionStyle.getValue());
        return this;
    }

    @Override
    public CompactionStyle compactionStyle() {
        return CompactionStyle.fromValue(this.compactionStyle(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setMaxTableFilesSizeFIFO(long maxTableFilesSize) {
        assert (maxTableFilesSize > 0L);
        assert (this.isOwningHandle());
        this.setMaxTableFilesSizeFIFO(this.nativeHandle_, maxTableFilesSize);
        return this;
    }

    @Override
    public long maxTableFilesSizeFIFO() {
        return this.maxTableFilesSizeFIFO(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxSequentialSkipInIterations(long maxSequentialSkipInIterations) {
        this.setMaxSequentialSkipInIterations(this.nativeHandle_, maxSequentialSkipInIterations);
        return this;
    }

    @Override
    public long maxSequentialSkipInIterations() {
        return this.maxSequentialSkipInIterations(this.nativeHandle_);
    }

    @Override
    public MemTableConfig memTableConfig() {
        return this.memTableConfig_;
    }

    @Override
    public ColumnFamilyOptions setMemTableConfig(MemTableConfig memTableConfig) {
        this.setMemTableFactory(this.nativeHandle_, memTableConfig.newMemTableFactoryHandle());
        this.memTableConfig_ = memTableConfig;
        return this;
    }

    @Override
    public String memTableFactoryName() {
        assert (this.isOwningHandle());
        return this.memTableFactoryName(this.nativeHandle_);
    }

    @Override
    public TableFormatConfig tableFormatConfig() {
        return this.tableFormatConfig_;
    }

    @Override
    public ColumnFamilyOptions setTableFormatConfig(TableFormatConfig tableFormatConfig) {
        this.setTableFactory(this.nativeHandle_, tableFormatConfig.newTableFactoryHandle());
        this.tableFormatConfig_ = tableFormatConfig;
        return this;
    }

    @Override
    public String tableFactoryName() {
        assert (this.isOwningHandle());
        return this.tableFactoryName(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCfPaths(Collection<DbPath> cfPaths) {
        assert (this.isOwningHandle());
        int len = cfPaths.size();
        String[] paths = new String[len];
        long[] targetSizes = new long[len];
        int i = 0;
        for (DbPath dbPath : cfPaths) {
            paths[i] = dbPath.path.toString();
            targetSizes[i] = dbPath.targetSize;
            ++i;
        }
        ColumnFamilyOptions.setCfPaths(this.nativeHandle_, paths, targetSizes);
        return this;
    }

    @Override
    public List<DbPath> cfPaths() {
        int len = (int)ColumnFamilyOptions.cfPathsLen(this.nativeHandle_);
        if (len == 0) {
            return Collections.emptyList();
        }
        String[] paths = new String[len];
        long[] targetSizes = new long[len];
        ColumnFamilyOptions.cfPaths(this.nativeHandle_, paths, targetSizes);
        ArrayList<DbPath> cfPaths = new ArrayList<DbPath>();
        for (int i = 0; i < len; ++i) {
            cfPaths.add(new DbPath(Paths.get(paths[i], new String[0]), targetSizes[i]));
        }
        return cfPaths;
    }

    @Override
    public ColumnFamilyOptions setInplaceUpdateSupport(boolean inplaceUpdateSupport) {
        this.setInplaceUpdateSupport(this.nativeHandle_, inplaceUpdateSupport);
        return this;
    }

    @Override
    public boolean inplaceUpdateSupport() {
        return this.inplaceUpdateSupport(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setInplaceUpdateNumLocks(long inplaceUpdateNumLocks) {
        this.setInplaceUpdateNumLocks(this.nativeHandle_, inplaceUpdateNumLocks);
        return this;
    }

    @Override
    public long inplaceUpdateNumLocks() {
        return this.inplaceUpdateNumLocks(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMemtablePrefixBloomSizeRatio(double memtablePrefixBloomSizeRatio) {
        this.setMemtablePrefixBloomSizeRatio(this.nativeHandle_, memtablePrefixBloomSizeRatio);
        return this;
    }

    @Override
    public double memtablePrefixBloomSizeRatio() {
        return this.memtablePrefixBloomSizeRatio(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setBloomLocality(int bloomLocality) {
        this.setBloomLocality(this.nativeHandle_, bloomLocality);
        return this;
    }

    @Override
    public int bloomLocality() {
        return this.bloomLocality(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxSuccessiveMerges(long maxSuccessiveMerges) {
        this.setMaxSuccessiveMerges(this.nativeHandle_, maxSuccessiveMerges);
        return this;
    }

    @Override
    public long maxSuccessiveMerges() {
        return this.maxSuccessiveMerges(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setOptimizeFiltersForHits(boolean optimizeFiltersForHits) {
        this.setOptimizeFiltersForHits(this.nativeHandle_, optimizeFiltersForHits);
        return this;
    }

    @Override
    public boolean optimizeFiltersForHits() {
        return this.optimizeFiltersForHits(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMemtableHugePageSize(long memtableHugePageSize) {
        this.setMemtableHugePageSize(this.nativeHandle_, memtableHugePageSize);
        return this;
    }

    @Override
    public long memtableHugePageSize() {
        return this.memtableHugePageSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setSoftPendingCompactionBytesLimit(long softPendingCompactionBytesLimit) {
        this.setSoftPendingCompactionBytesLimit(this.nativeHandle_, softPendingCompactionBytesLimit);
        return this;
    }

    @Override
    public long softPendingCompactionBytesLimit() {
        return this.softPendingCompactionBytesLimit(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setHardPendingCompactionBytesLimit(long hardPendingCompactionBytesLimit) {
        this.setHardPendingCompactionBytesLimit(this.nativeHandle_, hardPendingCompactionBytesLimit);
        return this;
    }

    @Override
    public long hardPendingCompactionBytesLimit() {
        return this.hardPendingCompactionBytesLimit(this.nativeHandle_);
    }

    public ColumnFamilyOptions setLevel0FileNumCompactionTrigger(int level0FileNumCompactionTrigger) {
        this.setLevel0FileNumCompactionTrigger(this.nativeHandle_, level0FileNumCompactionTrigger);
        return this;
    }

    @Override
    public int level0FileNumCompactionTrigger() {
        return this.level0FileNumCompactionTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevel0SlowdownWritesTrigger(int level0SlowdownWritesTrigger) {
        this.setLevel0SlowdownWritesTrigger(this.nativeHandle_, level0SlowdownWritesTrigger);
        return this;
    }

    @Override
    public int level0SlowdownWritesTrigger() {
        return this.level0SlowdownWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setLevel0StopWritesTrigger(int level0StopWritesTrigger) {
        this.setLevel0StopWritesTrigger(this.nativeHandle_, level0StopWritesTrigger);
        return this;
    }

    @Override
    public int level0StopWritesTrigger() {
        return this.level0StopWritesTrigger(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxBytesForLevelMultiplierAdditional(int[] maxBytesForLevelMultiplierAdditional) {
        this.setMaxBytesForLevelMultiplierAdditional(this.nativeHandle_, maxBytesForLevelMultiplierAdditional);
        return this;
    }

    @Override
    public int[] maxBytesForLevelMultiplierAdditional() {
        return this.maxBytesForLevelMultiplierAdditional(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setParanoidFileChecks(boolean paranoidFileChecks) {
        this.setParanoidFileChecks(this.nativeHandle_, paranoidFileChecks);
        return this;
    }

    @Override
    public boolean paranoidFileChecks() {
        return this.paranoidFileChecks(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMaxWriteBufferNumberToMaintain(int maxWriteBufferNumberToMaintain) {
        this.setMaxWriteBufferNumberToMaintain(this.nativeHandle_, maxWriteBufferNumberToMaintain);
        return this;
    }

    @Override
    public int maxWriteBufferNumberToMaintain() {
        return this.maxWriteBufferNumberToMaintain(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCompactionPriority(CompactionPriority compactionPriority) {
        this.setCompactionPriority(this.nativeHandle_, compactionPriority.getValue());
        return this;
    }

    @Override
    public CompactionPriority compactionPriority() {
        return CompactionPriority.getCompactionPriority(this.compactionPriority(this.nativeHandle_));
    }

    @Override
    public ColumnFamilyOptions setReportBgIoStats(boolean reportBgIoStats) {
        this.setReportBgIoStats(this.nativeHandle_, reportBgIoStats);
        return this;
    }

    @Override
    public boolean reportBgIoStats() {
        return this.reportBgIoStats(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setTtl(long ttl) {
        this.setTtl(this.nativeHandle_, ttl);
        return this;
    }

    @Override
    public long ttl() {
        return this.ttl(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setPeriodicCompactionSeconds(long periodicCompactionSeconds) {
        this.setPeriodicCompactionSeconds(this.nativeHandle_, periodicCompactionSeconds);
        return this;
    }

    @Override
    public long periodicCompactionSeconds() {
        return this.periodicCompactionSeconds(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setCompactionOptionsUniversal(CompactionOptionsUniversal compactionOptionsUniversal) {
        this.setCompactionOptionsUniversal(this.nativeHandle_, compactionOptionsUniversal.nativeHandle_);
        this.compactionOptionsUniversal_ = compactionOptionsUniversal;
        return this;
    }

    @Override
    public CompactionOptionsUniversal compactionOptionsUniversal() {
        return this.compactionOptionsUniversal_;
    }

    @Override
    public ColumnFamilyOptions setCompactionOptionsFIFO(CompactionOptionsFIFO compactionOptionsFIFO) {
        this.setCompactionOptionsFIFO(this.nativeHandle_, compactionOptionsFIFO.nativeHandle_);
        this.compactionOptionsFIFO_ = compactionOptionsFIFO;
        return this;
    }

    @Override
    public CompactionOptionsFIFO compactionOptionsFIFO() {
        return this.compactionOptionsFIFO_;
    }

    @Override
    public ColumnFamilyOptions setForceConsistencyChecks(boolean forceConsistencyChecks) {
        this.setForceConsistencyChecks(this.nativeHandle_, forceConsistencyChecks);
        return this;
    }

    @Override
    public boolean forceConsistencyChecks() {
        return this.forceConsistencyChecks(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setSstPartitionerFactory(SstPartitionerFactory sstPartitionerFactory) {
        this.setSstPartitionerFactory(this.nativeHandle_, sstPartitionerFactory.nativeHandle_);
        this.sstPartitionerFactory_ = sstPartitionerFactory;
        return this;
    }

    @Override
    public ColumnFamilyOptions setCompactionThreadLimiter(ConcurrentTaskLimiter compactionThreadLimiter) {
        ColumnFamilyOptions.setCompactionThreadLimiter(this.nativeHandle_, compactionThreadLimiter.nativeHandle_);
        this.compactionThreadLimiter_ = compactionThreadLimiter;
        return this;
    }

    @Override
    public ConcurrentTaskLimiter compactionThreadLimiter() {
        assert (this.isOwningHandle());
        return this.compactionThreadLimiter_;
    }

    @Override
    public SstPartitionerFactory sstPartitionerFactory() {
        return this.sstPartitionerFactory_;
    }

    @Override
    public ColumnFamilyOptions setEnableBlobFiles(boolean enableBlobFiles) {
        this.setEnableBlobFiles(this.nativeHandle_, enableBlobFiles);
        return this;
    }

    @Override
    public boolean enableBlobFiles() {
        return this.enableBlobFiles(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setMinBlobSize(long minBlobSize) {
        this.setMinBlobSize(this.nativeHandle_, minBlobSize);
        return this;
    }

    @Override
    public long minBlobSize() {
        return this.minBlobSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setBlobFileSize(long blobFileSize) {
        this.setBlobFileSize(this.nativeHandle_, blobFileSize);
        return this;
    }

    @Override
    public long blobFileSize() {
        return this.blobFileSize(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setBlobCompressionType(CompressionType compressionType) {
        this.setBlobCompressionType(this.nativeHandle_, compressionType.getValue());
        return this;
    }

    @Override
    public CompressionType blobCompressionType() {
        return CompressionType.values()[this.blobCompressionType(this.nativeHandle_)];
    }

    @Override
    public ColumnFamilyOptions setEnableBlobGarbageCollection(boolean enableBlobGarbageCollection) {
        this.setEnableBlobGarbageCollection(this.nativeHandle_, enableBlobGarbageCollection);
        return this;
    }

    @Override
    public boolean enableBlobGarbageCollection() {
        return this.enableBlobGarbageCollection(this.nativeHandle_);
    }

    @Override
    public ColumnFamilyOptions setBlobGarbageCollectionAgeCutoff(double blobGarbageCollectionAgeCutoff) {
        this.setBlobGarbageCollectionAgeCutoff(this.nativeHandle_, blobGarbageCollectionAgeCutoff);
        return this;
    }

    @Override
    public double blobGarbageCollectionAgeCutoff() {
        return this.blobGarbageCollectionAgeCutoff(this.nativeHandle_);
    }

    private static native long getColumnFamilyOptionsFromProps(long var0, String var2);

    private static native long getColumnFamilyOptionsFromProps(String var0);

    private static native long newColumnFamilyOptions();

    private static native long copyColumnFamilyOptions(long var0);

    private static native long newColumnFamilyOptionsFromOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private static native void oldDefaults(long var0, int var2, int var3);

    private native void optimizeForSmallDb(long var1);

    private static native void optimizeForSmallDb(long var0, long var2);

    private native void optimizeForPointLookup(long var1, long var3);

    private native void optimizeLevelStyleCompaction(long var1, long var3);

    private native void optimizeUniversalStyleCompaction(long var1, long var3);

    private native void setComparatorHandle(long var1, int var3);

    private native void setComparatorHandle(long var1, long var3, byte var5);

    private native void setMergeOperatorName(long var1, String var3);

    private native void setMergeOperator(long var1, long var3);

    private native void setCompactionFilterHandle(long var1, long var3);

    private native void setCompactionFilterFactoryHandle(long var1, long var3);

    private native void setWriteBufferSize(long var1, long var3) throws IllegalArgumentException;

    private native long writeBufferSize(long var1);

    private native void setMaxWriteBufferNumber(long var1, int var3);

    private native int maxWriteBufferNumber(long var1);

    private native void setMinWriteBufferNumberToMerge(long var1, int var3);

    private native int minWriteBufferNumberToMerge(long var1);

    private native void setCompressionType(long var1, byte var3);

    private native byte compressionType(long var1);

    private native void setCompressionPerLevel(long var1, byte[] var3);

    private native byte[] compressionPerLevel(long var1);

    private native void setBottommostCompressionType(long var1, byte var3);

    private native byte bottommostCompressionType(long var1);

    private native void setBottommostCompressionOptions(long var1, long var3);

    private native void setCompressionOptions(long var1, long var3);

    private native void useFixedLengthPrefixExtractor(long var1, int var3);

    private native void useCappedPrefixExtractor(long var1, int var3);

    private native void setNumLevels(long var1, int var3);

    private native int numLevels(long var1);

    private native void setLevelZeroFileNumCompactionTrigger(long var1, int var3);

    private native int levelZeroFileNumCompactionTrigger(long var1);

    private native void setLevelZeroSlowdownWritesTrigger(long var1, int var3);

    private native int levelZeroSlowdownWritesTrigger(long var1);

    private native void setLevelZeroStopWritesTrigger(long var1, int var3);

    private native int levelZeroStopWritesTrigger(long var1);

    private native void setTargetFileSizeBase(long var1, long var3);

    private native long targetFileSizeBase(long var1);

    private native void setTargetFileSizeMultiplier(long var1, int var3);

    private native int targetFileSizeMultiplier(long var1);

    private native void setMaxBytesForLevelBase(long var1, long var3);

    private native long maxBytesForLevelBase(long var1);

    private native void setLevelCompactionDynamicLevelBytes(long var1, boolean var3);

    private native boolean levelCompactionDynamicLevelBytes(long var1);

    private native void setMaxBytesForLevelMultiplier(long var1, double var3);

    private native double maxBytesForLevelMultiplier(long var1);

    private native void setMaxCompactionBytes(long var1, long var3);

    private native long maxCompactionBytes(long var1);

    private native void setArenaBlockSize(long var1, long var3) throws IllegalArgumentException;

    private native long arenaBlockSize(long var1);

    private native void setDisableAutoCompactions(long var1, boolean var3);

    private native boolean disableAutoCompactions(long var1);

    private native void setCompactionStyle(long var1, byte var3);

    private native byte compactionStyle(long var1);

    private native void setMaxTableFilesSizeFIFO(long var1, long var3);

    private native long maxTableFilesSizeFIFO(long var1);

    private native void setMaxSequentialSkipInIterations(long var1, long var3);

    private native long maxSequentialSkipInIterations(long var1);

    private native void setMemTableFactory(long var1, long var3);

    private native String memTableFactoryName(long var1);

    private native void setTableFactory(long var1, long var3);

    private native String tableFactoryName(long var1);

    private static native void setCfPaths(long var0, String[] var2, long[] var3);

    private static native long cfPathsLen(long var0);

    private static native void cfPaths(long var0, String[] var2, long[] var3);

    private native void setInplaceUpdateSupport(long var1, boolean var3);

    private native boolean inplaceUpdateSupport(long var1);

    private native void setInplaceUpdateNumLocks(long var1, long var3) throws IllegalArgumentException;

    private native long inplaceUpdateNumLocks(long var1);

    private native void setMemtablePrefixBloomSizeRatio(long var1, double var3);

    private native double memtablePrefixBloomSizeRatio(long var1);

    private native void setBloomLocality(long var1, int var3);

    private native int bloomLocality(long var1);

    private native void setMaxSuccessiveMerges(long var1, long var3) throws IllegalArgumentException;

    private native long maxSuccessiveMerges(long var1);

    private native void setOptimizeFiltersForHits(long var1, boolean var3);

    private native boolean optimizeFiltersForHits(long var1);

    private native void setMemtableHugePageSize(long var1, long var3);

    private native long memtableHugePageSize(long var1);

    private native void setSoftPendingCompactionBytesLimit(long var1, long var3);

    private native long softPendingCompactionBytesLimit(long var1);

    private native void setHardPendingCompactionBytesLimit(long var1, long var3);

    private native long hardPendingCompactionBytesLimit(long var1);

    private native void setLevel0FileNumCompactionTrigger(long var1, int var3);

    private native int level0FileNumCompactionTrigger(long var1);

    private native void setLevel0SlowdownWritesTrigger(long var1, int var3);

    private native int level0SlowdownWritesTrigger(long var1);

    private native void setLevel0StopWritesTrigger(long var1, int var3);

    private native int level0StopWritesTrigger(long var1);

    private native void setMaxBytesForLevelMultiplierAdditional(long var1, int[] var3);

    private native int[] maxBytesForLevelMultiplierAdditional(long var1);

    private native void setParanoidFileChecks(long var1, boolean var3);

    private native boolean paranoidFileChecks(long var1);

    private native void setMaxWriteBufferNumberToMaintain(long var1, int var3);

    private native int maxWriteBufferNumberToMaintain(long var1);

    private native void setCompactionPriority(long var1, byte var3);

    private native byte compactionPriority(long var1);

    private native void setReportBgIoStats(long var1, boolean var3);

    private native boolean reportBgIoStats(long var1);

    private native void setTtl(long var1, long var3);

    private native long ttl(long var1);

    private native void setPeriodicCompactionSeconds(long var1, long var3);

    private native long periodicCompactionSeconds(long var1);

    private native void setCompactionOptionsUniversal(long var1, long var3);

    private native void setCompactionOptionsFIFO(long var1, long var3);

    private native void setForceConsistencyChecks(long var1, boolean var3);

    private native boolean forceConsistencyChecks(long var1);

    private native void setSstPartitionerFactory(long var1, long var3);

    private static native void setCompactionThreadLimiter(long var0, long var2);

    private native void setEnableBlobFiles(long var1, boolean var3);

    private native boolean enableBlobFiles(long var1);

    private native void setMinBlobSize(long var1, long var3);

    private native long minBlobSize(long var1);

    private native void setBlobFileSize(long var1, long var3);

    private native long blobFileSize(long var1);

    private native void setBlobCompressionType(long var1, byte var3);

    private native byte blobCompressionType(long var1);

    private native void setEnableBlobGarbageCollection(long var1, boolean var3);

    private native boolean enableBlobGarbageCollection(long var1);

    private native void setBlobGarbageCollectionAgeCutoff(long var1, double var3);

    private native double blobGarbageCollectionAgeCutoff(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

