/*
 * Decompiled with CFR 0.152.
 */
package org.schwefel.kv;

import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksIterator;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionDB;
import org.schwefel.kv.LexicographicByteArrayComparator;
import org.schwefel.kv.Stats;

final class MinMaxKeyIt {
    private static final BytePredicate GREATER = new BytePredicate(){

        @Override
        public boolean test(byte keyByte, byte prefixByte) {
            return (keyByte & 0xFF) - (prefixByte & 0xFF) > 0;
        }
    };
    private static final BytePredicate LESS = new BytePredicate(){

        @Override
        public boolean test(byte keyByte, byte prefixByte) {
            return (keyByte & 0xFF) - (prefixByte & 0xFF) < 0;
        }
    };

    MinMaxKeyIt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] findMaxKeyLessThan(RocksIterator iter, Stats stats, byte[] keyPrefix, byte[] upperBound) {
        try {
            if (iter.isOwningHandle()) {
                iter.seekForPrev(upperBound);
                byte[] key = null;
                if (iter.isValid() && (key = iter.key()) != null && LexicographicByteArrayComparator.lexicographicalCompare(key, upperBound) == 0) {
                    iter.prev();
                }
                while (iter.isValid() && (key = iter.key()) != null && MinMaxKeyIt.prefixOfKeyOtherThanKeyPrefix(key, keyPrefix, GREATER)) {
                    iter.prev();
                }
                if (MinMaxKeyIt.keyStartsWithPrefix(key, keyPrefix) && LexicographicByteArrayComparator.lexicographicalCompare(key, upperBound) < 0) {
                    byte[] byArray = key;
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (iter.isOwningHandle()) {
                iter.close();
                stats.decOpenCursorsCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] findMinKeyGreaterThan(RocksIterator iter, Stats stats, byte[] keyPrefix, byte[] lowerBound) {
        try {
            if (iter.isOwningHandle()) {
                iter.seek(lowerBound);
                byte[] key = null;
                if (iter.isValid() && (key = iter.key()) != null && LexicographicByteArrayComparator.lexicographicalCompare(key, lowerBound) == 0) {
                    iter.next();
                }
                while (iter.isValid() && (key = iter.key()) != null && MinMaxKeyIt.prefixOfKeyOtherThanKeyPrefix(key, keyPrefix, LESS)) {
                    iter.next();
                }
                if (MinMaxKeyIt.keyStartsWithPrefix(key, keyPrefix) && LexicographicByteArrayComparator.lexicographicalCompare(key, lowerBound) > 0) {
                    byte[] byArray = key;
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (iter.isOwningHandle()) {
                iter.close();
                stats.decOpenCursorsCount();
            }
        }
    }

    static byte[] findMinKey(RocksIterator iter, Stats stats) {
        try {
            if (iter.isOwningHandle()) {
                iter.seekToFirst();
                if (iter.isValid()) {
                    byte[] byArray = iter.key();
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (iter.isOwningHandle()) {
                iter.close();
                stats.decOpenCursorsCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] findMinKey(RocksIterator iter, Stats stats, byte[] keyPrefix) {
        try {
            if (iter.isOwningHandle()) {
                byte[] key;
                iter.seek(keyPrefix);
                if (iter.isValid() && MinMaxKeyIt.keyStartsWithPrefix(key = iter.key(), keyPrefix)) {
                    byte[] byArray = key;
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (iter.isOwningHandle()) {
                iter.close();
                stats.decOpenCursorsCount();
            }
        }
    }

    static byte[] findMaxKey(RocksIterator iter, Stats stats) {
        try {
            if (iter.isOwningHandle()) {
                iter.seekToLast();
                if (iter.isValid()) {
                    byte[] byArray = iter.key();
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (iter.isOwningHandle()) {
                iter.close();
                stats.decOpenCursorsCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] findMaxKey(RocksIterator iter, Stats stats, byte[] keyPrefix) {
        try {
            if (iter.isOwningHandle()) {
                iter.seek(keyPrefix);
                byte[] key = null;
                byte[] max = null;
                while (iter.isValid() && (key = iter.key()) != null && MinMaxKeyIt.keyStartsWithPrefix(key, keyPrefix)) {
                    max = key;
                    iter.next();
                }
                if (MinMaxKeyIt.keyStartsWithPrefix(max, keyPrefix)) {
                    byte[] byArray = max;
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (iter.isOwningHandle()) {
                iter.close();
                stats.decOpenCursorsCount();
            }
        }
    }

    /*
     * Exception decompiling
     */
    static byte[] findMinKeyByLowerBound(TransactionDB txnDb, ColumnFamilyHandle cfHandle, Stats stats, byte[] lowerBound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static byte[] findMaxKeyByUpperBound(TransactionDB txnDb, ColumnFamilyHandle cfHandle, Stats stats, byte[] upperBound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static byte[] findMinKeyByLowerBound(Transaction txn, ColumnFamilyHandle cfHandle, Stats stats, byte[] lowerBound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static byte[] findMaxKeyByUpperBound(Transaction txn, ColumnFamilyHandle cfHandle, Stats stats, byte[] upperBound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean prefixOfKeyOtherThanKeyPrefix(byte[] key, byte[] keyPrefix, BytePredicate comparator) {
        if (key == null || keyPrefix == null) {
            return false;
        }
        int len = Math.min(key.length, keyPrefix.length);
        for (int i = 0; i < len; ++i) {
            if (key[i] == keyPrefix[i]) continue;
            return comparator.test(key[i], keyPrefix[i]);
        }
        return false;
    }

    private static boolean keyStartsWithPrefix(byte[] key, byte[] prefix) {
        if (key == null || prefix == null) {
            return false;
        }
        if (key.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (key[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private static interface BytePredicate {
        public boolean test(byte var1, byte var2);
    }
}

