/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.rocksdb.AbstractMutableOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.MutableColumnFamilyOptionsInterface;
import org.rocksdb.MutableOptionKey;

public class MutableColumnFamilyOptions
extends AbstractMutableOptions {
    MutableColumnFamilyOptions(String[] keys, String[] values) {
        super(keys, values);
    }

    public static MutableColumnFamilyOptionsBuilder builder() {
        return new MutableColumnFamilyOptionsBuilder();
    }

    public static MutableColumnFamilyOptionsBuilder parse(String str) {
        String[] options;
        Objects.requireNonNull(str);
        MutableColumnFamilyOptionsBuilder builder = new MutableColumnFamilyOptionsBuilder();
        for (String option : options = str.trim().split(";")) {
            int equalsOffset = option.indexOf(61);
            if (equalsOffset <= 0) {
                throw new IllegalArgumentException("options string has an invalid key=value pair");
            }
            String key = option.substring(0, equalsOffset);
            if (key.isEmpty()) {
                throw new IllegalArgumentException("options string is invalid");
            }
            String value = option.substring(equalsOffset + 1);
            if (value.isEmpty()) {
                throw new IllegalArgumentException("options string is invalid");
            }
            builder.fromString(key, value);
        }
        return builder;
    }

    public static class MutableColumnFamilyOptionsBuilder
    extends AbstractMutableOptions.AbstractMutableOptionsBuilder<MutableColumnFamilyOptions, MutableColumnFamilyOptionsBuilder, MutableColumnFamilyOptionKey>
    implements MutableColumnFamilyOptionsInterface<MutableColumnFamilyOptionsBuilder> {
        private static final Map<String, MutableColumnFamilyOptionKey> ALL_KEYS_LOOKUP = new HashMap<String, MutableColumnFamilyOptionKey>();

        MutableColumnFamilyOptionsBuilder() {
        }

        @Override
        protected MutableColumnFamilyOptionsBuilder self() {
            return this;
        }

        @Override
        protected Map<String, MutableColumnFamilyOptionKey> allKeys() {
            return ALL_KEYS_LOOKUP;
        }

        @Override
        protected MutableColumnFamilyOptions build(String[] keys, String[] values) {
            return new MutableColumnFamilyOptions(keys, values);
        }

        public MutableColumnFamilyOptionsBuilder setWriteBufferSize(long writeBufferSize) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(MemtableOption.write_buffer_size, writeBufferSize);
        }

        @Override
        public long writeBufferSize() {
            return this.getLong(MemtableOption.write_buffer_size);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setArenaBlockSize(long arenaBlockSize) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(MemtableOption.arena_block_size, arenaBlockSize);
        }

        @Override
        public long arenaBlockSize() {
            return this.getLong(MemtableOption.arena_block_size);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMemtablePrefixBloomSizeRatio(double memtablePrefixBloomSizeRatio) {
            return (MutableColumnFamilyOptionsBuilder)this.setDouble(MemtableOption.memtable_prefix_bloom_size_ratio, memtablePrefixBloomSizeRatio);
        }

        @Override
        public double memtablePrefixBloomSizeRatio() {
            return this.getDouble(MemtableOption.memtable_prefix_bloom_size_ratio);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMemtableHugePageSize(long memtableHugePageSize) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(MemtableOption.memtable_huge_page_size, memtableHugePageSize);
        }

        @Override
        public long memtableHugePageSize() {
            return this.getLong(MemtableOption.memtable_huge_page_size);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxSuccessiveMerges(long maxSuccessiveMerges) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(MemtableOption.max_successive_merges, maxSuccessiveMerges);
        }

        @Override
        public long maxSuccessiveMerges() {
            return this.getLong(MemtableOption.max_successive_merges);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxWriteBufferNumber(int maxWriteBufferNumber) {
            return (MutableColumnFamilyOptionsBuilder)this.setInt(MemtableOption.max_write_buffer_number, maxWriteBufferNumber);
        }

        @Override
        public int maxWriteBufferNumber() {
            return this.getInt(MemtableOption.max_write_buffer_number);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setInplaceUpdateNumLocks(long inplaceUpdateNumLocks) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(MemtableOption.inplace_update_num_locks, inplaceUpdateNumLocks);
        }

        @Override
        public long inplaceUpdateNumLocks() {
            return this.getLong(MemtableOption.inplace_update_num_locks);
        }

        public MutableColumnFamilyOptionsBuilder setDisableAutoCompactions(boolean disableAutoCompactions) {
            return (MutableColumnFamilyOptionsBuilder)this.setBoolean(CompactionOption.disable_auto_compactions, disableAutoCompactions);
        }

        @Override
        public boolean disableAutoCompactions() {
            return this.getBoolean(CompactionOption.disable_auto_compactions);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setSoftPendingCompactionBytesLimit(long softPendingCompactionBytesLimit) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(CompactionOption.soft_pending_compaction_bytes_limit, softPendingCompactionBytesLimit);
        }

        @Override
        public long softPendingCompactionBytesLimit() {
            return this.getLong(CompactionOption.soft_pending_compaction_bytes_limit);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setHardPendingCompactionBytesLimit(long hardPendingCompactionBytesLimit) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(CompactionOption.hard_pending_compaction_bytes_limit, hardPendingCompactionBytesLimit);
        }

        @Override
        public long hardPendingCompactionBytesLimit() {
            return this.getLong(CompactionOption.hard_pending_compaction_bytes_limit);
        }

        public MutableColumnFamilyOptionsBuilder setLevel0FileNumCompactionTrigger(int level0FileNumCompactionTrigger) {
            return (MutableColumnFamilyOptionsBuilder)this.setInt(CompactionOption.level0_file_num_compaction_trigger, level0FileNumCompactionTrigger);
        }

        @Override
        public int level0FileNumCompactionTrigger() {
            return this.getInt(CompactionOption.level0_file_num_compaction_trigger);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setLevel0SlowdownWritesTrigger(int level0SlowdownWritesTrigger) {
            return (MutableColumnFamilyOptionsBuilder)this.setInt(CompactionOption.level0_slowdown_writes_trigger, level0SlowdownWritesTrigger);
        }

        @Override
        public int level0SlowdownWritesTrigger() {
            return this.getInt(CompactionOption.level0_slowdown_writes_trigger);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setLevel0StopWritesTrigger(int level0StopWritesTrigger) {
            return (MutableColumnFamilyOptionsBuilder)this.setInt(CompactionOption.level0_stop_writes_trigger, level0StopWritesTrigger);
        }

        @Override
        public int level0StopWritesTrigger() {
            return this.getInt(CompactionOption.level0_stop_writes_trigger);
        }

        public MutableColumnFamilyOptionsBuilder setMaxCompactionBytes(long maxCompactionBytes) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(CompactionOption.max_compaction_bytes, maxCompactionBytes);
        }

        @Override
        public long maxCompactionBytes() {
            return this.getLong(CompactionOption.max_compaction_bytes);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setTargetFileSizeBase(long targetFileSizeBase) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(CompactionOption.target_file_size_base, targetFileSizeBase);
        }

        @Override
        public long targetFileSizeBase() {
            return this.getLong(CompactionOption.target_file_size_base);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setTargetFileSizeMultiplier(int targetFileSizeMultiplier) {
            return (MutableColumnFamilyOptionsBuilder)this.setInt(CompactionOption.target_file_size_multiplier, targetFileSizeMultiplier);
        }

        @Override
        public int targetFileSizeMultiplier() {
            return this.getInt(CompactionOption.target_file_size_multiplier);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxBytesForLevelBase(long maxBytesForLevelBase) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(CompactionOption.max_bytes_for_level_base, maxBytesForLevelBase);
        }

        @Override
        public long maxBytesForLevelBase() {
            return this.getLong(CompactionOption.max_bytes_for_level_base);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxBytesForLevelMultiplier(double maxBytesForLevelMultiplier) {
            return (MutableColumnFamilyOptionsBuilder)this.setDouble(CompactionOption.max_bytes_for_level_multiplier, maxBytesForLevelMultiplier);
        }

        @Override
        public double maxBytesForLevelMultiplier() {
            return this.getDouble(CompactionOption.max_bytes_for_level_multiplier);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxBytesForLevelMultiplierAdditional(int[] maxBytesForLevelMultiplierAdditional) {
            return (MutableColumnFamilyOptionsBuilder)this.setIntArray(CompactionOption.max_bytes_for_level_multiplier_additional, maxBytesForLevelMultiplierAdditional);
        }

        @Override
        public int[] maxBytesForLevelMultiplierAdditional() {
            return this.getIntArray(CompactionOption.max_bytes_for_level_multiplier_additional);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setMaxSequentialSkipInIterations(long maxSequentialSkipInIterations) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(MiscOption.max_sequential_skip_in_iterations, maxSequentialSkipInIterations);
        }

        @Override
        public long maxSequentialSkipInIterations() {
            return this.getLong(MiscOption.max_sequential_skip_in_iterations);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setParanoidFileChecks(boolean paranoidFileChecks) {
            return (MutableColumnFamilyOptionsBuilder)this.setBoolean(MiscOption.paranoid_file_checks, paranoidFileChecks);
        }

        @Override
        public boolean paranoidFileChecks() {
            return this.getBoolean(MiscOption.paranoid_file_checks);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setCompressionType(CompressionType compressionType) {
            return (MutableColumnFamilyOptionsBuilder)this.setEnum(MiscOption.compression_type, compressionType);
        }

        @Override
        public CompressionType compressionType() {
            return (CompressionType)((Object)this.getEnum(MiscOption.compression_type));
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setReportBgIoStats(boolean reportBgIoStats) {
            return (MutableColumnFamilyOptionsBuilder)this.setBoolean(MiscOption.report_bg_io_stats, reportBgIoStats);
        }

        @Override
        public boolean reportBgIoStats() {
            return this.getBoolean(MiscOption.report_bg_io_stats);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setTtl(long ttl) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(CompactionOption.ttl, ttl);
        }

        @Override
        public long ttl() {
            return this.getLong(CompactionOption.ttl);
        }

        @Override
        public MutableColumnFamilyOptionsBuilder setPeriodicCompactionSeconds(long periodicCompactionSeconds) {
            return (MutableColumnFamilyOptionsBuilder)this.setLong(CompactionOption.periodic_compaction_seconds, periodicCompactionSeconds);
        }

        @Override
        public long periodicCompactionSeconds() {
            return this.getLong(CompactionOption.periodic_compaction_seconds);
        }

        static {
            for (MemtableOption memtableOption : MemtableOption.values()) {
                ALL_KEYS_LOOKUP.put(memtableOption.name(), memtableOption);
            }
            for (Enum enum_ : CompactionOption.values()) {
                ALL_KEYS_LOOKUP.put(enum_.name(), (MutableColumnFamilyOptionKey)((Object)enum_));
            }
            for (Enum enum_ : MiscOption.values()) {
                ALL_KEYS_LOOKUP.put(enum_.name(), (MutableColumnFamilyOptionKey)((Object)enum_));
            }
        }
    }

    public static enum MiscOption implements MutableColumnFamilyOptionKey
    {
        max_sequential_skip_in_iterations(MutableOptionKey.ValueType.LONG),
        paranoid_file_checks(MutableOptionKey.ValueType.BOOLEAN),
        report_bg_io_stats(MutableOptionKey.ValueType.BOOLEAN),
        compression_type(MutableOptionKey.ValueType.ENUM);

        private final MutableOptionKey.ValueType valueType;

        private MiscOption(MutableOptionKey.ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public MutableOptionKey.ValueType getValueType() {
            return this.valueType;
        }
    }

    public static enum CompactionOption implements MutableColumnFamilyOptionKey
    {
        disable_auto_compactions(MutableOptionKey.ValueType.BOOLEAN),
        soft_rate_limit(MutableOptionKey.ValueType.DOUBLE),
        soft_pending_compaction_bytes_limit(MutableOptionKey.ValueType.LONG),
        hard_rate_limit(MutableOptionKey.ValueType.DOUBLE),
        hard_pending_compaction_bytes_limit(MutableOptionKey.ValueType.LONG),
        level0_file_num_compaction_trigger(MutableOptionKey.ValueType.INT),
        level0_slowdown_writes_trigger(MutableOptionKey.ValueType.INT),
        level0_stop_writes_trigger(MutableOptionKey.ValueType.INT),
        max_compaction_bytes(MutableOptionKey.ValueType.LONG),
        target_file_size_base(MutableOptionKey.ValueType.LONG),
        target_file_size_multiplier(MutableOptionKey.ValueType.INT),
        max_bytes_for_level_base(MutableOptionKey.ValueType.LONG),
        max_bytes_for_level_multiplier(MutableOptionKey.ValueType.INT),
        max_bytes_for_level_multiplier_additional(MutableOptionKey.ValueType.INT_ARRAY),
        ttl(MutableOptionKey.ValueType.LONG),
        periodic_compaction_seconds(MutableOptionKey.ValueType.LONG);

        private final MutableOptionKey.ValueType valueType;

        private CompactionOption(MutableOptionKey.ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public MutableOptionKey.ValueType getValueType() {
            return this.valueType;
        }
    }

    public static enum MemtableOption implements MutableColumnFamilyOptionKey
    {
        write_buffer_size(MutableOptionKey.ValueType.LONG),
        arena_block_size(MutableOptionKey.ValueType.LONG),
        memtable_prefix_bloom_size_ratio(MutableOptionKey.ValueType.DOUBLE),
        memtable_prefix_bloom_bits(MutableOptionKey.ValueType.INT),
        memtable_prefix_bloom_probes(MutableOptionKey.ValueType.INT),
        memtable_huge_page_size(MutableOptionKey.ValueType.LONG),
        max_successive_merges(MutableOptionKey.ValueType.LONG),
        filter_deletes(MutableOptionKey.ValueType.BOOLEAN),
        max_write_buffer_number(MutableOptionKey.ValueType.INT),
        inplace_update_num_locks(MutableOptionKey.ValueType.LONG);

        private final MutableOptionKey.ValueType valueType;

        private MemtableOption(MutableOptionKey.ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public MutableOptionKey.ValueType getValueType() {
            return this.valueType;
        }
    }

    private static interface MutableColumnFamilyOptionKey
    extends MutableOptionKey {
    }
}

