/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import org.rocksdb.Env;
import org.rocksdb.Logger;
import org.rocksdb.RateLimiter;
import org.rocksdb.RocksObject;

public class BackupableDBOptions
extends RocksObject {
    private Env backupEnv = null;
    private Logger infoLog = null;
    private RateLimiter backupRateLimiter = null;
    private RateLimiter restoreRateLimiter = null;

    public BackupableDBOptions(String path) {
        super(BackupableDBOptions.newBackupableDBOptions(BackupableDBOptions.ensureWritableFile(path)));
    }

    private static String ensureWritableFile(String path) {
        File backupPath;
        File file = backupPath = path == null ? null : new File(path);
        if (backupPath == null || !backupPath.isDirectory() || !backupPath.canWrite()) {
            throw new IllegalArgumentException("Illegal path provided.");
        }
        return path;
    }

    public String backupDir() {
        assert (this.isOwningHandle());
        return this.backupDir(this.nativeHandle_);
    }

    public BackupableDBOptions setBackupEnv(Env env) {
        assert (this.isOwningHandle());
        this.setBackupEnv(this.nativeHandle_, env.nativeHandle_);
        this.backupEnv = env;
        return this;
    }

    public Env backupEnv() {
        return this.backupEnv;
    }

    public BackupableDBOptions setShareTableFiles(boolean shareTableFiles) {
        assert (this.isOwningHandle());
        this.setShareTableFiles(this.nativeHandle_, shareTableFiles);
        return this;
    }

    public boolean shareTableFiles() {
        assert (this.isOwningHandle());
        return this.shareTableFiles(this.nativeHandle_);
    }

    public BackupableDBOptions setInfoLog(Logger logger) {
        assert (this.isOwningHandle());
        this.setInfoLog(this.nativeHandle_, logger.nativeHandle_);
        this.infoLog = logger;
        return this;
    }

    public Logger infoLog() {
        return this.infoLog;
    }

    public BackupableDBOptions setSync(boolean sync) {
        assert (this.isOwningHandle());
        this.setSync(this.nativeHandle_, sync);
        return this;
    }

    public boolean sync() {
        assert (this.isOwningHandle());
        return this.sync(this.nativeHandle_);
    }

    public BackupableDBOptions setDestroyOldData(boolean destroyOldData) {
        assert (this.isOwningHandle());
        this.setDestroyOldData(this.nativeHandle_, destroyOldData);
        return this;
    }

    public boolean destroyOldData() {
        assert (this.isOwningHandle());
        return this.destroyOldData(this.nativeHandle_);
    }

    public BackupableDBOptions setBackupLogFiles(boolean backupLogFiles) {
        assert (this.isOwningHandle());
        this.setBackupLogFiles(this.nativeHandle_, backupLogFiles);
        return this;
    }

    public boolean backupLogFiles() {
        assert (this.isOwningHandle());
        return this.backupLogFiles(this.nativeHandle_);
    }

    public BackupableDBOptions setBackupRateLimit(long backupRateLimit) {
        assert (this.isOwningHandle());
        backupRateLimit = backupRateLimit <= 0L ? 0L : backupRateLimit;
        this.setBackupRateLimit(this.nativeHandle_, backupRateLimit);
        return this;
    }

    public long backupRateLimit() {
        assert (this.isOwningHandle());
        return this.backupRateLimit(this.nativeHandle_);
    }

    public BackupableDBOptions setBackupRateLimiter(RateLimiter backupRateLimiter) {
        assert (this.isOwningHandle());
        this.setBackupRateLimiter(this.nativeHandle_, backupRateLimiter.nativeHandle_);
        this.backupRateLimiter = backupRateLimiter;
        return this;
    }

    public RateLimiter backupRateLimiter() {
        assert (this.isOwningHandle());
        return this.backupRateLimiter;
    }

    public BackupableDBOptions setRestoreRateLimit(long restoreRateLimit) {
        assert (this.isOwningHandle());
        restoreRateLimit = restoreRateLimit <= 0L ? 0L : restoreRateLimit;
        this.setRestoreRateLimit(this.nativeHandle_, restoreRateLimit);
        return this;
    }

    public long restoreRateLimit() {
        assert (this.isOwningHandle());
        return this.restoreRateLimit(this.nativeHandle_);
    }

    public BackupableDBOptions setRestoreRateLimiter(RateLimiter restoreRateLimiter) {
        assert (this.isOwningHandle());
        this.setRestoreRateLimiter(this.nativeHandle_, restoreRateLimiter.nativeHandle_);
        this.restoreRateLimiter = restoreRateLimiter;
        return this;
    }

    public RateLimiter restoreRateLimiter() {
        assert (this.isOwningHandle());
        return this.restoreRateLimiter;
    }

    public BackupableDBOptions setShareFilesWithChecksum(boolean shareFilesWithChecksum) {
        assert (this.isOwningHandle());
        this.setShareFilesWithChecksum(this.nativeHandle_, shareFilesWithChecksum);
        return this;
    }

    public boolean shareFilesWithChecksum() {
        assert (this.isOwningHandle());
        return this.shareFilesWithChecksum(this.nativeHandle_);
    }

    public BackupableDBOptions setMaxBackgroundOperations(int maxBackgroundOperations) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundOperations(this.nativeHandle_, maxBackgroundOperations);
        return this;
    }

    public int maxBackgroundOperations() {
        assert (this.isOwningHandle());
        return this.maxBackgroundOperations(this.nativeHandle_);
    }

    public BackupableDBOptions setCallbackTriggerIntervalSize(long callbackTriggerIntervalSize) {
        assert (this.isOwningHandle());
        this.setCallbackTriggerIntervalSize(this.nativeHandle_, callbackTriggerIntervalSize);
        return this;
    }

    public long callbackTriggerIntervalSize() {
        assert (this.isOwningHandle());
        return this.callbackTriggerIntervalSize(this.nativeHandle_);
    }

    private static native long newBackupableDBOptions(String var0);

    private native String backupDir(long var1);

    private native void setBackupEnv(long var1, long var3);

    private native void setShareTableFiles(long var1, boolean var3);

    private native boolean shareTableFiles(long var1);

    private native void setInfoLog(long var1, long var3);

    private native void setSync(long var1, boolean var3);

    private native boolean sync(long var1);

    private native void setDestroyOldData(long var1, boolean var3);

    private native boolean destroyOldData(long var1);

    private native void setBackupLogFiles(long var1, boolean var3);

    private native boolean backupLogFiles(long var1);

    private native void setBackupRateLimit(long var1, long var3);

    private native long backupRateLimit(long var1);

    private native void setBackupRateLimiter(long var1, long var3);

    private native void setRestoreRateLimit(long var1, long var3);

    private native long restoreRateLimit(long var1);

    private native void setRestoreRateLimiter(long var1, long var3);

    private native void setShareFilesWithChecksum(long var1, boolean var3);

    private native boolean shareFilesWithChecksum(long var1);

    private native void setMaxBackgroundOperations(long var1, int var3);

    private native int maxBackgroundOperations(long var1);

    private native void setCallbackTriggerIntervalSize(long var1, long var3);

    private native long callbackTriggerIntervalSize(long var1);

    @Override
    protected final native void disposeInternal(long var1);
}

