/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.rocksdb.MutableOptionKey;
import org.rocksdb.MutableOptionValue;

public abstract class AbstractMutableOptions {
    protected static final String KEY_VALUE_PAIR_SEPARATOR = ";";
    protected static final char KEY_VALUE_SEPARATOR = '=';
    static final String INT_ARRAY_INT_SEPARATOR = ",";
    protected final String[] keys;
    private final String[] values;

    protected AbstractMutableOptions(String[] keys, String[] values) {
        this.keys = keys;
        this.values = values;
    }

    String[] getKeys() {
        return this.keys;
    }

    String[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.keys.length; ++i) {
            buffer.append(this.keys[i]).append('=').append(this.values[i]);
            if (i + 1 >= this.keys.length) continue;
            buffer.append(KEY_VALUE_PAIR_SEPARATOR);
        }
        return buffer.toString();
    }

    public static abstract class AbstractMutableOptionsBuilder<T extends AbstractMutableOptions, U extends AbstractMutableOptionsBuilder<T, U, K>, K extends MutableOptionKey> {
        private final Map<K, MutableOptionValue<?>> options = new LinkedHashMap();

        protected abstract U self();

        protected abstract Map<String, K> allKeys();

        protected abstract T build(String[] var1, String[] var2);

        public T build() {
            String[] keys = new String[this.options.size()];
            String[] values = new String[this.options.size()];
            int i = 0;
            for (Map.Entry<K, MutableOptionValue<?>> option : this.options.entrySet()) {
                keys[i] = ((MutableOptionKey)option.getKey()).name();
                values[i] = option.getValue().asString();
                ++i;
            }
            return this.build(keys, values);
        }

        protected U setDouble(K key, double value) {
            if (key.getValueType() != MutableOptionKey.ValueType.DOUBLE) {
                throw new IllegalArgumentException(key + " does not accept a double value");
            }
            this.options.put(key, MutableOptionValue.fromDouble(value));
            return this.self();
        }

        protected double getDouble(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asDouble();
        }

        protected U setLong(K key, long value) {
            if (key.getValueType() != MutableOptionKey.ValueType.LONG) {
                throw new IllegalArgumentException(key + " does not accept a long value");
            }
            this.options.put(key, MutableOptionValue.fromLong(value));
            return this.self();
        }

        protected long getLong(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asLong();
        }

        protected U setInt(K key, int value) {
            if (key.getValueType() != MutableOptionKey.ValueType.INT) {
                throw new IllegalArgumentException(key + " does not accept an integer value");
            }
            this.options.put(key, MutableOptionValue.fromInt(value));
            return this.self();
        }

        protected int getInt(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asInt();
        }

        protected U setBoolean(K key, boolean value) {
            if (key.getValueType() != MutableOptionKey.ValueType.BOOLEAN) {
                throw new IllegalArgumentException(key + " does not accept a boolean value");
            }
            this.options.put(key, MutableOptionValue.fromBoolean(value));
            return this.self();
        }

        protected boolean getBoolean(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asBoolean();
        }

        protected U setIntArray(K key, int[] value) {
            if (key.getValueType() != MutableOptionKey.ValueType.INT_ARRAY) {
                throw new IllegalArgumentException(key + " does not accept an int array value");
            }
            this.options.put(key, MutableOptionValue.fromIntArray(value));
            return this.self();
        }

        protected int[] getIntArray(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            return value.asIntArray();
        }

        protected <N extends Enum<N>> U setEnum(K key, N value) {
            if (key.getValueType() != MutableOptionKey.ValueType.ENUM) {
                throw new IllegalArgumentException(key + " does not accept a Enum value");
            }
            this.options.put(key, MutableOptionValue.fromEnum(value));
            return this.self();
        }

        protected <N extends Enum<N>> N getEnum(K key) throws NoSuchElementException, NumberFormatException {
            MutableOptionValue<?> value = this.options.get(key);
            if (value == null) {
                throw new NoSuchElementException(key.name() + " has not been set");
            }
            if (!(value instanceof MutableOptionValue.MutableOptionEnumValue)) {
                throw new NoSuchElementException(key.name() + " is not of Enum type");
            }
            return (N)((Enum)((MutableOptionValue.MutableOptionEnumValue)value).asObject());
        }

        public U fromString(String keyStr, String valueStr) throws IllegalArgumentException {
            Objects.requireNonNull(keyStr);
            Objects.requireNonNull(valueStr);
            MutableOptionKey key = (MutableOptionKey)this.allKeys().get(keyStr);
            switch (key.getValueType()) {
                case DOUBLE: {
                    return this.setDouble(key, Double.parseDouble(valueStr));
                }
                case LONG: {
                    return this.setLong(key, Long.parseLong(valueStr));
                }
                case INT: {
                    return this.setInt(key, Integer.parseInt(valueStr));
                }
                case BOOLEAN: {
                    return this.setBoolean(key, Boolean.parseBoolean(valueStr));
                }
                case INT_ARRAY: {
                    String[] strInts = valueStr.trim().split(AbstractMutableOptions.INT_ARRAY_INT_SEPARATOR);
                    if (strInts == null || strInts.length == 0) {
                        throw new IllegalArgumentException("int array value is not correctly formatted");
                    }
                    int[] value = new int[strInts.length];
                    int i = 0;
                    for (String strInt : strInts) {
                        value[i++] = Integer.parseInt(strInt);
                    }
                    return this.setIntArray(key, value);
                }
            }
            throw new IllegalStateException(key + " has unknown value type: " + (Object)((Object)key.getValueType()));
        }
    }
}

