/*
 * Decompiled with CFR 0.152.
 */
package java9.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java9.util.concurrent.UnsafeAccess;
import sun.misc.Unsafe;

final class TLRandom {
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long THREADLOCALS;
    private static final long INHERITABLETHREADLOCALS;
    private static final long INHERITEDACCESSCONTROLCONTEXT;
    private static final long CCL;
    private static final long PROBE;
    private static final long SECONDARY;
    private static final AtomicInteger probeGenerator;
    private static final AtomicLong seeder;

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    private static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private TLRandom() {
    }

    static final void localInit() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        long seed = TLRandom.mix64(seeder.getAndAdd(-4942790177534073029L));
        TLRandom.utilizeSeed(seed);
        TLRandom.setThreadLocalRandomProbe(probe);
    }

    static final int getProbe() {
        return TLRandom.getThreadLocalRandomProbe();
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        TLRandom.setThreadLocalRandomProbe(probe);
        return probe;
    }

    static final int nextSecondarySeed() {
        int r = TLRandom.getThreadLocalRandomSecondarySeed();
        if (r != 0) {
            r ^= r << 13;
            r ^= r >>> 17;
            r ^= r << 5;
        } else {
            r = TLRandom.mix32(seeder.getAndAdd(-4942790177534073029L));
            if (r == 0) {
                r = 1;
            }
        }
        TLRandom.setThreadLocalRandomSecondarySeed(r);
        return r;
    }

    private static void utilizeSeed(long seed) {
        Objects.requireNonNull(seed);
    }

    private static int getThreadLocalRandomProbe() {
        return U.getInt(Thread.currentThread(), PROBE);
    }

    private static void setThreadLocalRandomProbe(int probe) {
        U.putInt(Thread.currentThread(), PROBE, probe);
    }

    private static int getThreadLocalRandomSecondarySeed() {
        return U.getInt(Thread.currentThread(), SECONDARY);
    }

    private static void setThreadLocalRandomSecondarySeed(int secondary) {
        U.putInt(Thread.currentThread(), SECONDARY, secondary);
    }

    static final void eraseThreadLocals(Thread thread) {
        U.putObject(thread, THREADLOCALS, null);
        U.putObject(thread, INHERITABLETHREADLOCALS, null);
    }

    static final void setInheritedAccessControlContext(Thread thread, AccessControlContext acc) {
        U.putOrderedObject(thread, INHERITEDACCESSCONTROLCONTEXT, acc);
    }

    static final void setContextClassLoader(Thread thread, ClassLoader ccl) {
        U.putObject(thread, CCL, ccl);
    }

    static {
        try {
            THREADLOCALS = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocals"));
            INHERITABLETHREADLOCALS = U.objectFieldOffset(Thread.class.getDeclaredField("inheritableThreadLocals"));
            INHERITEDACCESSCONTROLCONTEXT = U.objectFieldOffset(Thread.class.getDeclaredField("inheritedAccessControlContext"));
            CCL = U.objectFieldOffset(Thread.class.getDeclaredField("contextClassLoader"));
            PROBE = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocalRandomProbe"));
            SECONDARY = U.objectFieldOffset(Thread.class.getDeclaredField("threadLocalRandomSecondarySeed"));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        probeGenerator = new AtomicInteger();
        seeder = new AtomicLong(TLRandom.mix64(System.currentTimeMillis()) ^ TLRandom.mix64(System.nanoTime()));
        if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("java.util.secureRandomSeed");
            }
        }).booleanValue()) {
            byte[] seedBytes = SecureRandom.getSeed(8);
            long s = (long)seedBytes[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                s = s << 8 | (long)seedBytes[i] & 0xFFL;
            }
            seeder.set(s);
        }
    }
}

