/*
 * Decompiled with CFR 0.152.
 */
package java9.util.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java9.util.concurrent.CompletableFuture;
import java9.util.concurrent.Flow;
import java9.util.concurrent.ForkJoinPool;
import java9.util.concurrent.ForkJoinTask;
import java9.util.concurrent.UnsafeAccess;
import sun.misc.Unsafe;

public class SubmissionPublisher<T>
implements Flow.Publisher<T>,
AutoCloseable {
    static final int BUFFER_CAPACITY_LIMIT = 0x40000000;
    static final int INITIAL_CAPACITY = 32;
    private static final Executor ASYNC_POOL = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();
    BufferedSubscription<T> clients;
    final ReentrantLock lock;
    volatile boolean closed;
    boolean subscribed;
    Thread owner;
    volatile Throwable closedException;
    final Executor executor;
    final BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler;
    final int maxBufferCapacity;

    static final int roundCapacity(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) <= 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public SubmissionPublisher(Executor executor, int maxBufferCapacity, BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> handler) {
        Objects.requireNonNull(executor);
        if (maxBufferCapacity <= 0) {
            throw new IllegalArgumentException("capacity must be positive");
        }
        this.lock = new ReentrantLock();
        this.executor = executor;
        this.onNextHandler = handler;
        this.maxBufferCapacity = SubmissionPublisher.roundCapacity(maxBufferCapacity);
    }

    public SubmissionPublisher(Executor executor, int maxBufferCapacity) {
        this(executor, maxBufferCapacity, null);
    }

    public SubmissionPublisher() {
        this(ASYNC_POOL, Flow.defaultBufferSize(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        ReentrantLock lock = this.lock;
        int max = this.maxBufferCapacity;
        Object[] array = new Object[max < 32 ? max : 32];
        BufferedSubscription<T> subscription = new BufferedSubscription<T>(subscriber, this.executor, this.onNextHandler, array, max);
        lock.lock();
        try {
            if (!this.subscribed) {
                this.subscribed = true;
                this.owner = Thread.currentThread();
            }
            BufferedSubscription<T> b = this.clients;
            BufferedSubscription<T> pred = null;
            while (true) {
                if (b == null) {
                    subscription.onSubscribe();
                    Throwable ex = this.closedException;
                    if (ex != null) {
                        subscription.onError(ex);
                    } else if (this.closed) {
                        subscription.onComplete();
                    } else if (pred == null) {
                        this.clients = subscription;
                    } else {
                        pred.next = subscription;
                    }
                    break;
                }
                BufferedSubscription next = b.next;
                if (b.isClosed()) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (subscriber.equals(b.subscriber)) {
                        b.onError(new IllegalStateException("Duplicate subscribe"));
                        break;
                    }
                    pred = b;
                }
                b = next;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doOffer(T item, long nanos, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        boolean complete;
        Objects.requireNonNull(item);
        int lag = 0;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Thread t = Thread.currentThread();
            BufferedSubscription<T> b = this.clients;
            Thread o = this.owner;
            boolean unowned = o != t;
            if (unowned && o != null) {
                this.owner = null;
            }
            if (b == null) {
                complete = this.closed;
            } else {
                BufferedSubscription next;
                complete = false;
                boolean cleanMe = false;
                BufferedSubscription<T> retries = null;
                BufferedSubscription<T> rtail = null;
                do {
                    next = b.next;
                    int stat = b.offer(item, unowned);
                    if (stat == 0) {
                        b.nextRetry = null;
                        if (rtail == null) {
                            retries = b;
                        } else {
                            rtail.nextRetry = b;
                        }
                        rtail = b;
                        continue;
                    }
                    if (stat < 0) {
                        cleanMe = true;
                        continue;
                    }
                    if (stat <= lag) continue;
                    lag = stat;
                } while ((b = next) != null);
                if (retries != null || cleanMe) {
                    lag = this.retryOffer(item, nanos, onDrop, retries, lag, cleanMe);
                }
            }
        }
        finally {
            lock.unlock();
        }
        if (complete) {
            throw new IllegalStateException("Closed");
        }
        return lag;
    }

    private int retryOffer(T item, long nanos, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop, BufferedSubscription<T> retries, int lag, boolean cleanMe) {
        BufferedSubscription<T> r = retries;
        while (r != null) {
            int stat;
            BufferedSubscription nextRetry = r.nextRetry;
            r.nextRetry = null;
            if (nanos > 0L) {
                r.awaitSpace(nanos);
            }
            if ((stat = r.retryOffer(item)) == 0 && onDrop != null && onDrop.test(r.subscriber, item)) {
                stat = r.retryOffer(item);
            }
            if (stat == 0) {
                lag = lag >= 0 ? -1 : lag - 1;
            } else if (stat < 0) {
                cleanMe = true;
            } else if (lag >= 0 && stat > lag) {
                lag = stat;
            }
            r = nextRetry;
        }
        if (cleanMe) {
            this.cleanAndCount();
        }
        return lag;
    }

    private int cleanAndCount() {
        int count = 0;
        BufferedSubscription<T> pred = null;
        BufferedSubscription<T> b = this.clients;
        while (b != null) {
            BufferedSubscription next = b.next;
            if (b.isClosed()) {
                b.next = null;
                if (pred == null) {
                    this.clients = next;
                } else {
                    pred.next = next;
                }
            } else {
                pred = b;
                ++count;
            }
            b = next;
        }
        return count;
    }

    public int submit(T item) {
        return this.doOffer(item, Long.MAX_VALUE, null);
    }

    public int offer(T item, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        return this.doOffer(item, 0L, onDrop);
    }

    public int offer(T item, long timeout, TimeUnit unit, BiPredicate<Flow.Subscriber<? super T>, ? super T> onDrop) {
        long nanos = unit.toNanos(timeout);
        if (nanos == Long.MAX_VALUE) {
            --nanos;
        }
        return this.doOffer(item, nanos, onDrop);
    }

    @Override
    public void close() {
        ReentrantLock lock = this.lock;
        if (!this.closed) {
            BufferedSubscription<T> b;
            lock.lock();
            try {
                b = this.clients;
                this.clients = null;
                this.owner = null;
                this.closed = true;
            }
            finally {
                lock.unlock();
            }
            while (b != null) {
                BufferedSubscription next = b.next;
                b.next = null;
                b.onComplete();
                b = next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeExceptionally(Throwable error) {
        Objects.requireNonNull(error);
        ReentrantLock lock = this.lock;
        if (!this.closed) {
            BufferedSubscription<T> b;
            lock.lock();
            try {
                b = this.clients;
                if (!this.closed) {
                    this.closedException = error;
                    this.clients = null;
                    this.owner = null;
                    this.closed = true;
                }
            }
            finally {
                lock.unlock();
            }
            while (b != null) {
                BufferedSubscription next = b.next;
                b.next = null;
                b.onError(error);
                b = next;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Throwable getClosedException() {
        return this.closedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscribers() {
        boolean nonEmpty = false;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                if (b.isClosed()) {
                    b.next = null;
                    this.clients = next;
                    b = this.clients;
                    continue;
                }
                nonEmpty = true;
                break;
            }
        }
        finally {
            lock.unlock();
        }
        return nonEmpty;
    }

    public int getNumberOfSubscribers() {
        int n;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            n = this.cleanAndCount();
        }
        finally {
            lock.unlock();
        }
        return n;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getMaxBufferCapacity() {
        return this.maxBufferCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Flow.Subscriber<? super T>> getSubscribers() {
        ArrayList<Flow.Subscriber<T>> subs = new ArrayList<Flow.Subscriber<T>>();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                if (b.isClosed()) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    subs.add(b.subscriber);
                    pred = b;
                }
                b = next;
            }
        }
        finally {
            lock.unlock();
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        boolean subscribed = false;
        ReentrantLock lock = this.lock;
        if (!this.closed) {
            lock.lock();
            try {
                BufferedSubscription<T> pred = null;
                BufferedSubscription<T> b = this.clients;
                while (b != null) {
                    BufferedSubscription next = b.next;
                    if (b.isClosed()) {
                        b.next = null;
                        if (pred == null) {
                            this.clients = next;
                        } else {
                            pred.next = next;
                        }
                    } else {
                        subscribed = subscriber.equals(b.subscriber);
                        if (subscribed) {
                            break;
                        }
                        pred = b;
                    }
                    b = next;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return subscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long estimateMinimumDemand() {
        long min = Long.MAX_VALUE;
        boolean nonEmpty = false;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                int n = b.estimateLag();
                if (n < 0) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    long d = b.demand - (long)n;
                    if (d < min) {
                        min = d;
                    }
                    nonEmpty = true;
                    pred = b;
                }
                b = next;
            }
        }
        finally {
            lock.unlock();
        }
        return nonEmpty ? min : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int estimateMaximumLag() {
        int max = 0;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedSubscription<T> pred = null;
            BufferedSubscription<T> b = this.clients;
            while (b != null) {
                BufferedSubscription next = b.next;
                int n = b.estimateLag();
                if (n < 0) {
                    b.next = null;
                    if (pred == null) {
                        this.clients = next;
                    } else {
                        pred.next = next;
                    }
                } else {
                    if (n > max) {
                        max = n;
                    }
                    pred = b;
                }
                b = next;
            }
        }
        finally {
            lock.unlock();
        }
        return max;
    }

    public CompletableFuture<Void> consume(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        CompletableFuture<Void> status = new CompletableFuture<Void>();
        this.subscribe(new ConsumerSubscriber<T>(status, consumer));
        return status;
    }

    static final class BufferedSubscription<T>
    implements Flow.Subscription,
    ForkJoinPool.ManagedBlocker {
        volatile long pad00;
        volatile long pad01;
        volatile long pad02;
        volatile long pad03;
        volatile long pad04;
        volatile long pad05;
        volatile long pad06;
        volatile long pad07;
        volatile long pad08;
        volatile long pad09;
        volatile long pad0a;
        volatile long pad0b;
        volatile long pad0c;
        volatile long pad0d;
        volatile long pad0e;
        volatile long pad0f;
        long timeout;
        int head;
        int tail;
        final int maxCapacity;
        volatile int ctl;
        Object[] array;
        final Flow.Subscriber<? super T> subscriber;
        final BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler;
        Executor executor;
        Thread waiter;
        Throwable pendingError;
        BufferedSubscription<T> next;
        BufferedSubscription<T> nextRetry;
        volatile long pad10;
        volatile long pad11;
        volatile long pad12;
        volatile long pad13;
        volatile long pad14;
        volatile long pad15;
        volatile long pad16;
        volatile long pad17;
        volatile long pad18;
        volatile long pad19;
        volatile long pad1a;
        volatile long pad1b;
        volatile long pad1c;
        volatile long pad1d;
        volatile long pad1e;
        volatile long pad1f;
        volatile long demand;
        volatile long pad20;
        volatile long pad21;
        volatile long pad22;
        volatile long pad23;
        volatile long pad24;
        volatile long pad25;
        volatile long pad26;
        volatile long pad27;
        volatile long pad28;
        volatile long pad29;
        volatile long pad2a;
        volatile long pad2b;
        volatile long pad2c;
        volatile long pad2d;
        volatile long pad2e;
        volatile int waiting;
        volatile Object pad2f;
        volatile Object pad30;
        volatile Object pad31;
        volatile Object pad32;
        volatile Object pad33;
        volatile Object pad34;
        volatile Object pad35;
        volatile Object pad36;
        volatile Object pad37;
        volatile Object pad38;
        volatile Object pad39;
        volatile Object pad3a;
        volatile Object pad3b;
        volatile Object pad3c;
        volatile Object pad3d;
        volatile Object pad3e;
        static final int CLOSED = 1;
        static final int ACTIVE = 2;
        static final int REQS = 4;
        static final int ERROR = 8;
        static final int COMPLETE = 16;
        static final int RUN = 32;
        static final int OPEN = 64;
        static final long INTERRUPTED = -1L;
        private static final Unsafe U = UnsafeAccess.unsafe;
        private static final long CTL;
        private static final long DEMAND;
        private static final int ABASE;
        private static final int ASHIFT;

        BufferedSubscription(Flow.Subscriber<? super T> subscriber, Executor executor, BiConsumer<? super Flow.Subscriber<? super T>, ? super Throwable> onNextHandler, Object[] array, int maxBufferCapacity) {
            this.subscriber = subscriber;
            this.executor = executor;
            this.onNextHandler = onNextHandler;
            this.array = array;
            this.maxCapacity = maxBufferCapacity;
        }

        static int getAndBitwiseOr(Object o, long offset, int mask) {
            int oldVal;
            while (!U.compareAndSwapInt(o, offset, oldVal = U.getIntVolatile(o, offset), oldVal | mask)) {
            }
            return oldVal;
        }

        final boolean weakCasCtl(int cmp, int val) {
            return U.compareAndSwapInt(this, CTL, cmp, val);
        }

        final int getAndBitwiseOrCtl(int bits) {
            return BufferedSubscription.getAndBitwiseOr(this, CTL, bits);
        }

        final long subtractDemand(int k) {
            long n = -k;
            return n + U.getAndAddLong(this, DEMAND, n);
        }

        final boolean casDemand(long cmp, long val) {
            return U.compareAndSwapLong(this, DEMAND, cmp, val);
        }

        static Object getAndSetArrayElement(Object[] array, int index, Object newVal) {
            Object oldVal;
            long offset = BufferedSubscription.getOffsetFromArrayIndex(index);
            while (!U.compareAndSwapObject(array, offset, oldVal = U.getObjectVolatile(array, offset), newVal)) {
            }
            return oldVal;
        }

        static Object getArrayElementVolatile(Object[] array, int index) {
            return U.getObjectVolatile(array, BufferedSubscription.getOffsetFromArrayIndex(index));
        }

        static void setArrayElementVolatile(Object[] array, int index, Object newVal) {
            U.putObjectVolatile(array, BufferedSubscription.getOffsetFromArrayIndex(index), newVal);
        }

        static boolean compareAndSetArrayElement(Object[] array, int index, Object expVal, Object newVal) {
            return U.compareAndSwapObject(array, BufferedSubscription.getOffsetFromArrayIndex(index), expVal, newVal);
        }

        static long getOffsetFromArrayIndex(int index) {
            return ((long)index << ASHIFT) + (long)ABASE;
        }

        final boolean isClosed() {
            return (this.ctl & 1) != 0;
        }

        final int estimateLag() {
            int c = this.ctl;
            int n = this.tail - this.head;
            return (c & 1) != 0 ? -1 : (n < 0 ? 0 : n);
        }

        final int offer(T item, boolean unowned) {
            int stat = 0;
            Object[] a = this.array;
            int cap = this.array == null ? 0 : a.length;
            int t = this.tail;
            int i = t & cap - 1;
            int n = t + 1 - this.head;
            if (cap > 0) {
                boolean added;
                if (n >= cap && cap < this.maxCapacity) {
                    added = this.growAndOffer(item, a, t);
                } else if (n >= cap || unowned) {
                    added = BufferedSubscription.compareAndSetArrayElement(a, i, null, item);
                } else {
                    BufferedSubscription.setArrayElementVolatile(a, i, item);
                    added = true;
                }
                if (added) {
                    this.tail = t + 1;
                    stat = n;
                }
            }
            return this.startOnOffer(stat);
        }

        final boolean growAndOffer(T item, Object[] a, int t) {
            int mask;
            Object x;
            int cap = 0;
            int newCap = 0;
            Object[] newArray = null;
            if (a != null && (cap = a.length) > 0 && (newCap = cap << 1) > 0) {
                try {
                    newArray = new Object[newCap];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
            }
            if (newArray == null) {
                return false;
            }
            int newMask = newCap - 1;
            newArray[t-- & newMask] = item;
            for (int k = mask = cap - 1; k >= 0 && (x = BufferedSubscription.getAndSetArrayElement(a, t & mask, null)) != null; --k) {
                newArray[t-- & newMask] = x;
            }
            this.array = newArray;
            U.fullFence();
            return true;
        }

        final int retryOffer(T item) {
            int cap;
            int stat = 0;
            int t = this.tail;
            int h = this.head;
            Object[] a = this.array;
            if (this.array != null && (cap = a.length) > 0 && BufferedSubscription.compareAndSetArrayElement(a, cap - 1 & t, null, item)) {
                this.tail = t + 1;
                stat = this.tail - h;
            }
            return this.startOnOffer(stat);
        }

        final int startOnOffer(int stat) {
            int c = this.ctl;
            if ((c & 6) == 4 && ((c = this.getAndBitwiseOrCtl(34)) & 0x21) == 0) {
                this.tryStart();
            } else if ((c & 1) != 0) {
                stat = -1;
            }
            return stat;
        }

        final void tryStart() {
            try {
                ConsumerTask task = new ConsumerTask(this);
                Executor e = this.executor;
                if (e != null) {
                    e.execute(task);
                }
            }
            catch (RuntimeException ex) {
                this.getAndBitwiseOrCtl(9);
                throw ex;
            }
            catch (Error e) {
                this.getAndBitwiseOrCtl(9);
                throw e;
            }
        }

        final void startOnSignal(int bits) {
            if ((this.ctl & bits) != bits && (this.getAndBitwiseOrCtl(bits) & 0x21) == 0) {
                this.tryStart();
            }
        }

        final void onSubscribe() {
            this.startOnSignal(34);
        }

        final void onComplete() {
            this.startOnSignal(50);
        }

        final void onError(Throwable ex) {
            int c;
            if (ex != null) {
                this.pendingError = ex;
            }
            if (((c = this.getAndBitwiseOrCtl(42)) & 1) == 0) {
                if ((c & 0x20) == 0) {
                    this.tryStart();
                } else {
                    Object[] a = this.array;
                    if (this.array != null) {
                        Arrays.fill(a, null);
                    }
                }
            }
        }

        @Override
        public final void cancel() {
            this.onError(null);
        }

        @Override
        public final void request(long n) {
            if (n > 0L) {
                long d;
                long p;
                while (!this.casDemand(p, (d = (p = this.demand) + n) < p ? Long.MAX_VALUE : d)) {
                }
                this.startOnSignal(38);
            } else {
                this.onError(new IllegalArgumentException("non-positive subscription request"));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void consume() {
            Flow.Subscriber<? super T> s = this.subscriber;
            if (s == null) return;
            this.subscribeOnOpen(s);
            long d = this.demand;
            int h = this.head;
            int t = this.tail;
            while (true) {
                int bit;
                int c;
                if (((c = this.ctl) & 8) != 0) {
                    this.closeOnError(s, null);
                    return;
                }
                int taken = this.takeItems(s, d, h);
                if (taken > 0) {
                    this.head = h += taken;
                    d = this.subtractDemand(taken);
                    continue;
                }
                d = this.demand;
                if (d == 0L && (c & 4) != 0) {
                    this.weakCasCtl(c, c & 0xFFFFFFFB);
                    continue;
                }
                if (d != 0L && (c & 4) == 0) {
                    this.weakCasCtl(c, c | 4);
                    continue;
                }
                if (t != (t = this.tail)) continue;
                boolean empty = t == h;
                if (empty && (c & 0x10) != 0) {
                    this.closeOnComplete(s);
                    return;
                }
                if ((empty || d == 0L) && this.weakCasCtl(c, c & ~(bit = (c & 2) != 0 ? 2 : 32)) && bit == 32) return;
            }
        }

        final int takeItems(Flow.Subscriber<? super T> s, long d, int h) {
            int k;
            int cap;
            Object[] a = this.array;
            if (this.array != null && (cap = a.length) > 0) {
                int n;
                int m = cap - 1;
                int b = (m >>> 3) + 1;
                int n2 = n = d < (long)b ? (int)d : b;
                for (k = 0; k < n; ++k) {
                    Object x = BufferedSubscription.getAndSetArrayElement(a, h & m, null);
                    if (this.waiting != 0) {
                        this.signalWaiter();
                    }
                    if (x == null || !this.consumeNext(s, x)) break;
                    ++h;
                }
            }
            return k;
        }

        final boolean consumeNext(Flow.Subscriber<? super T> s, Object x) {
            try {
                Object y = x;
                if (s != null) {
                    s.onNext(y);
                }
                return true;
            }
            catch (Throwable ex) {
                this.handleOnNext(s, ex);
                return false;
            }
        }

        final void handleOnNext(Flow.Subscriber<? super T> s, Throwable ex) {
            try {
                BiConsumer<Flow.Subscriber<Flow.Subscriber<? super T>>, Throwable> h = this.onNextHandler;
                if (h != null) {
                    h.accept(s, ex);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.closeOnError(s, ex);
        }

        final void subscribeOnOpen(Flow.Subscriber<? super T> s) {
            if ((this.ctl & 0x40) == 0 && (this.getAndBitwiseOrCtl(64) & 0x40) == 0) {
                this.consumeSubscribe(s);
            }
        }

        final void consumeSubscribe(Flow.Subscriber<? super T> s) {
            try {
                if (s != null) {
                    s.onSubscribe(this);
                }
            }
            catch (Throwable ex) {
                this.closeOnError(s, ex);
            }
        }

        final void closeOnComplete(Flow.Subscriber<? super T> s) {
            if ((this.getAndBitwiseOrCtl(1) & 1) == 0) {
                this.consumeComplete(s);
            }
        }

        final void consumeComplete(Flow.Subscriber<? super T> s) {
            try {
                if (s != null) {
                    s.onComplete();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        final void closeOnError(Flow.Subscriber<? super T> s, Throwable ex) {
            if ((this.getAndBitwiseOrCtl(9) & 1) == 0) {
                if (ex == null) {
                    ex = this.pendingError;
                }
                this.pendingError = null;
                this.executor = null;
                this.signalWaiter();
                this.consumeError(s, ex);
            }
        }

        final void consumeError(Flow.Subscriber<? super T> s, Throwable ex) {
            try {
                if (ex != null && s != null) {
                    s.onError(ex);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        final void signalWaiter() {
            this.waiting = 0;
            Thread w = this.waiter;
            if (w != null) {
                LockSupport.unpark(w);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean isReleasable() {
            if ((this.ctl & 1) != 0) return true;
            Object[] a = this.array;
            if (this.array == null) return false;
            int cap = a.length;
            if (cap <= 0) return false;
            if (BufferedSubscription.getArrayElementVolatile(a, cap - 1 & this.tail) != null) return false;
            return true;
        }

        final void awaitSpace(long nanos) {
            if (!this.isReleasable()) {
                ForkJoinPool.helpAsyncBlocker(this.executor, this);
                if (!this.isReleasable()) {
                    this.timeout = nanos;
                    try {
                        ForkJoinPool.managedBlock(this);
                    }
                    catch (InterruptedException ie) {
                        this.timeout = -1L;
                    }
                    if (this.timeout == -1L) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        @Override
        public final boolean block() {
            long deadline;
            long nanos = this.timeout;
            boolean timed = nanos < Long.MAX_VALUE;
            long l = deadline = timed ? System.nanoTime() + nanos : 0L;
            while (!this.isReleasable()) {
                if (Thread.interrupted()) {
                    this.timeout = -1L;
                    if (!timed) continue;
                    break;
                }
                if (timed && (nanos = deadline - System.nanoTime()) <= 0L) break;
                if (this.waiter == null) {
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (this.waiting == 0) {
                    this.waiting = 1;
                    continue;
                }
                if (timed) {
                    LockSupport.parkNanos(this, nanos);
                    continue;
                }
                LockSupport.park(this);
            }
            this.waiter = null;
            this.waiting = 0;
            return true;
        }

        static {
            try {
                CTL = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("ctl"));
                DEMAND = U.objectFieldOffset(BufferedSubscription.class.getDeclaredField("demand"));
                ABASE = U.arrayBaseOffset(Object[].class);
                int scale = U.arrayIndexScale(Object[].class);
                if ((scale & scale - 1) != 0) {
                    throw new ExceptionInInitializerError("data type scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
            Class<LockSupport> clazz = LockSupport.class;
        }
    }

    static final class ConsumerTask<T>
    extends ForkJoinTask<Void>
    implements Runnable,
    CompletableFuture.AsynchronousCompletionTask {
        final BufferedSubscription<T> consumer;

        ConsumerTask(BufferedSubscription<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.consumer.consume();
            return false;
        }

        @Override
        public final void run() {
            this.consumer.consume();
        }
    }

    static final class ConsumerSubscriber<T>
    implements Flow.Subscriber<T> {
        final CompletableFuture<Void> status;
        final Consumer<? super T> consumer;
        Flow.Subscription subscription;

        ConsumerSubscriber(CompletableFuture<Void> status, Consumer<? super T> consumer) {
            this.status = status;
            this.consumer = consumer;
        }

        @Override
        public final void onSubscribe(final Flow.Subscription subscription) {
            this.subscription = subscription;
            this.status.whenComplete((BiConsumer)new BiConsumer<Void, Throwable>(){

                @Override
                public void accept(Void v, Throwable e) {
                    subscription.cancel();
                }
            });
            if (!this.status.isDone()) {
                subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public final void onError(Throwable ex) {
            this.status.completeExceptionally(ex);
        }

        @Override
        public final void onComplete() {
            this.status.complete(null);
        }

        @Override
        public final void onNext(T item) {
            try {
                this.consumer.accept(item);
            }
            catch (Throwable ex) {
                this.subscription.cancel();
                this.status.completeExceptionally(ex);
            }
        }
    }

    private static final class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

