/*
 * Decompiled with CFR 0.152.
 */
package net.frobenius.lapack;

import net.dedekind.lapack.Lapack;
import net.frobenius.ComputationTruncatedException;
import net.frobenius.NotConvergedException;
import net.frobenius.TDiag;
import net.frobenius.TEigJob;
import net.frobenius.TNorm;
import net.frobenius.TRange;
import net.frobenius.TSide;
import net.frobenius.TSvdJob;
import net.frobenius.TTrans;
import net.frobenius.TUpLo;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public final class PlainLapack {
    public static double dgbcon(Lapack la, TNorm norm, int n, int kl, int ku, double[] ab, int[] indices, double normA) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkNonNegative(kl, "kl");
        PlainLapack.checkNonNegative(ku, "ku");
        PlainLapack.checkMinLen(indices, n, "indices");
        int ldab = Math.max(1, 2 * kl + ku + 1);
        PlainLapack.checkMinLen(ab, ldab * n, "ab");
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        double[] work = new double[3 * n];
        int[] iwork = new int[n];
        la.dgbcon(norm.val(), n, kl, ku, ab, ldab, indices, normA, rcond, work, iwork, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        return rcond.val;
    }

    public static void dgbsv(Lapack la, int n, int kl, int ku, int rhsCount, double[] ab, int[] indices, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkNonNegative(kl, "kl");
        PlainLapack.checkNonNegative(ku, "ku");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkMinLen(indices, n, "indices");
        int ldab = Math.max(1, 2 * kl + ku + 1);
        PlainLapack.checkMinLen(ab, ldab * n, "ab");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        intW info = new intW(0);
        la.dgbsv(n, kl, ku, rhsCount, ab, ldab, indices, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular. Solution could not be computed.");
            }
        }
    }

    public static void dgbtrf(Lapack la, int m, int n, int kl, int ku, double[] ab, int[] indices) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkNonNegative(kl, "kl");
        PlainLapack.checkNonNegative(ku, "ku");
        PlainLapack.checkMinLen(indices, Math.min(m, n), "indices");
        int ldab = Math.max(1, 2 * kl + ku + 1);
        PlainLapack.checkMinLen(ab, ldab * n, "ab");
        intW info = new intW(0);
        la.dgbtrf(m, n, kl, ku, ab, ldab, indices, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular");
            }
        }
    }

    public static void dgbtrs(Lapack la, TTrans trans, int n, int kl, int ku, int rhsCount, double[] ab, int[] indices, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkNonNegative(kl, "kl");
        PlainLapack.checkNonNegative(ku, "ku");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkMinLen(indices, n, "indices");
        int ldab = Math.max(1, 2 * kl + ku + 1);
        PlainLapack.checkMinLen(ab, ldab * n, "ab");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        intW info = new intW(0);
        la.dgbtrs(trans.val(), n, kl, ku, rhsCount, ab, ldab, indices, b, ldb, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static double dgecon(Lapack la, TNorm norm, int n, double[] a, int lda, double normA) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        double[] work = new double[4 * n];
        int[] iwork = new int[n];
        la.dgecon(norm.val(), n, a, lda, normA, rcond, work, iwork, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        return rcond.val;
    }

    public static void dgeev(Lapack la, TEigJob jobvl, TEigJob jobvr, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(wr, n, "wr");
        PlainLapack.checkMinLen(wi, n, "wi");
        if (jobvl == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvl, n, "ldvl");
            PlainLapack.checkMinLen(vl, ldvl * n, "vl");
        } else {
            PlainLapack.checkValueAtLeast(ldvl, 1, "ldvl");
        }
        if (jobvr == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvr, n, "ldvr");
            PlainLapack.checkMinLen(vr, ldvr * n, "vr");
        } else {
            PlainLapack.checkValueAtLeast(ldvr, 1, "ldvr");
        }
        intW info = new intW(0);
        double[] work = new double[1];
        la.dgeev(jobvl.val(), jobvr.val(), n, new double[0], lda, new double[0], new double[0], new double[0], ldvl, new double[0], ldvr, work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgeev(jobvl.val(), jobvr.val(), n, a, lda, wr, wi, vl, ldvl, vr, ldvr, work, work.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("QR failed to compute all eigenvalues, eigenvectors haven't been computed.");
            }
        }
    }

    public static void sgeev(Lapack la, TEigJob jobvl, TEigJob jobvr, int n, float[] a, int lda, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(wr, n, "wr");
        PlainLapack.checkMinLen(wi, n, "wi");
        if (jobvl == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvl, n, "ldvl");
            PlainLapack.checkMinLen(vl, ldvl * n, "vl");
        } else {
            PlainLapack.checkValueAtLeast(ldvl, 1, "ldvl");
        }
        if (jobvr == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvr, n, "ldvr");
            PlainLapack.checkMinLen(vr, ldvr * n, "vr");
        } else {
            PlainLapack.checkValueAtLeast(ldvr, 1, "ldvr");
        }
        intW info = new intW(0);
        float[] work = new float[1];
        la.sgeev(jobvl.val(), jobvr.val(), n, new float[0], lda, new float[0], new float[0], new float[0], ldvl, new float[0], ldvr, work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new float[(int)work[0]];
        la.sgeev(jobvl.val(), jobvr.val(), n, a, lda, wr, wi, vl, ldvl, vr, ldvr, work, work.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("QR failed to compute all eigenvalues, eigenvectors haven't been computed.");
            }
        }
    }

    public static void cgeev(Lapack la, TEigJob jobvl, TEigJob jobvr, int n, float[] a, int lda, float[] w, float[] vl, int ldvl, float[] vr, int ldvr) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(w, 2 * n, "w");
        if (jobvl == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvl, n, "ldvl");
            PlainLapack.checkMinLen(vl, 2 * ldvl * n, "vl");
        } else {
            PlainLapack.checkValueAtLeast(ldvl, 1, "ldvl");
        }
        if (jobvr == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvr, n, "ldvr");
            PlainLapack.checkMinLen(vr, 2 * ldvr * n, "vr");
        } else {
            PlainLapack.checkValueAtLeast(ldvr, 1, "ldvr");
        }
        int info = la.cgeev(jobvl.val(), jobvr.val(), n, a, lda, w, vl, ldvl, vr, ldvr);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("QR failed to compute all eigenvalues, eigenvectors haven't been computed.");
            }
        }
    }

    public static void zgeev(Lapack la, TEigJob jobvl, TEigJob jobvr, int n, double[] a, int lda, double[] w, double[] vl, int ldvl, double[] vr, int ldvr) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(w, 2 * n, "w");
        if (jobvl == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvl, n, "ldvl");
            PlainLapack.checkMinLen(vl, 2 * ldvl * n, "vl");
        } else {
            PlainLapack.checkValueAtLeast(ldvl, 1, "ldvl");
        }
        if (jobvr == TEigJob.ALL) {
            PlainLapack.checkValueAtLeast(ldvr, n, "ldvr");
            PlainLapack.checkMinLen(vr, 2 * ldvr * n, "vr");
        } else {
            PlainLapack.checkValueAtLeast(ldvr, 1, "ldvr");
        }
        int info = la.zgeev(jobvl.val(), jobvr.val(), n, a, lda, w, vl, ldvl, vr, ldvr);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("QR failed to compute all eigenvalues, eigenvectors haven't been computed.");
            }
        }
    }

    public static void dgelqf(Lapack la, int m, int n, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "m");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(tau, Math.min(n, m), "tau");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dgelqf(m, n, new double[0], lda, new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgelqf(m, n, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dgels(Lapack la, TTrans trans, int m, int n, int rhsCount, double[] a, int lda, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkValueAtLeast(ldb, Math.max(n, m), "ldb");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dgels(trans.val(), m, n, rhsCount, new double[0], lda, new double[0], ldb, work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgels(trans.val(), m, n, rhsCount, a, lda, b, ldb, work, work.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("A does not have full rank. Least squares solution could not be computed.");
            }
        }
    }

    public static void sgels(Lapack la, TTrans trans, int m, int n, int rhsCount, float[] a, int lda, float[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkValueAtLeast(ldb, Math.max(n, m), "ldb");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        intW info = new intW(0);
        float[] work = new float[1];
        la.sgels(trans.val(), m, n, rhsCount, new float[0], lda, new float[0], ldb, work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new float[(int)work[0]];
        la.sgels(trans.val(), m, n, rhsCount, a, lda, b, ldb, work, work.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("A does not have full rank. Least squares solution could not be computed.");
            }
        }
    }

    public static void cgels(Lapack la, TTrans trans, int m, int n, int rhsCount, float[] a, int lda, float[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkValueAtLeast(ldb, Math.max(n, m), "ldb");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(b, 2 * ldb * rhsCount, "b");
        int info = la.cgels(trans.val(), m, n, rhsCount, a, lda, b, ldb);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("A does not have full rank. Least squares solution could not be computed.");
            }
        }
    }

    public static void zgels(Lapack la, TTrans trans, int m, int n, int rhsCount, double[] a, int lda, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkValueAtLeast(ldb, Math.max(n, m), "ldb");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(b, 2 * ldb * rhsCount, "b");
        int info = la.zgels(trans.val(), m, n, rhsCount, a, lda, b, ldb);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("A does not have full rank. Least squares solution could not be computed.");
            }
        }
    }

    public static void dgeqlf(Lapack la, int m, int n, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(tau, Math.min(m, n), "tau");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dgeqlf(m, n, new double[0], lda, new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgeqlf(m, n, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dgeqp3(Lapack la, int m, int n, double[] a, int lda, int[] jPivot, double[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(jPivot, n, "jPivot");
        PlainLapack.checkMinLen(tau, Math.min(m, n), "tau");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dgeqp3(m, n, new double[0], lda, new int[0], new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgeqp3(m, n, a, lda, jPivot, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dgeqrf(Lapack la, int m, int n, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(tau, Math.min(m, n), "tau");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dgeqrf(m, n, new double[0], lda, new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgeqrf(m, n, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void sgeqrf(Lapack la, int m, int n, float[] a, int lda, float[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(tau, Math.min(m, n), "tau");
        intW info = new intW(0);
        float[] work = new float[1];
        la.sgeqrf(m, n, new float[0], lda, new float[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new float[(int)work[0]];
        la.sgeqrf(m, n, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void cgeqrf(Lapack la, int m, int n, float[] a, int lda, float[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(tau, 2 * Math.min(m, n), "tau");
        int info = la.cgeqrf(m, n, a, lda, tau);
        if (info != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void zgeqrf(Lapack la, int m, int n, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(tau, 2 * Math.min(m, n), "tau");
        int info = la.zgeqrf(m, n, a, lda, tau);
        if (info != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dgerqf(Lapack la, int m, int n, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(tau, Math.min(m, n), "tau");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dgerqf(m, n, new double[0], lda, new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgerqf(m, n, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dgesdd(Lapack la, TSvdJob jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(s, Math.min(m, n), "s");
        PlainLapack.checkStrictlyPositive(ldu, "ldu");
        PlainLapack.checkStrictlyPositive(ldvt, "ldvt");
        if (jobz == TSvdJob.ALL || jobz == TSvdJob.PART || m < n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldu, m, "ldu");
            int ucol = jobz == TSvdJob.PART ? Math.min(m, n) : m;
            PlainLapack.checkMinLen(u, ldu * ucol, "u");
        }
        if (jobz == TSvdJob.ALL || m >= n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldvt, n, "ldvt");
            PlainLapack.checkMinLen(vt, ldvt * n, "vt");
        } else if (jobz == TSvdJob.PART) {
            PlainLapack.checkValueAtLeast(ldvt, Math.min(m, n), "ldvt");
            PlainLapack.checkMinLen(vt, ldvt * n, "vt");
        }
        intW info = new intW(0);
        int[] iwork = new int[8 * Math.min(m, n)];
        double[] work = new double[1];
        la.dgesdd(jobz.val(), m, n, new double[0], lda, new double[0], new double[0], ldu, new double[0], ldvt, work, -1, new int[0], info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dgesdd(jobz.val(), m, n, a, lda, s, u, ldu, vt, ldvt, work, work.length, iwork, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new NotConvergedException("Did not converge. Update failed.");
            }
        }
    }

    public static void sgesdd(Lapack la, TSvdJob jobz, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(s, Math.min(m, n), "s");
        PlainLapack.checkStrictlyPositive(ldu, "ldu");
        PlainLapack.checkStrictlyPositive(ldvt, "ldvt");
        if (jobz == TSvdJob.ALL || jobz == TSvdJob.PART || m < n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldu, m, "ldu");
            int ucol = jobz == TSvdJob.PART ? Math.min(m, n) : m;
            PlainLapack.checkMinLen(u, ldu * ucol, "u");
        }
        if (jobz == TSvdJob.ALL || m >= n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldvt, n, "ldvt");
            PlainLapack.checkMinLen(vt, ldvt * n, "vt");
        } else if (jobz == TSvdJob.PART) {
            PlainLapack.checkValueAtLeast(ldvt, Math.min(m, n), "ldvt");
            PlainLapack.checkMinLen(vt, ldvt * n, "vt");
        }
        intW info = new intW(0);
        int[] iwork = new int[8 * Math.min(m, n)];
        float[] work = new float[1];
        la.sgesdd(jobz.val(), m, n, new float[0], lda, new float[0], new float[0], ldu, new float[0], ldvt, work, -1, new int[0], info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new float[(int)work[0]];
        la.sgesdd(jobz.val(), m, n, a, lda, s, u, ldu, vt, ldvt, work, work.length, iwork, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new NotConvergedException("Did not converge. Update failed.");
            }
        }
    }

    public static void cgesdd(Lapack la, TSvdJob jobz, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(s, Math.min(m, n), "s");
        PlainLapack.checkStrictlyPositive(ldu, "ldu");
        PlainLapack.checkStrictlyPositive(ldvt, "ldvt");
        if (jobz == TSvdJob.ALL || jobz == TSvdJob.PART || m < n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldu, m, "ldu");
            int ucol = jobz == TSvdJob.PART ? Math.min(m, n) : m;
            PlainLapack.checkMinLen(u, 2 * ldu * ucol, "u");
        }
        if (jobz == TSvdJob.ALL || m >= n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldvt, n, "ldvt");
            PlainLapack.checkMinLen(vt, 2 * ldvt * n, "vt");
        } else if (jobz == TSvdJob.PART) {
            PlainLapack.checkValueAtLeast(ldvt, Math.min(m, n), "ldvt");
            PlainLapack.checkMinLen(vt, 2 * ldvt * n, "vt");
        }
        int info = la.cgesdd(jobz.val(), m, n, a, lda, s, u, ldu, vt, ldvt);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new NotConvergedException("Did not converge. Update failed.");
            }
        }
    }

    public static void zgesdd(Lapack la, TSvdJob jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(s, Math.min(m, n), "s");
        PlainLapack.checkStrictlyPositive(ldu, "ldu");
        PlainLapack.checkStrictlyPositive(ldvt, "ldvt");
        if (jobz == TSvdJob.ALL || jobz == TSvdJob.PART || m < n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldu, m, "ldu");
            int ucol = jobz == TSvdJob.PART ? Math.min(m, n) : m;
            PlainLapack.checkMinLen(u, 2 * ldu * ucol, "u");
        }
        if (jobz == TSvdJob.ALL || m >= n && jobz == TSvdJob.OVERWRITE) {
            PlainLapack.checkValueAtLeast(ldvt, n, "ldvt");
            PlainLapack.checkMinLen(vt, 2 * ldvt * n, "vt");
        } else if (jobz == TSvdJob.PART) {
            PlainLapack.checkValueAtLeast(ldvt, Math.min(m, n), "ldvt");
            PlainLapack.checkMinLen(vt, 2 * ldvt * n, "vt");
        }
        int info = la.zgesdd(jobz.val(), m, n, a, lda, s, u, ldu, vt, ldvt);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new NotConvergedException("Did not converge. Update failed.");
            }
        }
    }

    public static void dgesv(Lapack la, int n, int rhsCount, double[] a, int lda, int[] indices, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(indices, n, "indices");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        intW info = new intW(0);
        la.dgesv(n, rhsCount, a, lda, indices, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular. Solution could not be computed.");
            }
        }
    }

    public static void sgesv(Lapack la, int n, int rhsCount, float[] a, int lda, int[] indices, float[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(indices, n, "indices");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        intW info = new intW(0);
        la.sgesv(n, rhsCount, a, lda, indices, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular. Solution could not be computed.");
            }
        }
    }

    public static void cgesv(Lapack la, int n, int rhsCount, float[] a, int lda, int[] indices, float[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(indices, n, "indices");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(b, 2 * ldb * rhsCount, "b");
        int info = la.cgesv(n, rhsCount, a, lda, indices, b, ldb);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular. Solution could not be computed.");
            }
        }
    }

    public static void zgesv(Lapack la, int n, int rhsCount, double[] a, int lda, int[] indices, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(indices, n, "indices");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(b, 2 * ldb * rhsCount, "b");
        int info = la.zgesv(n, rhsCount, a, lda, indices, b, ldb);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular. Solution could not be computed.");
            }
        }
    }

    public static void dgetrf(Lapack la, int m, int n, double[] a, int lda, int[] indices) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(indices, Math.min(m, n), "indices");
        intW info = new intW(0);
        la.dgetrf(m, n, a, lda, indices, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular");
            }
        }
    }

    public static void sgetrf(Lapack la, int m, int n, float[] a, int lda, int[] indices) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(indices, Math.min(m, n), "indices");
        intW info = new intW(0);
        la.sgetrf(m, n, a, lda, indices, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular");
            }
        }
    }

    public static void cgetrf(Lapack la, int m, int n, float[] a, int lda, int[] indices) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(indices, Math.min(m, n), "indices");
        int info = la.cgetrf(m, n, a, lda, indices);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular");
            }
        }
    }

    public static void zgetrf(Lapack la, int m, int n, double[] a, int lda, int[] indices) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkValueAtLeast(lda, m, "lda");
        PlainLapack.checkMinLen(a, 2 * lda * n, "a");
        PlainLapack.checkMinLen(indices, Math.min(m, n), "indices");
        int info = la.zgetrf(m, n, a, lda, indices);
        if (info != 0) {
            if (info < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular");
            }
        }
    }

    public static void dgetrs(Lapack la, TTrans trans, int n, int rhsCount, double[] a, int lda, int[] indices, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(lda, n, "lda");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        PlainLapack.checkMinLen(indices, n, "indices");
        intW info = new intW(0);
        la.dgetrs(trans.val(), n, rhsCount, a, lda, indices, b, ldb, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dgtsv(Lapack la, int n, int rhsCount, double[] dl, double[] d, double[] du, double[] b, int ldb) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(rhsCount, "rhsCount");
        PlainLapack.checkValueAtLeast(ldb, n, "ldb");
        PlainLapack.checkMinLen(b, ldb * rhsCount, "b");
        PlainLapack.checkMinLen(dl, n - 1, "dl");
        PlainLapack.checkMinLen(du, n - 1, "du");
        PlainLapack.checkMinLen(d, n, "d");
        intW info = new intW(0);
        la.dgtsv(n, rhsCount, dl, d, du, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Factor U in the LU decomposition is exactly singular. Solution could not be computed.");
            }
        }
    }

    public static void dlaswp(Lapack la, int n, double[] a, int lda, int pivFirstIdx, int pivLastIdx, int[] indices, int increment) {
        PlainLapack.checkStrictlyPositive(n, "n");
        PlainLapack.checkStrictlyPositive(lda, "lda");
        PlainLapack.checkMinLen(a, lda * n, "a");
        PlainLapack.checkStrictlyPositive(pivFirstIdx, "pivFirstIdx");
        PlainLapack.checkStrictlyPositive(pivLastIdx, "pivLastIdx");
        PlainLapack.checkMinLen(indices, pivLastIdx * Math.abs(increment), "indices");
        la.dlaswp(n, a, lda, pivFirstIdx, pivLastIdx, indices, increment);
    }

    public static void dorglq(Lapack la, int m, int n, int k, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(m, "m");
        PlainLapack.checkValueAtLeast(m, k, "m");
        PlainLapack.checkValueAtLeast(n, m, "n");
        PlainLapack.checkStrictlyPositive(k, "k");
        PlainLapack.checkValueAtLeast(lda, Math.max(1, m), "lda");
        PlainLapack.checkMinLen(a, m * n, "a");
        PlainLapack.checkMinLen(tau, k, "tau");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dorglq(m, n, k, new double[0], lda, new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dorglq(m, n, k, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dorgqr(Lapack la, int m, int n, int k, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(k, "k");
        PlainLapack.checkValueAtLeast(n, k, "n");
        PlainLapack.checkValueAtLeast(m, n, "m");
        PlainLapack.checkValueAtLeast(lda, Math.max(1, m), "lda");
        PlainLapack.checkMinLen(a, m * n, "a");
        PlainLapack.checkMinLen(tau, k, "tau");
        intW info = new intW(0);
        double[] work = new double[1];
        la.dorgqr(m, n, k, new double[0], lda, new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dorgqr(m, n, k, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void zungqr(Lapack la, int m, int n, int k, double[] a, int lda, double[] tau) {
        PlainLapack.checkStrictlyPositive(k, "k");
        PlainLapack.checkValueAtLeast(n, k, "n");
        PlainLapack.checkValueAtLeast(m, n, "m");
        PlainLapack.checkValueAtLeast(lda, Math.max(1, m), "lda");
        PlainLapack.checkMinLen(a, 2 * m * n, "a");
        PlainLapack.checkMinLen(tau, 2 * k, "tau");
        int info = la.zungqr(m, n, k, a, lda, tau);
        if (info != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void sorgqr(Lapack la, int m, int n, int k, float[] a, int lda, float[] tau) {
        PlainLapack.checkStrictlyPositive(k, "k");
        PlainLapack.checkValueAtLeast(n, k, "n");
        PlainLapack.checkValueAtLeast(m, n, "m");
        PlainLapack.checkValueAtLeast(lda, Math.max(1, m), "lda");
        PlainLapack.checkMinLen(a, m * n, "a");
        PlainLapack.checkMinLen(tau, k, "tau");
        intW info = new intW(0);
        float[] work = new float[1];
        la.sorgqr(m, n, k, new float[0], lda, new float[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new float[(int)work[0]];
        la.sorgqr(m, n, k, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void cungqr(Lapack la, int m, int n, int k, float[] a, int lda, float[] tau) {
        PlainLapack.checkStrictlyPositive(k, "k");
        PlainLapack.checkValueAtLeast(n, k, "n");
        PlainLapack.checkValueAtLeast(m, n, "m");
        PlainLapack.checkValueAtLeast(lda, Math.max(1, m), "lda");
        PlainLapack.checkMinLen(a, 2 * m * n, "a");
        PlainLapack.checkMinLen(tau, 2 * k, "tau");
        int info = la.cungqr(m, n, k, a, lda, tau);
        if (info != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dorgrq(Lapack la, int m, int n, int k, double[] a, int lda, double[] tau) {
        intW info = new intW(0);
        double[] work = new double[1];
        la.dorgrq(m, n, k, new double[0], lda, new double[0], work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dorgrq(m, n, k, a, lda, tau, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dormrz(Lapack la, TSide side, TTrans trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int ldc) {
        intW info = new intW(0);
        double[] work = new double[1];
        la.dormrz(side.val(), trans.val(), m, n, k, l, new double[0], lda, new double[0], new double[0], ldc, work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dormrz(side.val(), trans.val(), m, n, k, l, a, lda, tau, c, ldc, work, work.length, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static double dpbcon(Lapack la, TUpLo uplo, int n, int diagCount, double[] ab, double normA) {
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        double[] work = new double[3 * n];
        int[] iwork = new int[n];
        int ldab = Math.max(1, diagCount + 1);
        la.dpbcon(uplo.val(), n, diagCount, ab, ldab, normA, rcond, work, iwork, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        return rcond.val;
    }

    public static void dpbsv(Lapack la, TUpLo uplo, int n, int diagCount, int rhsCount, double[] ab, double[] b, int ldb) {
        intW info = new intW(0);
        int ldab = Math.max(1, diagCount + 1);
        la.dpbsv(uplo.val(), n, diagCount, rhsCount, ab, ldab, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("A leading minor of A is not positive-definite. Solution could not be computed.");
            }
        }
    }

    public static void dpbtrf(Lapack la, TUpLo uplo, int n, int diagCount, double[] ab) {
        intW info = new intW(0);
        int ldab = Math.max(1, diagCount + 1);
        la.dpbtrf(uplo.val(), n, diagCount, ab, ldab, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The leading minor of order " + info.val + " is not positive-definite. The factorization could not be completed.");
            }
        }
    }

    public static void dpbtrs(Lapack la, TUpLo uplo, int n, int diagCount, int rhsCount, double[] ab, double[] b, int ldb) {
        intW info = new intW(0);
        int ldab = Math.max(1, diagCount + 1);
        la.dpbtrs(uplo.val(), n, diagCount, rhsCount, ab, ldab, b, ldb, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static double dpocon(Lapack la, TUpLo uplo, int n, double[] a, int lda, double normA) {
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        double[] work = new double[3 * n];
        int[] iwork = new int[n];
        la.dpocon(uplo.val(), n, a, lda, normA, rcond, work, iwork, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        return rcond.val;
    }

    public static void dposv(Lapack la, TUpLo uplo, int n, int rhsCount, double[] a, int lda, double[] b, int ldb) {
        intW info = new intW(0);
        la.dposv(uplo.val(), n, rhsCount, a, lda, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The leading minor of order " + info.val + " of A is not positive-definite. The factorization could not be completed " + " and the solution has not been computed.");
            }
        }
    }

    public static void dpotrf(Lapack la, TUpLo uplo, int n, double[] a, int lda) {
        intW info = new intW(0);
        la.dpotrf(uplo.val(), n, a, lda, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The leading minor of order " + info.val + " is not positive-definite. The factorization could not be completed.");
            }
        }
    }

    public static void dpotrs(Lapack la, TUpLo uplo, int n, int rhsCount, double[] a, int lda, double[] b, int ldb) {
        intW info = new intW(0);
        la.dpotrs(uplo.val(), n, rhsCount, a, lda, b, ldb, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static double dppcon(Lapack la, TUpLo uplo, int n, double[] ap, double normA) {
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        double[] work = new double[3 * n];
        int[] iwork = new int[n];
        la.dppcon(uplo.val(), n, ap, normA, rcond, work, iwork, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        return rcond.val;
    }

    public static void dppsv(Lapack la, TUpLo uplo, int n, int rhsCount, double[] ap, double[] b, int ldb) {
        intW info = new intW(0);
        la.dppsv(uplo.val(), n, rhsCount, ap, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The leading minor of order " + info.val + " of A is not positive-definite. The factorization could not be completed " + " and the solution has not been computed.");
            }
        }
    }

    public static void dpptrf(Lapack la, TUpLo uplo, int n, double[] ap) {
        intW info = new intW(0);
        la.dpptrf(uplo.val(), n, ap, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The leading minor of order " + info.val + " is not positive-definite. The factorization could not be completed.");
            }
        }
    }

    public static void dpptrs(Lapack la, TUpLo uplo, int n, int rhsCount, double[] ap, double[] b, int ldb) {
        intW info = new intW(0);
        la.dpptrs(uplo.val(), n, rhsCount, ap, b, ldb, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
    }

    public static void dptsv(Lapack la, int n, int rhsCount, double[] d, double[] e, double[] b, int ldb) {
        intW info = new intW(0);
        la.dptsv(n, rhsCount, d, e, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The leading minor of order " + info.val + " is not positive-definite. Solution could not be computed.");
            }
        }
    }

    public static void dsbevd(Lapack la, TEigJob jobz, TUpLo uplo, int n, int diagCount, double[] ab, double[] w, double[] z, int ldz) {
        intW info = new intW(0);
        double[] work = new double[1];
        int[] iwork = new int[1];
        int ldab = Math.max(1, diagCount + 1);
        la.dsbevd(jobz.val(), uplo.val(), n, diagCount, new double[0], ldab, new double[0], new double[0], ldz, work, -1, iwork, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        iwork = new int[iwork[0]];
        la.dsbevd(jobz.val(), uplo.val(), n, diagCount, ab, ldab, w, z, ldz, work, work.length, iwork, iwork.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new NotConvergedException("Failed to converge");
            }
        }
    }

    public static void dspevd(Lapack la, TEigJob jobz, TUpLo uplo, int n, double[] ap, double[] w, double[] z, int ldz) {
        intW info = new intW(0);
        double[] work = new double[1];
        int[] iwork = new int[1];
        la.dspevd(jobz.val(), uplo.val(), n, new double[0], new double[0], new double[0], ldz, work, -1, iwork, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        iwork = new int[iwork[0]];
        la.dspevd(jobz.val(), uplo.val(), n, ap, w, z, ldz, work, work.length, iwork, iwork.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new NotConvergedException("Failed to converge");
            }
        }
    }

    public static void dspsv(Lapack la, TUpLo uplo, int n, int rhsCount, double[] ap, int[] indices, double[] b, int ldb) {
        intW info = new intW(0);
        la.dspsv(uplo.val(), n, rhsCount, ap, indices, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The block diagonal matrix D is exactly singular. Solution could not be computed.");
            }
        }
    }

    public static int dstevr(Lapack la, TEigJob jobz, TRange range, int n, double[] d, double[] e, double vLower, double vUpper, int iLower, int iUpper, double abstol, double[] w, double[] z, int ldz, int[] supportZ) {
        intW info = new intW(0);
        intW m = new intW(0);
        double[] work = new double[1];
        int[] iwork = new int[1];
        la.dstevr(jobz.val(), range.val(), n, new double[0], new double[0], vLower, vUpper, iLower, iUpper, abstol, m, new double[0], new double[0], ldz, new int[0], work, -1, iwork, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        iwork = new int[iwork[0]];
        la.dstevr(jobz.val(), range.val(), n, d, e, vLower, vUpper, iLower, iUpper, abstol, m, w, z, ldz, supportZ, work, work.length, iwork, iwork.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new IllegalStateException("Internal error");
            }
        }
        return m.val;
    }

    public static int dsyevr(Lapack la, TEigJob jobz, TRange range, TUpLo uplo, int n, double[] a, int lda, double vLower, double vUpper, int iLower, int iUpper, double abstol, double[] w, double[] z, int ldz, int[] supportZ) {
        intW info = new intW(0);
        intW m = new intW(0);
        double[] work = new double[1];
        int[] iwork = new int[1];
        la.dsyevr(jobz.val(), range.val(), uplo.val(), n, new double[0], lda, vLower, vUpper, iLower, iUpper, abstol, m, new double[0], new double[0], ldz, new int[0], work, -1, iwork, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        iwork = new int[iwork[0]];
        la.dsyevr(jobz.val(), range.val(), uplo.val(), n, a, lda, vLower, vUpper, iLower, iUpper, abstol, m, w, z, ldz, supportZ, work, work.length, iwork, iwork.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new IllegalStateException("Internal error");
            }
        }
        return m.val;
    }

    public static void dsygvd(Lapack la, int type, TEigJob jobz, TUpLo uplo, int n, double[] a, int lda, double[] b, int ldb, double[] w) {
        if (type < 1 || type > 3) {
            throw new IllegalArgumentException("type : " + type + " must be from closed interval [1..3]");
        }
        intW info = new intW(0);
        double[] work = new double[1];
        int[] iwork = new int[1];
        la.dsygvd(type, jobz.val(), uplo.val(), n, new double[0], lda, new double[0], ldb, new double[0], work, -1, iwork, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        iwork = new int[iwork[0]];
        la.dsygvd(type, jobz.val(), uplo.val(), n, a, lda, b, ldb, w, work, work.length, iwork, iwork.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                if (info.val > n) {
                    throw new ComputationTruncatedException("The leading minor of order " + info.val + " of B is not positive-semidifinte. Factorization could not be completed.");
                }
                throw new NotConvergedException("Failed to converge");
            }
        }
    }

    public static void dsysv(Lapack la, TUpLo uplo, int n, int rhsCount, double[] a, int lda, int[] indices, double[] b, int ldb) {
        intW info = new intW(0);
        double[] work = new double[1];
        la.dsysv(uplo.val(), n, rhsCount, new double[0], lda, new int[0], new double[0], ldb, work, -1, info);
        if (info.val != 0) {
            PlainLapack.throwIAEPosition(info);
        }
        work = new double[(int)work[0]];
        la.dsysv(uplo.val(), n, rhsCount, a, lda, indices, b, ldb, work, work.length, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("The block-diagonal matrix D is exactly singular. The solution couldn't be computed.");
            }
        }
    }

    public static void dtbtrs(Lapack la, TUpLo uplo, TTrans trans, TDiag diag, int n, int diagCount, int rhsCount, double[] ab, double[] b, int ldb) {
        intW info = new intW(0);
        int ldab = Math.max(1, diagCount + 1);
        la.dtbtrs(uplo.val(), trans.val(), diag.val(), n, diagCount, rhsCount, ab, ldab, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Matrix A is singular. The solution couldn't be computed.");
            }
        }
    }

    public static void dtptrs(Lapack la, TUpLo uplo, TTrans trans, TDiag diag, int n, int rhsCount, double[] ap, double[] b, int ldb) {
        intW info = new intW(0);
        la.dtptrs(uplo.val(), trans.val(), diag.val(), n, rhsCount, ap, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Matrix A is singular. The solution couldn't be computed.");
            }
        }
    }

    public static void dtrtrs(Lapack la, TUpLo uplo, TTrans trans, TDiag diag, int n, int rhsCount, double[] a, int lda, double[] b, int ldb) {
        intW info = new intW(0);
        la.dtrtrs(uplo.val(), trans.val(), diag.val(), n, rhsCount, a, lda, b, ldb, info);
        if (info.val != 0) {
            if (info.val < 0) {
                PlainLapack.throwIAEPosition(info);
            } else {
                throw new ComputationTruncatedException("Matrix A is singular. The solution couldn't be computed.");
            }
        }
    }

    private static void checkNonNegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException("Parameter " + name + " must be non-negative (value = " + value + ")");
        }
    }

    private static void checkStrictlyPositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException("Parameter " + name + " must be strictly positive (value = " + value + ")");
        }
    }

    private static void checkValueAtLeast(int value, int minVal, String name) {
        if (value < Math.max(1, minVal)) {
            throw new IllegalArgumentException("Parameter " + name + " must be at least " + Math.max(1, minVal) + " (value = " + value + ")");
        }
    }

    private static void checkMinLen(double[] array, int minLen, String name) {
        if (array.length < minLen) {
            throw new IllegalArgumentException("Length of array '" + name + "' argument must be at least " + minLen + " (length = " + array.length + ")");
        }
    }

    private static void checkMinLen(float[] array, int minLen, String name) {
        if (array.length < minLen) {
            throw new IllegalArgumentException("Length of array '" + name + "' argument must be at least " + minLen + " (length = " + array.length + ")");
        }
    }

    private static void checkMinLen(int[] array, int minLen, String name) {
        if (array.length < minLen) {
            throw new IllegalArgumentException("Length of array '" + name + "' argument must be at least " + minLen + " (length = " + array.length + ")");
        }
    }

    private static void throwIAEPosition(intW info) {
        throw new IllegalArgumentException("Illegal argument at position " + -info.val);
    }

    private static void throwIAEPosition(int info) {
        throw new IllegalArgumentException("Illegal argument at position " + -info);
    }

    protected PlainLapack() {
    }
}

