/*
 * Decompiled with CFR 0.152.
 */
package net.dedekind.lapack;

import java.util.Objects;
import net.dedekind.Order;
import net.dedekind.lapack.Lapack;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class LapackN
extends Lapack {
    private static final boolean USE_CRITICAL = true;

    @Override
    public final void dgbcon(String norm, int n, int kl, int ku, double[] ab, int abOffset, int ldab, int[] ipiv, int ipivOffset, double anorm, doubleW rcondDW, double[] work, int workOffset, int[] iwork, int iworkOffset, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(rcondDW, "rcond");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgbcon_n(Order.COL.code(), LapackN.norm(norm), n, kl, ku, ab, abOffset, ldab, ipiv, ipivOffset, anorm, rcondDW, work, workOffset, iwork, iworkOffset, true);
    }

    @Override
    public final void dgbsv(int n, int kl, int ku, int nrhs, double[] ab, int abOffset, int ldab, int[] ipiv, int ipivOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgbsv_n(Order.COL.code(), n, kl, ku, nrhs, ab, abOffset, ldab, ipiv, ipivOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dgbtrf(int m, int n, int kl, int ku, double[] ab, int abOffset, int ldab, int[] ipiv, int ipivOffset, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgbtrf_n(Order.COL.code(), m, n, kl, ku, ab, abOffset, ldab, ipiv, ipivOffset, true);
    }

    @Override
    public final void dgbtrs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int abOffset, int ldab, int[] ipiv, int ipivOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgbtrs_n(Order.COL.code(), LapackN.trans(trans), n, kl, ku, nrhs, ab, abOffset, ldab, ipiv, ipivOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dgecon(String norm, int n, double[] a, int aOffset, int lda, double anorm, doubleW rcondDW, double[] work, int workOffset, int[] iwork, int iworkOffset, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(rcondDW, "rcond");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgecon_n(Order.COL.code(), LapackN.norm(norm), n, a, aOffset, lda, anorm, rcondDW, work, workOffset, iwork, iworkOffset, true);
    }

    @Override
    public final void dgeev(String jobvl, String jobvr, int n, double[] a, int aOffset, int lda, double[] wr, int wrOffset, double[] wi, int wiOffset, double[] vl, int vlOffset, int ldvl, double[] vr, int vrOffset, int ldvr, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(wr, "wr");
        Objects.requireNonNull(wi, "wi");
        Objects.requireNonNull(vl, "vl");
        Objects.requireNonNull(vr, "vr");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgeev_n(Order.COL.code(), LapackN.eigJob(jobvl), LapackN.eigJob(jobvr), n, a, aOffset, lda, wr, wrOffset, wi, wiOffset, vl, vlOffset, ldvl, vr, vrOffset, ldvr, work, workOffset, lwork, true);
    }

    @Override
    public final void dgelqf(int m, int n, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgelqf_n(Order.COL.code(), m, n, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dgels(String trans, int m, int n, int nrhs, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgels_n(Order.COL.code(), LapackN.trans(trans), m, n, nrhs, a, aOffset, lda, b, bOffset, ldb, work, workOffset, lwork, true);
    }

    @Override
    public final void dgeqlf(int m, int n, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgeqlf_n(Order.COL.code(), m, n, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dgeqp3(int m, int n, double[] a, int aOffset, int lda, int[] jpvt, int jpvtOffset, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(jpvt, "jpvt");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgeqp3_n(Order.COL.code(), m, n, a, aOffset, lda, jpvt, jpvtOffset, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dgeqrf(int m, int n, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgeqrf_n(Order.COL.code(), m, n, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dgerqf(int m, int n, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgerqf_n(Order.COL.code(), m, n, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dgesdd(String jobz, int m, int n, double[] a, int aOffset, int lda, double[] s, int sOffset, double[] u, int uOffset, int ldu, double[] vt, int vtOffset, int ldvt, double[] work, int workOffset, int lwork, int[] iwork, int iworkOffset, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(s, "s");
        Objects.requireNonNull(u, "u");
        Objects.requireNonNull(vt, "vt");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgesdd_n(Order.COL.code(), LapackN.svdJob(jobz), m, n, a, aOffset, lda, s, sOffset, u, uOffset, ldu, vt, vtOffset, ldvt, work, workOffset, lwork, iwork, iworkOffset, true);
    }

    @Override
    public final void dgesv(int n, int nrhs, double[] a, int aOffset, int lda, int[] ipiv, int ipivOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgesv_n(Order.COL.code(), n, nrhs, a, aOffset, lda, ipiv, ipivOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dgetrf(int m, int n, double[] a, int aOffset, int lda, int[] ipiv, int ipivOffset, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgetrf_n(Order.COL.code(), m, n, a, aOffset, lda, ipiv, ipivOffset, true);
    }

    @Override
    public final void sgetrf(int m, int n, float[] a, int aOffset, int lda, int[] ipiv, int ipivOffset, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.sgetrf_n(Order.COL.code(), m, n, a, aOffset, lda, ipiv, ipivOffset, true);
    }

    @Override
    public final void dgetrs(String trans, int n, int nrhs, double[] a, int aOffset, int lda, int[] ipiv, int ipivOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgetrs_n(Order.COL.code(), LapackN.trans(trans), n, nrhs, a, aOffset, lda, ipiv, ipivOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dgtsv(int n, int nrhs, double[] dl, int dlOffset, double[] d, int dOffset, double[] du, int duOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(dl, "dl");
        Objects.requireNonNull(d, "d");
        Objects.requireNonNull(du, "du");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dgtsv_n(Order.COL.code(), n, nrhs, dl, dlOffset, d, dOffset, du, duOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dlaswp(int n, double[] a, int aOffset, int lda, int k1, int k2, int[] ipiv, int ipivOffset, int incx) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        LapackN.dlaswp_n(Order.COL.code(), n, a, aOffset, lda, k1, k2, ipiv, ipivOffset, incx, true);
    }

    @Override
    public final void dorglq(int m, int n, int k, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dorglq_n(Order.COL.code(), m, n, k, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dorgql(int m, int n, int k, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dorgql_n(Order.COL.code(), m, n, k, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dorgqr(int m, int n, int k, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dorgqr_n(Order.COL.code(), m, n, k, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dorgrq(int m, int n, int k, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dorgrq_n(Order.COL.code(), m, n, k, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void dormrz(String side, String trans, int m, int n, int k, int l, double[] a, int aOffset, int lda, double[] tau, int tauOffset, double[] c, int cOffset, int ldc, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(c, "c");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dormrz_n(Order.COL.code(), LapackN.side(side), LapackN.trans(trans), m, n, k, l, a, aOffset, lda, tau, tauOffset, c, cOffset, ldc, work, workOffset, lwork, true);
    }

    @Override
    public final void dpbcon(String uplo, int n, int kd, double[] ab, int abOffset, int ldab, double anorm, doubleW rcondDW, double[] work, int workOffset, int[] iwork, int iworkOffset, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(rcondDW, "rcond");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpbcon_n(Order.COL.code(), LapackN.uplo(uplo), n, kd, ab, abOffset, ldab, anorm, rcondDW, work, workOffset, iwork, iworkOffset, true);
    }

    @Override
    public final void dpbsv(String uplo, int n, int kd, int nrhs, double[] ab, int abOffset, int ldab, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpbsv_n(Order.COL.code(), LapackN.uplo(uplo), n, kd, nrhs, ab, abOffset, ldab, b, bOffset, ldb, true);
    }

    @Override
    public final void dpbtrf(String uplo, int n, int kd, double[] ab, int abOffset, int ldab, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpbtrf_n(Order.COL.code(), LapackN.uplo(uplo), n, kd, ab, abOffset, ldab, true);
    }

    @Override
    public final void dpbtrs(String uplo, int n, int kd, int nrhs, double[] ab, int abOffset, int ldab, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpbtrs_n(Order.COL.code(), LapackN.uplo(uplo), n, kd, nrhs, ab, abOffset, ldab, b, bOffset, ldb, true);
    }

    @Override
    public final void dpocon(String uplo, int n, double[] a, int aOffset, int lda, double anorm, doubleW rcondDW, double[] work, int workOffset, int[] iwork, int iworkOffset, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(rcondDW, "rcond");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpocon_n(Order.COL.code(), LapackN.uplo(uplo), n, a, aOffset, lda, anorm, rcondDW, work, workOffset, iwork, iworkOffset, true);
    }

    @Override
    public final void dposv(String uplo, int n, int nrhs, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dposv_n(Order.COL.code(), LapackN.uplo(uplo), n, nrhs, a, aOffset, lda, b, bOffset, ldb, true);
    }

    @Override
    public final void dpotrf(String uplo, int n, double[] a, int aOffset, int lda, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpotrf_n(Order.COL.code(), LapackN.uplo(uplo), n, a, aOffset, lda, true);
    }

    @Override
    public final void dpotrs(String uplo, int n, int nrhs, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpotrs_n(Order.COL.code(), LapackN.uplo(uplo), n, nrhs, a, aOffset, lda, b, bOffset, ldb, true);
    }

    @Override
    public final void dppcon(String uplo, int n, double[] ap, int apOffset, double anorm, doubleW rcondDW, double[] work, int workOffset, int[] iwork, int iworkOffset, intW info) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(rcondDW, "rcond");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dppcon_n(Order.COL.code(), LapackN.uplo(uplo), n, ap, apOffset, anorm, rcondDW, work, workOffset, iwork, iworkOffset, true);
    }

    @Override
    public final void dppsv(String uplo, int n, int nrhs, double[] ap, int apOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dppsv_n(Order.COL.code(), LapackN.uplo(uplo), n, nrhs, ap, apOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dpptrf(String uplo, int n, double[] ap, int apOffset, intW info) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpptrf_n(Order.COL.code(), LapackN.uplo(uplo), n, ap, apOffset, true);
    }

    @Override
    public final void dpptrs(String uplo, int n, int nrhs, double[] ap, int apOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dpptrs_n(Order.COL.code(), LapackN.uplo(uplo), n, nrhs, ap, apOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dptsv(int n, int nrhs, double[] d, int dOffset, double[] e, int eOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(d, "d");
        Objects.requireNonNull(e, "e");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dptsv_n(Order.COL.code(), n, nrhs, d, dOffset, e, eOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dsbevd(String jobz, String uplo, int n, int kd, double[] ab, int abOffset, int ldab, double[] w, int wOffset, double[] z, int zOffset, int ldz, double[] work, int workOffset, int lwork, int[] iwork, int iworkOffset, int liwork, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(z, "z");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dsbevd_n(Order.COL.code(), LapackN.eigJob(jobz), LapackN.uplo(uplo), n, kd, ab, abOffset, ldab, w, wOffset, z, zOffset, ldz, work, workOffset, lwork, iwork, iworkOffset, liwork, true);
    }

    @Override
    public final void dspevd(String jobz, String uplo, int n, double[] ap, int apOffset, double[] w, int wOffset, double[] z, int zOffset, int ldz, double[] work, int workOffset, int lwork, int[] iwork, int iworkOffset, int liwork, intW info) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(z, "z");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dspevd_n(Order.COL.code(), LapackN.eigJob(jobz), LapackN.uplo(uplo), n, ap, apOffset, w, wOffset, z, zOffset, ldz, work, workOffset, lwork, iwork, iworkOffset, liwork, true);
    }

    @Override
    public final void dspsv(String uplo, int n, int nrhs, double[] ap, int apOffset, int[] ipiv, int ipivOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dspsv_n(Order.COL.code(), LapackN.uplo(uplo), n, nrhs, ap, apOffset, ipiv, ipivOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dstevr(String jobz, String range, int n, double[] d, int dOffset, double[] e, int eOffset, double vl, double vu, int il, int iu, double abstol, intW mIW, double[] w, int wOffset, double[] z, int zOffset, int ldz, int[] isuppz, int isuppzOffset, double[] work, int workOffset, int lwork, int[] iwork, int iworkOffset, int liwork, intW info) {
        Objects.requireNonNull(d, "d");
        Objects.requireNonNull(e, "e");
        Objects.requireNonNull(mIW, "m");
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(z, "z");
        Objects.requireNonNull(isuppz, "isuppz");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dstevr_n(Order.COL.code(), LapackN.eigJob(jobz), LapackN.range(range), n, d, dOffset, e, eOffset, vl, vu, il, iu, abstol, mIW, w, wOffset, z, zOffset, ldz, isuppz, isuppzOffset, work, workOffset, lwork, iwork, iworkOffset, liwork, true);
    }

    @Override
    public final void dsyevr(String jobz, String range, String uplo, int n, double[] a, int aOffset, int lda, double vl, double vu, int il, int iu, double abstol, intW mIW, double[] w, int wOffset, double[] z, int zOffset, int ldz, int[] isuppz, int isuppzOffset, double[] work, int workOffset, int lwork, int[] iwork, int iworkOffset, int liwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(mIW, "m");
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(z, "z");
        Objects.requireNonNull(isuppz, "isuppz");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dsyevr_n(Order.COL.code(), LapackN.eigJob(jobz), LapackN.range(range), LapackN.uplo(uplo), n, a, aOffset, lda, vl, vu, il, iu, abstol, mIW, w, wOffset, z, zOffset, ldz, isuppz, isuppzOffset, work, workOffset, lwork, iwork, iworkOffset, liwork, true);
    }

    @Override
    public final void dsygvd(int itype, String jobz, String uplo, int n, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, double[] w, int wOffset, double[] work, int workOffset, int lwork, int[] iwork, int iworkOffset, int liwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dsygvd_n(Order.COL.code(), itype, LapackN.eigJob(jobz), LapackN.uplo(uplo), n, a, aOffset, lda, b, bOffset, ldb, w, wOffset, work, workOffset, lwork, iwork, iworkOffset, liwork, true);
    }

    @Override
    public final void dsysv(String uplo, int n, int nrhs, double[] a, int aOffset, int lda, int[] ipiv, int ipivOffset, double[] b, int bOffset, int ldb, double[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dsysv_n(Order.COL.code(), LapackN.uplo(uplo), n, nrhs, a, aOffset, lda, ipiv, ipivOffset, b, bOffset, ldb, work, workOffset, lwork, true);
    }

    @Override
    public final void dtbtrs(String uplo, String trans, String diag, int n, int kd, int nrhs, double[] ab, int abOffset, int ldab, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ab, "ab");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dtbtrs_n(Order.COL.code(), LapackN.uplo(uplo), LapackN.trans(trans), LapackN.diag(diag), n, kd, nrhs, ab, abOffset, ldab, b, bOffset, ldb, true);
    }

    @Override
    public final void dtptrs(String uplo, String trans, String diag, int n, int nrhs, double[] ap, int apOffset, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dtptrs_n(Order.COL.code(), LapackN.uplo(uplo), LapackN.trans(trans), LapackN.diag(diag), n, nrhs, ap, apOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void dtrtrs(String uplo, String trans, String diag, int n, int nrhs, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.dtrtrs_n(Order.COL.code(), LapackN.uplo(uplo), LapackN.trans(trans), LapackN.diag(diag), n, nrhs, a, aOffset, lda, b, bOffset, ldb, true);
    }

    @Override
    public final void sgeev(String jobvl, String jobvr, int n, float[] a, int aOffset, int lda, float[] wr, int wrOffset, float[] wi, int wiOffset, float[] vl, int vlOffset, int ldvl, float[] vr, int vrOffset, int ldvr, float[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(wr, "wr");
        Objects.requireNonNull(wi, "wi");
        Objects.requireNonNull(vl, "vl");
        Objects.requireNonNull(vr, "vr");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.sgeev_n(Order.COL.code(), LapackN.eigJob(jobvl), LapackN.eigJob(jobvr), n, a, aOffset, lda, wr, wrOffset, wi, wiOffset, vl, vlOffset, ldvl, vr, vrOffset, ldvr, work, workOffset, lwork, true);
    }

    @Override
    public final void sgels(String trans, int m, int n, int nrhs, float[] a, int aOffset, int lda, float[] b, int bOffset, int ldb, float[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.sgels_n(Order.COL.code(), LapackN.trans(trans), m, n, nrhs, a, aOffset, lda, b, bOffset, ldb, work, workOffset, lwork, true);
    }

    @Override
    public final void sgesdd(String jobz, int m, int n, float[] a, int aOffset, int lda, float[] s, int sOffset, float[] u, int uOffset, int ldu, float[] vt, int vtOffset, int ldvt, float[] work, int workOffset, int lwork, int[] iwork, int iworkOffset, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(s, "s");
        Objects.requireNonNull(u, "u");
        Objects.requireNonNull(vt, "vt");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(iwork, "iwork");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.sgesdd_n(Order.COL.code(), LapackN.svdJob(jobz), m, n, a, aOffset, lda, s, sOffset, u, uOffset, ldu, vt, vtOffset, ldvt, work, workOffset, lwork, iwork, iworkOffset, true);
    }

    @Override
    public final void sgesv(int n, int nrhs, float[] a, int aOffset, int lda, int[] ipiv, int ipivOffset, float[] b, int bOffset, int ldb, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.sgesv_n(Order.COL.code(), n, nrhs, a, aOffset, lda, ipiv, ipivOffset, b, bOffset, ldb, true);
    }

    @Override
    public final void sgeqrf(int m, int n, float[] a, int aOffset, int lda, float[] tau, int tauOffset, float[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.sgeqrf_n(Order.COL.code(), m, n, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final void sorgqr(int m, int n, int k, float[] a, int aOffset, int lda, float[] tau, int tauOffset, float[] work, int workOffset, int lwork, intW info) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        Objects.requireNonNull(work, "work");
        Objects.requireNonNull(info, "info");
        info.val = LapackN.sorgqr_n(Order.COL.code(), m, n, k, a, aOffset, lda, tau, tauOffset, work, workOffset, lwork, true);
    }

    @Override
    public final int cgeev(String jobvl, String jobvr, int n, float[] a, int lda, float[] w, float[] vl, int ldvl, float[] vr, int ldvr) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(vl, "vl");
        Objects.requireNonNull(vr, "vr");
        Objects.requireNonNull(jobvl, "jobvl");
        Objects.requireNonNull(jobvr, "jobvr");
        return LapackN.cgeev_n(Order.COL.code(), LapackN.eigJob(jobvl), LapackN.eigJob(jobvr), n, a, lda, w, vl, ldvl, vr, ldvr, true);
    }

    @Override
    public final int zgeev(String jobvl, String jobvr, int n, double[] a, int lda, double[] w, double[] vl, int ldvl, double[] vr, int ldvr) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(vl, "vl");
        Objects.requireNonNull(vr, "vr");
        Objects.requireNonNull(jobvl, "jobvl");
        Objects.requireNonNull(jobvr, "jobvr");
        return LapackN.zgeev_n(Order.COL.code(), LapackN.eigJob(jobvl), LapackN.eigJob(jobvr), n, a, lda, w, vl, ldvl, vr, ldvr, true);
    }

    @Override
    public final int cgesdd(String jobz, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(s, "s");
        Objects.requireNonNull(u, "u");
        Objects.requireNonNull(vt, "vt");
        Objects.requireNonNull(jobz, "jobz");
        return LapackN.cgesdd_n(Order.COL.code(), LapackN.svdJob(jobz), m, n, a, lda, s, u, ldu, vt, ldvt, true);
    }

    @Override
    public final int zgesdd(String jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(s, "s");
        Objects.requireNonNull(u, "u");
        Objects.requireNonNull(vt, "vt");
        Objects.requireNonNull(jobz, "jobz");
        return LapackN.zgesdd_n(Order.COL.code(), LapackN.svdJob(jobz), m, n, a, lda, s, u, ldu, vt, ldvt, true);
    }

    @Override
    public final int cgels(String trans, int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(trans, "trans");
        return LapackN.cgels_n(Order.COL.code(), LapackN.trans(trans), m, n, nrhs, a, lda, b, ldb, true);
    }

    @Override
    public final int zgels(String trans, int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(trans, "trans");
        return LapackN.zgels_n(Order.COL.code(), LapackN.trans(trans), m, n, nrhs, a, lda, b, ldb, true);
    }

    @Override
    public final int cgesv(int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        return LapackN.cgesv_n(Order.COL.code(), n, nrhs, a, lda, ipiv, b, ldb, true);
    }

    @Override
    public final int zgesv(int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        Objects.requireNonNull(b, "b");
        return LapackN.zgesv_n(Order.COL.code(), n, nrhs, a, lda, ipiv, b, ldb, true);
    }

    @Override
    public final int cgeqrf(int m, int n, float[] a, int lda, float[] tau) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        return LapackN.cgeqrf_n(Order.COL.code(), m, n, a, lda, tau, true);
    }

    @Override
    public final int zgeqrf(int m, int n, double[] a, int lda, double[] tau) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        return LapackN.zgeqrf_n(Order.COL.code(), m, n, a, lda, tau, true);
    }

    @Override
    public final int cgetrf(int m, int n, float[] a, int lda, int[] ipiv) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        return LapackN.cgetrf_n(Order.COL.code(), m, n, a, lda, ipiv, true);
    }

    @Override
    public final int zgetrf(int m, int n, double[] a, int lda, int[] ipiv) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(ipiv, "ipiv");
        return LapackN.zgetrf_n(Order.COL.code(), m, n, a, lda, ipiv, true);
    }

    @Override
    public final int cungqr(int m, int n, int k, float[] a, int lda, float[] tau) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        return LapackN.cungqr_n(Order.COL.code(), m, n, k, a, lda, tau, true);
    }

    @Override
    public final int zungqr(int m, int n, int k, double[] a, int lda, double[] tau) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(tau, "tau");
        return LapackN.zungqr_n(Order.COL.code(), m, n, k, a, lda, tau, true);
    }

    private static native int dgbcon_n(int var0, byte var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, double var10, doubleW var12, double[] var13, int var14, int[] var15, int var16, boolean var17);

    private static native int dgbsv_n(int var0, int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, double[] var10, int var11, int var12, boolean var13);

    private static native int dgbtrf_n(int var0, int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, boolean var10);

    private static native int dgbtrs_n(int var0, byte var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, int[] var9, int var10, double[] var11, int var12, int var13, boolean var14);

    private static native int dgecon_n(int var0, byte var1, int var2, double[] var3, int var4, int var5, double var6, doubleW var8, double[] var9, int var10, int[] var11, int var12, boolean var13);

    private static native int dgeev_n(int var0, byte var1, byte var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, boolean var20);

    private static native int dgelqf_n(int var0, int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dgels_n(int var0, byte var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, boolean var14);

    private static native int dgeqlf_n(int var0, int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dgeqp3_n(int var0, int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, boolean var13);

    private static native int dgeqrf_n(int var0, int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dgerqf_n(int var0, int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dgesdd_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, int[] var18, int var19, boolean var20);

    private static native int dgesv_n(int var0, int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dgetrf_n(int var0, int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, boolean var8);

    private static native int dgetrs_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native int dgtsv_n(int var0, int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native void dlaswp_n(int var0, int var1, double[] var2, int var3, int var4, int var5, int var6, int[] var7, int var8, int var9, boolean var10);

    private static native int dorglq_n(int var0, int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native int dorgql_n(int var0, int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native int dorgqr_n(int var0, int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native int dorgrq_n(int var0, int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native int dormrz_n(int var0, byte var1, byte var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, boolean var18);

    private static native int dpbcon_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int var6, double var7, doubleW var9, double[] var10, int var11, int[] var12, int var13, boolean var14);

    private static native int dpbsv_n(int var0, byte var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dpbtrf_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int var6, boolean var7);

    private static native int dpbtrs_n(int var0, byte var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dpocon_n(int var0, byte var1, int var2, double[] var3, int var4, int var5, double var6, doubleW var8, double[] var9, int var10, int[] var11, int var12, boolean var13);

    private static native int dposv_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, boolean var10);

    private static native int dpotrf_n(int var0, byte var1, int var2, double[] var3, int var4, int var5, boolean var6);

    private static native int dpotrs_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, boolean var10);

    private static native int dppcon_n(int var0, byte var1, int var2, double[] var3, int var4, double var5, doubleW var7, double[] var8, int var9, int[] var10, int var11, boolean var12);

    private static native int dppsv_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, boolean var9);

    private static native int dpptrf_n(int var0, byte var1, int var2, double[] var3, int var4, boolean var5);

    private static native int dpptrs_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, boolean var9);

    private static native int dptsv_n(int var0, int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, boolean var10);

    private static native int dsbevd_n(int var0, byte var1, byte var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, int[] var16, int var17, int var18, boolean var19);

    private static native int dspevd_n(int var0, byte var1, byte var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, int[] var14, int var15, int var16, boolean var17);

    private static native int dspsv_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dstevr_n(int var0, byte var1, byte var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, boolean var30);

    private static native int dsyevr_n(int var0, byte var1, byte var2, byte var3, int var4, double[] var5, int var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, boolean var30);

    private static native int dsygvd_n(int var0, int var1, byte var2, byte var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, int[] var16, int var17, int var18, boolean var19);

    private static native int dsysv_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, boolean var15);

    private static native int dtbtrs_n(int var0, byte var1, byte var2, byte var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, boolean var13);

    private static native int dtptrs_n(int var0, byte var1, byte var2, byte var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native int dtrtrs_n(int var0, byte var1, byte var2, byte var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native int sgeev_n(int var0, byte var1, byte var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, boolean var20);

    private static native int sgels_n(int var0, byte var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, boolean var14);

    private static native int sgesdd_n(int var0, byte var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, int[] var18, int var19, boolean var20);

    private static native int sgesv_n(int var0, int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, int var10, boolean var11);

    private static native int sgeqrf_n(int var0, int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, boolean var11);

    private static native int sorgqr_n(int var0, int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, boolean var12);

    private static native int sgetrf_n(int var0, int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, boolean var8);

    private static native int cgeev_n(int var0, byte var1, byte var2, int var3, float[] var4, int var5, float[] var6, float[] var7, int var8, float[] var9, int var10, boolean var11);

    private static native int zgeev_n(int var0, byte var1, byte var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, double[] var9, int var10, boolean var11);

    private static native int cgesdd_n(int var0, byte var1, int var2, int var3, float[] var4, int var5, float[] var6, float[] var7, int var8, float[] var9, int var10, boolean var11);

    private static native int zgesdd_n(int var0, byte var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, double[] var9, int var10, boolean var11);

    private static native int cgels_n(int var0, byte var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, boolean var9);

    private static native int zgels_n(int var0, byte var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, boolean var9);

    private static native int cgesv_n(int var0, int var1, int var2, float[] var3, int var4, int[] var5, float[] var6, int var7, boolean var8);

    private static native int zgesv_n(int var0, int var1, int var2, double[] var3, int var4, int[] var5, double[] var6, int var7, boolean var8);

    private static native int cgeqrf_n(int var0, int var1, int var2, float[] var3, int var4, float[] var5, boolean var6);

    private static native int zgeqrf_n(int var0, int var1, int var2, double[] var3, int var4, double[] var5, boolean var6);

    private static native int cgetrf_n(int var0, int var1, int var2, float[] var3, int var4, int[] var5, boolean var6);

    private static native int zgetrf_n(int var0, int var1, int var2, double[] var3, int var4, int[] var5, boolean var6);

    private static native int cungqr_n(int var0, int var1, int var2, int var3, float[] var4, int var5, float[] var6, boolean var7);

    private static native int zungqr_n(int var0, int var1, int var2, int var3, double[] var4, int var5, double[] var6, boolean var7);

    static native void initialize_n();

    private static byte norm(String norm) {
        char c = Character.toUpperCase(norm.charAt(0));
        if (c == '1' || c == 'I' || c == 'O') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid norm: " + norm);
    }

    private static byte trans(String trans) {
        char c = Character.toUpperCase(trans.charAt(0));
        if (c == 'N' || c == 'T' || c == 'C') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid transposition: " + trans);
    }

    private static byte eigJob(String job) {
        char c = Character.toUpperCase(job.charAt(0));
        if (c == 'V' || c == 'N') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid eigenvalue job: " + job);
    }

    private static byte range(String range) {
        char c = Character.toUpperCase(range.charAt(0));
        if (c == 'A' || c == 'I' || c == 'V') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid range: " + range);
    }

    private static byte svdJob(String job) {
        char c = Character.toUpperCase(job.charAt(0));
        if (c == 'A' || c == 'S' || c == 'O' || c == 'N') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid svd job: " + job);
    }

    private static byte uplo(String uplo) {
        char c = Character.toUpperCase(uplo.charAt(0));
        if (c == 'U' || c == 'L') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid uplo: " + uplo);
    }

    private static byte side(String side) {
        char c = Character.toUpperCase(side.charAt(0));
        if (c == 'L' || c == 'R') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid side: " + side);
    }

    private static byte diag(String diag) {
        char c = Character.toUpperCase(diag.charAt(0));
        if (c == 'N' || c == 'U') {
            return (byte)c;
        }
        throw new IllegalArgumentException("Invalid diag: " + diag);
    }

    protected LapackN() {
    }
}

