/*
 * Decompiled with CFR 0.152.
 */
package net.dedekind.lapack;

import net.dedekind.blas.Blas;
import net.dedekind.lapack.LapackJ;
import net.dedekind.lapack.LapackN;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public abstract class Lapack {
    private static final Lapack mkl;
    private static final Lapack netlib;

    private static Lapack loadNative() {
        Blas impl = null;
        try {
            impl = Blas.getInstance(true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (impl != null) {
            try {
                LapackN.initialize_n();
                return new LapackN();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    public static Lapack getInstance() {
        Lapack impl = mkl;
        if (impl != null) {
            return impl;
        }
        return netlib;
    }

    public static Lapack getInstance(boolean useMKL) {
        if (!useMKL) {
            return netlib;
        }
        Lapack impl = mkl;
        if (impl != null) {
            return impl;
        }
        throw new RuntimeException("MKL not loaded");
    }

    public final void dgbcon(String norm, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
        this.dgbcon(norm, n, kl, ku, ab, 0, ldab, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
    }

    public abstract void dgbcon(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, double var10, doubleW var12, double[] var13, int var14, int[] var15, int var16, intW var17);

    public final void dgbsv(int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info) {
        this.dgbsv(n, kl, ku, nrhs, ab, 0, ldab, ipiv, 0, b, 0, ldb, info);
    }

    public abstract void dgbsv(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, double[] var10, int var11, int var12, intW var13);

    public final void dgbtrf(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, intW info) {
        this.dgbtrf(m, n, kl, ku, ab, 0, ldab, ipiv, 0, info);
    }

    public abstract void dgbtrf(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, intW var10);

    public final void dgbtrs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info) {
        this.dgbtrs(trans, n, kl, ku, nrhs, ab, 0, ldab, ipiv, 0, b, 0, ldb, info);
    }

    public abstract void dgbtrs(String var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, int[] var9, int var10, double[] var11, int var12, int var13, intW var14);

    public final void dgecon(String norm, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
        this.dgecon(norm, n, a, 0, lda, anorm, rcond, work, 0, iwork, 0, info);
    }

    public abstract void dgecon(String var1, int var2, double[] var3, int var4, int var5, double var6, doubleW var8, double[] var9, int var10, int[] var11, int var12, intW var13);

    public final void dgeev(String jobvl, String jobvr, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info) {
        this.dgeev(jobvl, jobvr, n, a, 0, lda, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
    }

    public abstract void dgeev(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, intW var20);

    public final void dgelqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dgelqf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dgelqf(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dgels(String trans, int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] work, int lwork, intW info) {
        this.dgels(trans, m, n, nrhs, a, 0, lda, b, 0, ldb, work, 0, lwork, info);
    }

    public abstract void dgels(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, intW var14);

    public final void dgeqlf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dgeqlf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dgeqlf(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dgeqp3(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, int lwork, intW info) {
        this.dgeqp3(m, n, a, 0, lda, jpvt, 0, tau, 0, work, 0, lwork, info);
    }

    public abstract void dgeqp3(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, intW var13);

    public final void dgeqrf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dgeqrf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dgeqrf(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dgerqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dgerqf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dgerqf(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dgesdd(String jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, int[] iwork, intW info) {
        this.dgesdd(jobz, m, n, a, 0, lda, s, 0, u, 0, ldu, vt, 0, ldvt, work, 0, lwork, iwork, 0, info);
    }

    public abstract void dgesdd(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, int[] var18, int var19, intW var20);

    public final void dgesv(int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info) {
        this.dgesv(n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
    }

    public abstract void dgesv(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dgetrf(int m, int n, double[] a, int lda, int[] ipiv, intW info) {
        this.dgetrf(m, n, a, 0, lda, ipiv, 0, info);
    }

    public abstract void dgetrf(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    public final void dgetrs(String trans, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info) {
        this.dgetrs(trans, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
    }

    public abstract void dgetrs(String var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    public final void dgtsv(int n, int nrhs, double[] dl, double[] d, double[] du, double[] b, int ldb, intW info) {
        this.dgtsv(n, nrhs, dl, 0, d, 0, du, 0, b, 0, ldb, info);
    }

    public abstract void dgtsv(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    public final void dlaswp(int n, double[] a, int lda, int k1, int k2, int[] ipiv, int incx) {
        this.dlaswp(n, a, 0, lda, k1, k2, ipiv, 0, incx);
    }

    public abstract void dlaswp(int var1, double[] var2, int var3, int var4, int var5, int var6, int[] var7, int var8, int var9);

    public final void dorglq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dorglq(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dorglq(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    public final void dorgql(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dorgql(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dorgql(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    public final void dorgqr(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dorgqr(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dorgqr(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    public final void dorgrq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
        this.dorgrq(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void dorgrq(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    public final void dormrz(String side, String trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int ldc, double[] work, int lwork, intW info) {
        this.dormrz(side, trans, m, n, k, l, a, 0, lda, tau, 0, c, 0, ldc, work, 0, lwork, info);
    }

    public abstract void dormrz(String var1, String var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, intW var18);

    public final void dpbcon(String uplo, int n, int kd, double[] ab, int ldab, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
        this.dpbcon(uplo, n, kd, ab, 0, ldab, anorm, rcond, work, 0, iwork, 0, info);
    }

    public abstract void dpbcon(String var1, int var2, int var3, double[] var4, int var5, int var6, double var7, doubleW var9, double[] var10, int var11, int[] var12, int var13, intW var14);

    public final void dpbsv(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info) {
        this.dpbsv(uplo, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
    }

    public abstract void dpbsv(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dpbtrf(String uplo, int n, int kd, double[] ab, int ldab, intW info) {
        this.dpbtrf(uplo, n, kd, ab, 0, ldab, info);
    }

    public abstract void dpbtrf(String var1, int var2, int var3, double[] var4, int var5, int var6, intW var7);

    public final void dpbtrs(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info) {
        this.dpbtrs(uplo, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
    }

    public abstract void dpbtrs(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dpocon(String uplo, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
        this.dpocon(uplo, n, a, 0, lda, anorm, rcond, work, 0, iwork, 0, info);
    }

    public abstract void dpocon(String var1, int var2, double[] var3, int var4, int var5, double var6, doubleW var8, double[] var9, int var10, int[] var11, int var12, intW var13);

    public final void dposv(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info) {
        this.dposv(uplo, n, nrhs, a, 0, lda, b, 0, ldb, info);
    }

    public abstract void dposv(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, intW var10);

    public final void dpotrf(String uplo, int n, double[] a, int lda, intW info) {
        this.dpotrf(uplo, n, a, 0, lda, info);
    }

    public abstract void dpotrf(String var1, int var2, double[] var3, int var4, int var5, intW var6);

    public final void dpotrs(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info) {
        this.dpotrs(uplo, n, nrhs, a, 0, lda, b, 0, ldb, info);
    }

    public abstract void dpotrs(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, intW var10);

    public final void dppcon(String uplo, int n, double[] ap, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
        this.dppcon(uplo, n, ap, 0, anorm, rcond, work, 0, iwork, 0, info);
    }

    public abstract void dppcon(String var1, int var2, double[] var3, int var4, double var5, doubleW var7, double[] var8, int var9, int[] var10, int var11, intW var12);

    public final void dppsv(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info) {
        this.dppsv(uplo, n, nrhs, ap, 0, b, 0, ldb, info);
    }

    public abstract void dppsv(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, intW var9);

    public final void dpptrf(String uplo, int n, double[] ap, intW info) {
        this.dpptrf(uplo, n, ap, 0, info);
    }

    public abstract void dpptrf(String var1, int var2, double[] var3, int var4, intW var5);

    public final void dpptrs(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info) {
        this.dpptrs(uplo, n, nrhs, ap, 0, b, 0, ldb, info);
    }

    public abstract void dpptrs(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, intW var9);

    public final void dptsv(int n, int nrhs, double[] d, double[] e, double[] b, int ldb, intW info) {
        this.dptsv(n, nrhs, d, 0, e, 0, b, 0, ldb, info);
    }

    public abstract void dptsv(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, intW var10);

    public final void dsbevd(String jobz, String uplo, int n, int kd, double[] ab, int ldab, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
        this.dsbevd(jobz, uplo, n, kd, ab, 0, ldab, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
    }

    public abstract void dsbevd(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, int[] var16, int var17, int var18, intW var19);

    public final void dspevd(String jobz, String uplo, int n, double[] ap, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
        this.dspevd(jobz, uplo, n, ap, 0, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
    }

    public abstract void dspevd(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, int[] var14, int var15, int var16, intW var17);

    public final void dspsv(String uplo, int n, int nrhs, double[] ap, int[] ipiv, double[] b, int ldb, intW info) {
        this.dspsv(uplo, n, nrhs, ap, 0, ipiv, 0, b, 0, ldb, info);
    }

    public abstract void dspsv(String var1, int var2, int var3, double[] var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dstevr(String jobz, String range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
        this.dstevr(jobz, range, n, d, 0, e, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
    }

    public abstract void dstevr(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, intW var30);

    public final void dsyevr(String jobz, String range, String uplo, int n, double[] a, int lda, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
        this.dsyevr(jobz, range, uplo, n, a, 0, lda, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
    }

    public abstract void dsyevr(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, intW var30);

    public final void dsygvd(int itype, String jobz, String uplo, int n, double[] a, int lda, double[] b, int ldb, double[] w, double[] work, int lwork, int[] iwork, int liwork, intW info) {
        this.dsygvd(itype, jobz, uplo, n, a, 0, lda, b, 0, ldb, w, 0, work, 0, lwork, iwork, 0, liwork, info);
    }

    public abstract void dsygvd(int var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, int[] var16, int var17, int var18, intW var19);

    public final void dsysv(String uplo, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, double[] work, int lwork, intW info) {
        this.dsysv(uplo, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, work, 0, lwork, info);
    }

    public abstract void dsysv(String var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, intW var15);

    public final void dtbtrs(String uplo, String trans, String diag, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info) {
        this.dtbtrs(uplo, trans, diag, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
    }

    public abstract void dtbtrs(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, intW var13);

    public final void dtptrs(String uplo, String trans, String diag, int n, int nrhs, double[] ap, double[] b, int ldb, intW info) {
        this.dtptrs(uplo, trans, diag, n, nrhs, ap, 0, b, 0, ldb, info);
    }

    public abstract void dtptrs(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    public final void dtrtrs(String uplo, String trans, String diag, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info) {
        this.dtrtrs(uplo, trans, diag, n, nrhs, a, 0, lda, b, 0, ldb, info);
    }

    public abstract void dtrtrs(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, intW var12);

    public final void sgeev(String jobvl, String jobvr, int n, float[] a, int lda, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr, float[] work, int lwork, intW info) {
        this.sgeev(jobvl, jobvr, n, a, 0, lda, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
    }

    public abstract void sgeev(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, intW var20);

    public final void sgels(String trans, int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] work, int lwork, intW info) {
        this.sgels(trans, m, n, nrhs, a, 0, lda, b, 0, ldb, work, 0, lwork, info);
    }

    public abstract void sgels(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, intW var14);

    public final void sgesdd(String jobz, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt, float[] work, int lwork, int[] iwork, intW info) {
        this.sgesdd(jobz, m, n, a, 0, lda, s, 0, u, 0, ldu, vt, 0, ldvt, work, 0, lwork, iwork, 0, info);
    }

    public abstract void sgesdd(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, int[] var18, int var19, intW var20);

    public final void sgesv(int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, intW info) {
        this.sgesv(n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
    }

    public abstract void sgesv(int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    public final void sgeqrf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
        this.sgeqrf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void sgeqrf(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    public final void sorgqr(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
        this.sorgqr(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
    }

    public abstract void sorgqr(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    public final void sgetrf(int m, int n, float[] a, int lda, int[] ipiv, intW info) {
        this.sgetrf(m, n, a, 0, lda, ipiv, 0, info);
    }

    public abstract void sgetrf(int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    public abstract int cgeev(String var1, String var2, int var3, float[] var4, int var5, float[] var6, float[] var7, int var8, float[] var9, int var10);

    public abstract int zgeev(String var1, String var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, double[] var9, int var10);

    public abstract int cgesdd(String var1, int var2, int var3, float[] var4, int var5, float[] var6, float[] var7, int var8, float[] var9, int var10);

    public abstract int zgesdd(String var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, double[] var9, int var10);

    public abstract int cgels(String var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8);

    public abstract int zgels(String var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8);

    public abstract int cgesv(int var1, int var2, float[] var3, int var4, int[] var5, float[] var6, int var7);

    public abstract int zgesv(int var1, int var2, double[] var3, int var4, int[] var5, double[] var6, int var7);

    public abstract int cgeqrf(int var1, int var2, float[] var3, int var4, float[] var5);

    public abstract int zgeqrf(int var1, int var2, double[] var3, int var4, double[] var5);

    public abstract int cgetrf(int var1, int var2, float[] var3, int var4, int[] var5);

    public abstract int zgetrf(int var1, int var2, double[] var3, int var4, int[] var5);

    public abstract int cungqr(int var1, int var2, int var3, float[] var4, int var5, float[] var6);

    public abstract int zungqr(int var1, int var2, int var3, double[] var4, int var5, double[] var6);

    protected Lapack() {
    }

    static {
        netlib = new LapackJ();
        mkl = Lapack.loadNative();
    }
}

