/*
 * Decompiled with CFR 0.152.
 */
package net.dedekind.blas;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.LinkedHashSet;

final class NativeLoader {
    private static final String NATIVE_NAME = "dedekind-mkl";
    private static final String OS;
    private static final String LIB_PATH;
    private static final String TMP_DIR;
    private static final String PROP_DIR;
    private static final String ENV_DIR;
    private static final LinkedHashSet<String> ALL_DIRS;
    private static boolean loaded;
    private static String location;

    NativeLoader() {
    }

    static synchronized boolean isLoaded() {
        return loaded;
    }

    static synchronized String getLocation() {
        return location;
    }

    static synchronized void load() {
        if (loaded) {
            return;
        }
        String libName = NativeLoader.getLibraryFileName();
        for (String dir : ALL_DIRS) {
            File file = new File(dir, libName).getAbsoluteFile();
            if (!file.exists() || !file.isFile() || !NativeLoader.load(file)) continue;
            NativeLoader.set(file);
            return;
        }
        try {
            File file = NativeLoader.extract(libName);
            if (file != null && file.exists() && file.isFile() && NativeLoader.load(file)) {
                NativeLoader.set(file);
                return;
            }
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        throw new ExceptionInInitializerError("Unable to load " + libName + " from " + ALL_DIRS.toString());
    }

    private static boolean load(File file) {
        try {
            System.load(file.getAbsolutePath());
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (TMP_DIR != null && file.getAbsolutePath().startsWith(TMP_DIR)) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extract(String fileName) throws IOException {
        String filePath = "/" + fileName;
        URL url = NativeLoader.class.getResource(filePath);
        if (url == null) {
            return null;
        }
        File file = NativeLoader.createFile(fileName);
        InputStream in = null;
        AbstractInterruptibleChannel dest = null;
        FileOutputStream fos = null;
        try {
            in = NativeLoader.class.getResourceAsStream(filePath);
            fos = new FileOutputStream(file);
            dest = fos.getChannel();
            ReadableByteChannel src = Channels.newChannel(in);
            ((FileChannel)dest).transferFrom(src, 0L, Long.MAX_VALUE);
            File file2 = file;
            return file2;
        }
        catch (IOException | SecurityException e) {
            File file3 = null;
            return file3;
        }
        finally {
            try {
                if (dest != null) {
                    dest.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static File createFile(String libName) throws IOException {
        String dir = null;
        if (!ALL_DIRS.isEmpty()) {
            dir = (String)ALL_DIRS.iterator().next();
        }
        if (dir != null) {
            File file = new File(dir, libName);
            if (file.exists() && !file.isFile()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not a file");
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            return file;
        }
        return null;
    }

    private static void set(File file) {
        loaded = true;
        location = file.getAbsolutePath();
    }

    private static String checkDirectory(String dirPath) {
        File dir;
        if (dirPath != null && !dirPath.isEmpty() && (dir = new File(dirPath).getAbsoluteFile()).exists() && dir.isDirectory()) {
            return dir.getAbsolutePath();
        }
        return null;
    }

    private static String getLibraryFileName() {
        return NativeLoader.appendLibOsExtension(NativeLoader.prependLibOsPrefix(NATIVE_NAME));
    }

    private static String prependLibOsPrefix(String libFileName) {
        if (NativeLoader.isLinux()) {
            return "lib" + libFileName;
        }
        return libFileName;
    }

    private static String appendLibOsExtension(String libFileName) {
        if (NativeLoader.isLinux()) {
            return libFileName + ".so";
        }
        if (NativeLoader.isWindows()) {
            return libFileName + ".dll";
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isWindows() {
        return OS.contains("windows");
    }

    private static boolean isLinux() {
        return OS.contains("linux");
    }

    static {
        String[] javaLibPath;
        String dir;
        OS = System.getProperty("os.name", "").toLowerCase();
        LIB_PATH = System.getProperty("java.library.path", "");
        TMP_DIR = System.getProperty("java.io.tmpdir", "");
        PROP_DIR = System.getProperty("dedekind.sharedlib.dir", "");
        ENV_DIR = System.getenv("DEDEKIND_SHAREDLIB_DIR");
        loaded = false;
        location = null;
        LinkedHashSet<String> directories = new LinkedHashSet<String>();
        if (PROP_DIR != null && !PROP_DIR.isEmpty() && (dir = NativeLoader.checkDirectory(PROP_DIR)) != null) {
            directories.add(dir);
        }
        if (ENV_DIR != null && !ENV_DIR.isEmpty() && (dir = NativeLoader.checkDirectory(ENV_DIR)) != null) {
            directories.add(dir);
        }
        if (TMP_DIR != null && !TMP_DIR.isEmpty() && (dir = NativeLoader.checkDirectory(TMP_DIR)) != null) {
            directories.add(dir);
        }
        if (LIB_PATH != null && !LIB_PATH.isEmpty() && (javaLibPath = LIB_PATH.split(File.pathSeparator)) != null && javaLibPath.length > 0) {
            for (int i = 0; i < javaLibPath.length; ++i) {
                String dir2 = NativeLoader.checkDirectory(javaLibPath[i]);
                if (dir2 == null) continue;
                directories.add(dir2);
            }
        }
        ALL_DIRS = directories;
    }
}

