/*
 * Decompiled with CFR 0.152.
 */
package net.dedekind.blas;

import java.util.Objects;
import net.dedekind.Order;
import net.dedekind.blas.Blas;
import net.dedekind.blas.Diag;
import net.dedekind.blas.Side;
import net.dedekind.blas.Trans;
import net.dedekind.blas.Uplo;

public class BlasN
extends Blas {
    private static final boolean USE_CRITICAL = true;

    @Override
    public final void dgbmv(String trans, int m, int n, int kl, int ku, double alpha, double[] a, int aOffset, int lda, double[] x, int xOffset, int incx, double beta, double[] y, int yOffset, int incy) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        BlasN.dgbmv_n(Order.COL.code(), Trans.of(trans).code(), m, n, kl, ku, alpha, a, aOffset, lda, x, xOffset, incx, beta, y, yOffset, incy, true);
    }

    @Override
    public final void dgemm(String transa, String transb, int m, int n, int k, double alpha, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, double beta, double[] c, int cOffset, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        BlasN.dgemm_n(Order.COL.code(), Trans.of(transa).code(), Trans.of(transb).code(), m, n, k, alpha, a, aOffset, lda, b, bOffset, ldb, beta, c, cOffset, ldc, true);
    }

    @Override
    public void dgemm_multi(String transa, String transb, int m, int n, int k, double alpha, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, double beta, double[] c, int cOffset, int ldc, int howMany, int incAOff, int incBOff, int incCOff) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        BlasN.dgemm_multi_n(Order.COL.code(), Trans.of(transa).code(), Trans.of(transb).code(), m, n, k, alpha, a, aOffset, lda, b, bOffset, ldb, beta, c, cOffset, ldc, true, howMany, incAOff, incBOff, incCOff);
    }

    @Override
    public final void dgemv(String trans, int m, int n, double alpha, double[] a, int aOffset, int lda, double[] x, int xOffset, int incx, double beta, double[] y, int yOffset, int incy) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        BlasN.dgemv_n(Order.COL.code(), Trans.of(trans).code(), m, n, alpha, a, aOffset, lda, x, xOffset, incx, beta, y, yOffset, incy, true);
    }

    @Override
    public final void dger(int m, int n, double alpha, double[] x, int xOffset, int incx, double[] y, int yOffset, int incy, double[] a, int aOffset, int lda) {
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        Objects.requireNonNull(a, "a");
        BlasN.dger_n(Order.COL.code(), m, n, alpha, x, xOffset, incx, y, yOffset, incy, a, aOffset, lda, true);
    }

    @Override
    public final void dsbmv(String uplo, int n, int k, double alpha, double[] a, int aOffset, int lda, double[] x, int xOffset, int incx, double beta, double[] y, int yOffset, int incy) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        BlasN.dsbmv_n(Order.COL.code(), Uplo.of(uplo).code(), n, k, alpha, a, aOffset, lda, x, xOffset, incx, beta, y, yOffset, incy, true);
    }

    @Override
    public final void dspmv(String uplo, int n, double alpha, double[] ap, int apOffset, double[] x, int xOffset, int incx, double beta, double[] y, int yOffset, int incy) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        BlasN.dspmv_n(Order.COL.code(), Uplo.of(uplo).code(), n, alpha, ap, apOffset, x, xOffset, incx, beta, y, yOffset, incy, true);
    }

    @Override
    public final void dspr(String uplo, int n, double alpha, double[] x, int xOffset, int incx, double[] ap, int apOffset) {
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(ap, "ap");
        BlasN.dspr_n(Order.COL.code(), Uplo.of(uplo).code(), n, alpha, x, xOffset, incx, ap, apOffset, true);
    }

    @Override
    public final void dspr2(String uplo, int n, double alpha, double[] x, int xOffset, int incx, double[] y, int yOffset, int incy, double[] ap, int apOffset) {
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        Objects.requireNonNull(ap, "ap");
        BlasN.dspr2_n(Order.COL.code(), Uplo.of(uplo).code(), n, alpha, x, xOffset, incx, y, yOffset, incy, ap, apOffset, true);
    }

    @Override
    public final void dsymm(String side, String uplo, int m, int n, double alpha, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, double beta, double[] c, int cOffset, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        BlasN.dsymm_n(Order.COL.code(), Side.of(side).code(), Uplo.of(uplo).code(), m, n, alpha, a, aOffset, lda, b, bOffset, ldb, beta, c, cOffset, ldc, true);
    }

    @Override
    public final void dsymv(String uplo, int n, double alpha, double[] a, int aOffset, int lda, double[] x, int xOffset, int incx, double beta, double[] y, int yOffset, int incy) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        BlasN.dsymv_n(Order.COL.code(), Uplo.of(uplo).code(), n, alpha, a, aOffset, lda, x, xOffset, incx, beta, y, yOffset, incy, true);
    }

    @Override
    public final void dsyr(String uplo, int n, double alpha, double[] x, int xOffset, int incx, double[] a, int aOffset, int lda) {
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(a, "a");
        BlasN.dsyr_n(Order.COL.code(), Uplo.of(uplo).code(), n, alpha, x, xOffset, incx, a, aOffset, lda, true);
    }

    @Override
    public final void dsyr2(String uplo, int n, double alpha, double[] x, int xOffset, int incx, double[] y, int yOffset, int incy, double[] a, int aOffset, int lda) {
        Objects.requireNonNull(x, "x");
        Objects.requireNonNull(y, "y");
        Objects.requireNonNull(a, "a");
        BlasN.dsyr2_n(Order.COL.code(), Uplo.of(uplo).code(), n, alpha, x, xOffset, incx, y, yOffset, incy, a, aOffset, lda, true);
    }

    @Override
    public final void dsyr2k(String uplo, String trans, int n, int k, double alpha, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb, double beta, double[] c, int cOffset, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        BlasN.dsyr2k_n(Order.COL.code(), Uplo.of(uplo).code(), Trans.of(trans).code(), n, k, alpha, a, aOffset, lda, b, bOffset, ldb, beta, c, cOffset, ldc, true);
    }

    @Override
    public final void dsyrk(String uplo, String trans, int n, int k, double alpha, double[] a, int aOffset, int lda, double beta, double[] c, int cOffset, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(c, "c");
        BlasN.dsyrk_n(Order.COL.code(), Uplo.of(uplo).code(), Trans.of(trans).code(), n, k, alpha, a, aOffset, lda, beta, c, cOffset, ldc, true);
    }

    @Override
    public final void dtbmv(String uplo, String trans, String diag, int n, int k, double[] a, int aOffset, int lda, double[] x, int xOffset, int incx) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(x, "x");
        BlasN.dtbmv_n(Order.COL.code(), Uplo.of(uplo).code(), Trans.of(trans).code(), Diag.of(diag).code(), n, k, a, aOffset, lda, x, xOffset, incx, true);
    }

    @Override
    public final void dtpmv(String uplo, String trans, String diag, int n, double[] ap, int apOffset, double[] x, int xOffset, int incx) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(x, "x");
        BlasN.dtpmv_n(Order.COL.code(), Uplo.of(uplo).code(), Trans.of(trans).code(), Diag.of(diag).code(), n, ap, apOffset, x, xOffset, incx, true);
    }

    @Override
    public final void dtrmm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int aOffset, int lda, double[] b, int bOffset, int ldb) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        BlasN.dtrmm_n(Order.COL.code(), Side.of(side).code(), Uplo.of(uplo).code(), Trans.of(transa).code(), Diag.of(diag).code(), m, n, alpha, a, aOffset, lda, b, bOffset, ldb, true);
    }

    @Override
    public final void dtrmv(String uplo, String trans, String diag, int n, double[] a, int aOffset, int lda, double[] x, int xOffset, int incx) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(x, "x");
        BlasN.dtrmv_n(Order.COL.code(), Uplo.of(uplo).code(), Trans.of(trans).code(), Diag.of(diag).code(), n, a, aOffset, lda, x, xOffset, incx, true);
    }

    @Override
    public final void dtbsv(String uplo, String trans, String diag, int n, int k, double[] a, int aOffset, int lda, double[] x, int xOffset, int incx) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(x, "x");
        BlasN.dtbsv_n(Order.COL.code(), Uplo.of(uplo).code(), Trans.of(trans).code(), Diag.of(diag).code(), n, k, a, aOffset, lda, x, xOffset, incx, true);
    }

    @Override
    public final void dtpsv(String uplo, String trans, String diag, int n, double[] ap, int apOffset, double[] x, int xOffset, int incx) {
        Objects.requireNonNull(ap, "ap");
        Objects.requireNonNull(x, "x");
        BlasN.dtpsv_n(Order.COL.code(), Uplo.of(uplo).code(), Trans.of(trans).code(), Diag.of(diag).code(), n, ap, apOffset, x, xOffset, incx, true);
    }

    @Override
    public final void daxpy(int n, double da, double[] dx, int dxOffset, int incx, double[] dy, int dyOffset, int incy) {
        Objects.requireNonNull(dx, "dx");
        Objects.requireNonNull(dy, "dy");
        BlasN.daxpy_n(n, da, dx, dxOffset, incx, dy, dyOffset, incy, true);
    }

    @Override
    public final void dcopy(int n, double[] dx, int dxOffset, int incx, double[] dy, int dyOffset, int incy) {
        Objects.requireNonNull(dx, "dx");
        Objects.requireNonNull(dy, "dy");
        BlasN.dcopy_n(n, dx, dxOffset, incx, dy, dyOffset, incy, true);
    }

    @Override
    public final void dscal(int n, double da, double[] dx, int dxOffset, int incx) {
        Objects.requireNonNull(Double.valueOf(da), "da");
        Objects.requireNonNull(dx, "dx");
        BlasN.dscal_n(n, da, dx, dxOffset, incx, true);
    }

    @Override
    public final void dswap(int n, double[] dx, int dxOffset, int incx, double[] dy, int dyOffset, int incy) {
        Objects.requireNonNull(dx, "dx");
        Objects.requireNonNull(dy, "dy");
        BlasN.dswap_n(n, dx, dxOffset, incx, dy, dyOffset, incy, true);
    }

    @Override
    public final double ddot(int n, double[] dx, int dxOffset, int incx, double[] dy, int dyOffset, int incy) {
        Objects.requireNonNull(dx, "dx");
        Objects.requireNonNull(dy, "dy");
        return BlasN.ddot_n(n, dx, dxOffset, incx, dy, dyOffset, incy, true);
    }

    @Override
    public final void drot(int n, double[] dx, int dxOffset, int incx, double[] dy, int dyOffset, int incy, double c, double s) {
        Objects.requireNonNull(dx, "dx");
        Objects.requireNonNull(dy, "dy");
        BlasN.drot_n(n, dx, dxOffset, incx, dy, dyOffset, incy, c, s, true);
    }

    @Override
    public final int idamax(int n, double[] dx, int dxOffset, int incx) {
        Objects.requireNonNull(dx, "dx");
        return BlasN.idamax_n(n, dx, dxOffset, incx, true);
    }

    @Override
    public final void sgemm(String transa, String transb, int m, int n, int k, float alpha, float[] a, int aOffset, int lda, float[] b, int bOffset, int ldb, float beta, float[] c, int cOffset, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        BlasN.sgemm_n(Order.COL.code(), Trans.of(transa).code(), Trans.of(transb).code(), m, n, k, alpha, a, aOffset, lda, b, bOffset, ldb, beta, c, cOffset, ldc, true);
    }

    @Override
    public void sgemm_multi(String transa, String transb, int m, int n, int k, float alpha, float[] a, int aOffset, int lda, float[] b, int bOffset, int ldb, float beta, float[] c, int cOffset, int ldc, int howMany, int incAOff, int incBOff, int incCOff) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        BlasN.sgemm_multi_n(Order.COL.code(), Trans.of(transa).code(), Trans.of(transb).code(), m, n, k, alpha, a, aOffset, lda, b, bOffset, ldb, beta, c, cOffset, ldc, true, howMany, incAOff, incBOff, incCOff);
    }

    @Override
    public final void cgemm(Trans transa, Trans transb, int m, int n, int k, float alphar, float alphai, float[] a, int lda, float[] b, int ldb, float betar, float betai, float[] c, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        BlasN.cgemm_n(Order.COL.code(), transa.code(), transb.code(), m, n, k, alphar, alphai, a, lda, b, ldb, betar, betai, c, ldc, true);
    }

    @Override
    public final void zgemm(Trans transa, Trans transb, int m, int n, int k, double alphar, double alphai, double[] a, int lda, double[] b, int ldb, double betar, double betai, double[] c, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        BlasN.zgemm_n(Order.COL.code(), transa.code(), transb.code(), m, n, k, alphar, alphai, a, lda, b, ldb, betar, betai, c, ldc, true);
    }

    private static native void dgbmv_n(int var0, int var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18, boolean var19);

    private static native void dgemm_n(int var0, int var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18, boolean var19);

    private static native void dgemm_multi_n(int var0, int var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18, boolean var19, int var20, int var21, int var22, int var23);

    private static native void dgemv_n(int var0, int var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16, boolean var17);

    private static native void dger_n(int var0, int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, boolean var14);

    private static native void dsbmv_n(int var0, int var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16, boolean var17);

    private static native void dspmv_n(int var0, int var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14, boolean var15);

    private static native void dspr_n(int var0, int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, boolean var10);

    private static native void dspr2_n(int var0, int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, boolean var13);

    private static native void dsymm_n(int var0, int var1, int var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17, boolean var18);

    private static native void dsymv_n(int var0, int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double var11, double[] var13, int var14, int var15, boolean var16);

    private static native void dsyr_n(int var0, int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native void dsyr2_n(int var0, int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, boolean var14);

    private static native void dsyr2k_n(int var0, int var1, int var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17, boolean var18);

    private static native void dsyrk_n(int var0, int var1, int var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14, boolean var15);

    private static native void dtbmv_n(int var0, int var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native void dtpmv_n(int var0, int var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, boolean var10);

    private static native void dtrmm_n(int var0, int var1, int var2, int var3, int var4, int var5, int var6, double var7, double[] var9, int var10, int var11, double[] var12, int var13, int var14, boolean var15);

    private static native void dtrmv_n(int var0, int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, boolean var11);

    private static native void dtbsv_n(int var0, int var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, boolean var12);

    private static native void dtpsv_n(int var0, int var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, boolean var10);

    private static native void daxpy_n(int var0, double var1, double[] var3, int var4, int var5, double[] var6, int var7, int var8, boolean var9);

    private static native void dcopy_n(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6, boolean var7);

    private static native void dscal_n(int var0, double var1, double[] var3, int var4, int var5, boolean var6);

    private static native void dswap_n(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6, boolean var7);

    private static native double ddot_n(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6, boolean var7);

    private static native void drot_n(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6, double var7, double var9, boolean var11);

    private static native int idamax_n(int var0, double[] var1, int var2, int var3, boolean var4);

    static native void redirect_xerbla_n();

    private static native void sgemm_n(int var0, int var1, int var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16, boolean var17);

    private static native void sgemm_multi_n(int var0, int var1, int var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16, boolean var17, int var18, int var19, int var20, int var21);

    private static native void cgemm_n(int var0, int var1, int var2, int var3, int var4, int var5, float var6, float var7, float[] var8, int var9, float[] var10, int var11, float var12, float var13, float[] var14, int var15, boolean var16);

    private static native void zgemm_n(int var0, int var1, int var2, int var3, int var4, int var5, double var6, double var8, double[] var10, int var11, double[] var12, int var13, double var14, double var16, double[] var18, int var19, boolean var20);

    protected BlasN() {
    }
}

