/*
 * Decompiled with CFR 0.152.
 */
package net.dedekind.blas;

import java.util.Objects;
import net.dedekind.Order;
import net.dedekind.blas.Blas;
import net.dedekind.blas.Trans;
import net.frobenius.TTrans;

public class BlasExt {
    private static final byte ORDERING = 67;
    private static final boolean USE_CRITICAL = true;
    private static final BlasExt mkl;

    public static BlasExt getInstance() {
        return mkl;
    }

    public final void cgemm3m(Trans transa, Trans transb, int m, int n, int k, float alphar, float alphai, float[] a, int lda, float[] b, int ldb, float betar, float betai, float[] c, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        BlasExt.checkStrictlyPositive(m, "m");
        BlasExt.checkStrictlyPositive(n, "n");
        BlasExt.checkStrictlyPositive(k, "k");
        BlasExt.cgemm3m_n(Order.COL.code(), transa.code(), transb.code(), m, n, k, alphar, alphai, a, lda, b, ldb, betar, betai, c, ldc, true);
    }

    public final void zgemm3m(Trans transa, Trans transb, int m, int n, int k, double alphar, double alphai, double[] a, int lda, double[] b, int ldb, double betar, double betai, double[] c, int ldc) {
        Objects.requireNonNull(a, "a");
        Objects.requireNonNull(b, "b");
        Objects.requireNonNull(c, "c");
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        BlasExt.checkStrictlyPositive(m, "m");
        BlasExt.checkStrictlyPositive(n, "n");
        BlasExt.checkStrictlyPositive(k, "k");
        BlasExt.zgemm3m_n(Order.COL.code(), transa.code(), transb.code(), m, n, k, alphar, alphai, a, lda, b, ldb, betar, betai, c, ldc, true);
    }

    public final void simatcopy(TTrans trans, int rows, int cols, float alpha, float[] AB, int lda, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(AB, "AB");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.simatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alpha, AB, lda, ldb, true);
    }

    public final void dimatcopy(TTrans trans, int rows, int cols, double alpha, double[] AB, int lda, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(AB, "AB");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.dimatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alpha, AB, lda, ldb, true);
    }

    public final void cimatcopy(TTrans trans, int rows, int cols, float alphar, float alphai, float[] AB, int lda, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(AB, "AB");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.cimatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alphar, alphai, AB, lda, ldb, true);
    }

    public final void zimatcopy(TTrans trans, int rows, int cols, double alphar, double alphai, double[] AB, int lda, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(AB, "AB");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.zimatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alphar, alphai, AB, lda, ldb, true);
    }

    public final void somatcopy(TTrans trans, int rows, int cols, float alpha, float[] A, int lda, float[] B, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.somatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alpha, A, lda, B, ldb, true);
    }

    public final void domatcopy(TTrans trans, int rows, int cols, double alpha, double[] A, int lda, double[] B, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.domatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alpha, A, lda, B, ldb, true);
    }

    public final void comatcopy(TTrans trans, int rows, int cols, float alphar, float alphai, float[] A, int lda, float[] B, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.comatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alphar, alphai, A, lda, B, ldb, true);
    }

    public final void zomatcopy(TTrans trans, int rows, int cols, double alphar, double alphai, double[] A, int lda, double[] B, int ldb) {
        Objects.requireNonNull(trans, "trans");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        BlasExt.checkStrictlyPositive(rows, "rows");
        BlasExt.checkStrictlyPositive(cols, "cols");
        BlasExt.zomatcopy_n((byte)67, BlasExt.trans(trans), rows, cols, alphar, alphai, A, lda, B, ldb, true);
    }

    public final void somatadd(TTrans transa, TTrans transb, int m, int n, float alpha, float[] A, int lda, float beta, float[] B, int ldb, float[] C, int ldc) {
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        Objects.requireNonNull(C, "C");
        BlasExt.checkStrictlyPositive(m, "m");
        BlasExt.checkStrictlyPositive(n, "n");
        BlasExt.somatadd_n((byte)67, BlasExt.trans(transa), BlasExt.trans(transb), m, n, alpha, A, lda, beta, B, ldb, C, ldc, true);
    }

    public final void domatadd(TTrans transa, TTrans transb, int m, int n, double alpha, double[] A, int lda, double beta, double[] B, int ldb, double[] C, int ldc) {
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        Objects.requireNonNull(C, "C");
        BlasExt.checkStrictlyPositive(m, "m");
        BlasExt.checkStrictlyPositive(n, "n");
        BlasExt.domatadd_n((byte)67, BlasExt.trans(transa), BlasExt.trans(transb), m, n, alpha, A, lda, beta, B, ldb, C, ldc, true);
    }

    public final void comatadd(TTrans transa, TTrans transb, int m, int n, float alphar, float alphai, float[] A, int lda, float betar, float betai, float[] B, int ldb, float[] C, int ldc) {
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        Objects.requireNonNull(C, "C");
        BlasExt.checkStrictlyPositive(m, "m");
        BlasExt.checkStrictlyPositive(n, "n");
        BlasExt.comatadd_n((byte)67, BlasExt.trans(transa), BlasExt.trans(transb), m, n, alphar, alphai, A, lda, betar, betai, B, ldb, C, ldc, true);
    }

    public final void zomatadd(TTrans transa, TTrans transb, int m, int n, double alphar, double alphai, double[] A, int lda, double betar, double betai, double[] B, int ldb, double[] C, int ldc) {
        Objects.requireNonNull(transa, "transa");
        Objects.requireNonNull(transb, "transb");
        Objects.requireNonNull(A, "A");
        Objects.requireNonNull(B, "B");
        Objects.requireNonNull(C, "C");
        BlasExt.checkStrictlyPositive(m, "m");
        BlasExt.checkStrictlyPositive(n, "n");
        BlasExt.zomatadd_n((byte)67, BlasExt.trans(transa), BlasExt.trans(transb), m, n, alphar, alphai, A, lda, betar, betai, B, ldb, C, ldc, true);
    }

    private static native void cgemm3m_n(int var0, int var1, int var2, int var3, int var4, int var5, float var6, float var7, float[] var8, int var9, float[] var10, int var11, float var12, float var13, float[] var14, int var15, boolean var16);

    private static native void zgemm3m_n(int var0, int var1, int var2, int var3, int var4, int var5, double var6, double var8, double[] var10, int var11, double[] var12, int var13, double var14, double var16, double[] var18, int var19, boolean var20);

    private static native void simatcopy_n(byte var0, byte var1, int var2, int var3, float var4, float[] var5, int var6, int var7, boolean var8);

    private static native void dimatcopy_n(byte var0, byte var1, int var2, int var3, double var4, double[] var6, int var7, int var8, boolean var9);

    private static native void cimatcopy_n(byte var0, byte var1, int var2, int var3, float var4, float var5, float[] var6, int var7, int var8, boolean var9);

    private static native void zimatcopy_n(byte var0, byte var1, int var2, int var3, double var4, double var6, double[] var8, int var9, int var10, boolean var11);

    private static native void somatcopy_n(byte var0, byte var1, int var2, int var3, float var4, float[] var5, int var6, float[] var7, int var8, boolean var9);

    private static native void domatcopy_n(byte var0, byte var1, int var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, boolean var10);

    private static native void comatcopy_n(byte var0, byte var1, int var2, int var3, float var4, float var5, float[] var6, int var7, float[] var8, int var9, boolean var10);

    private static native void zomatcopy_n(byte var0, byte var1, int var2, int var3, double var4, double var6, double[] var8, int var9, double[] var10, int var11, boolean var12);

    private static native void somatadd_n(byte var0, byte var1, byte var2, int var3, int var4, float var5, float[] var6, int var7, float var8, float[] var9, int var10, float[] var11, int var12, boolean var13);

    private static native void domatadd_n(byte var0, byte var1, byte var2, int var3, int var4, double var5, double[] var7, int var8, double var9, double[] var11, int var12, double[] var13, int var14, boolean var15);

    private static native void comatadd_n(byte var0, byte var1, byte var2, int var3, int var4, float var5, float var6, float[] var7, int var8, float var9, float var10, float[] var11, int var12, float[] var13, int var14, boolean var15);

    private static native void zomatadd_n(byte var0, byte var1, byte var2, int var3, int var4, double var5, double var7, double[] var9, int var10, double var11, double var13, double[] var15, int var16, double[] var17, int var18, boolean var19);

    private static byte trans(TTrans trans) {
        return (byte)Character.toUpperCase(trans.val().charAt(0));
    }

    private static void checkStrictlyPositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException("Parameter " + name + " must be strictly positive (value = " + value + ")");
        }
    }

    protected BlasExt() {
    }

    static {
        Blas.getInstance(true);
        mkl = new BlasExt();
    }
}

