/*
 * Decompiled with CFR 0.152.
 */
package net.dedekind.blas;

import net.dedekind.blas.BlasJ;
import net.dedekind.blas.BlasN;
import net.dedekind.blas.NativeLoader;
import net.dedekind.blas.Trans;

public abstract class Blas {
    private static final Blas mkl;
    private static final Blas netlib;

    private static Blas loadNative() {
        try {
            NativeLoader.load();
            BlasN.redirect_xerbla_n();
            return new BlasN();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Blas getInstance() {
        Blas impl = mkl;
        if (impl != null) {
            return impl;
        }
        return netlib;
    }

    public static Blas getInstance(boolean useMKL) {
        if (!useMKL) {
            return netlib;
        }
        Blas impl = mkl;
        if (impl != null) {
            return impl;
        }
        throw new RuntimeException("MKL not loaded");
    }

    public final void dgbmv(String trans, int m, int n, int kl, int ku, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dgbmv(trans, m, n, kl, ku, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public abstract void dgbmv(String var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18);

    public final void dgemm(String transa, String transb, int m, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int ldc) {
        this.dgemm(transa, transb, m, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    public abstract void dgemm(String var1, String var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18);

    public abstract void dgemm_multi(String var1, String var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18, int var19, int var20, int var21, int var22);

    public final void dgemv(String trans, int m, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dgemv(trans, m, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public abstract void dgemv(String var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16);

    public final void dger(int m, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda) {
        this.dger(m, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    public abstract void dger(int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13);

    public final void dsbmv(String uplo, int n, int k, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dsbmv(uplo, n, k, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public abstract void dsbmv(String var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16);

    public final void dspmv(String uplo, int n, double alpha, double[] ap, double[] x, int incx, double beta, double[] y, int incy) {
        this.dspmv(uplo, n, alpha, ap, 0, x, 0, incx, beta, y, 0, incy);
    }

    public abstract void dspmv(String var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14);

    public final void dspr(String uplo, int n, double alpha, double[] x, int incx, double[] ap) {
        this.dspr(uplo, n, alpha, x, 0, incx, ap, 0);
    }

    public abstract void dspr(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9);

    public final void dspr2(String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] ap) {
        this.dspr2(uplo, n, alpha, x, 0, incx, y, 0, incy, ap, 0);
    }

    public abstract void dspr2(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12);

    public final void dsymm(String side, String uplo, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int ldc) {
        this.dsymm(side, uplo, m, n, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    public abstract void dsymm(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17);

    public final void dsymv(String uplo, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        this.dsymv(uplo, n, alpha, a, 0, lda, x, 0, incx, beta, y, 0, incy);
    }

    public abstract void dsymv(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double var11, double[] var13, int var14, int var15);

    public final void dsyr(String uplo, int n, double alpha, double[] x, int incx, double[] a, int lda) {
        this.dsyr(uplo, n, alpha, x, 0, incx, a, 0, lda);
    }

    public abstract void dsyr(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    public final void dsyr2(String uplo, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] a, int lda) {
        this.dsyr2(uplo, n, alpha, x, 0, incx, y, 0, incy, a, 0, lda);
    }

    public abstract void dsyr2(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13);

    public final void dsyr2k(String uplo, String trans, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int ldc) {
        this.dsyr2k(uplo, trans, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    public abstract void dsyr2k(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17);

    public final void dsyrk(String uplo, String trans, int n, int k, double alpha, double[] a, int lda, double beta, double[] c, int ldc) {
        this.dsyrk(uplo, trans, n, k, alpha, a, 0, lda, beta, c, 0, ldc);
    }

    public abstract void dsyrk(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14);

    public final void dtbmv(String uplo, String trans, String diag, int n, int k, double[] a, int lda, double[] x, int incx) {
        this.dtbmv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    public abstract void dtbmv(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    public final void dtpmv(String uplo, String trans, String diag, int n, double[] ap, double[] x, int incx) {
        this.dtpmv(uplo, trans, diag, n, ap, 0, x, 0, incx);
    }

    public abstract void dtpmv(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    public final void dtrmm(String side, String uplo, String transa, String diag, int m, int n, double alpha, double[] a, int lda, double[] b, int ldb) {
        this.dtrmm(side, uplo, transa, diag, m, n, alpha, a, 0, lda, b, 0, ldb);
    }

    public abstract void dtrmm(String var1, String var2, String var3, String var4, int var5, int var6, double var7, double[] var9, int var10, int var11, double[] var12, int var13, int var14);

    public final void dtrmv(String uplo, String trans, String diag, int n, double[] a, int lda, double[] x, int incx) {
        this.dtrmv(uplo, trans, diag, n, a, 0, lda, x, 0, incx);
    }

    public abstract void dtrmv(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    public final void dtbsv(String uplo, String trans, String diag, int n, int k, double[] a, int lda, double[] x, int incx) {
        this.dtbsv(uplo, trans, diag, n, k, a, 0, lda, x, 0, incx);
    }

    public abstract void dtbsv(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    public final void dtpsv(String uplo, String trans, String diag, int n, double[] ap, double[] x, int incx) {
        this.dtpsv(uplo, trans, diag, n, ap, 0, x, 0, incx);
    }

    public abstract void dtpsv(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    public final void daxpy(int n, double da, double[] dx, int incx, double[] dy, int incy) {
        this.daxpy(n, da, dx, 0, incx, dy, 0, incy);
    }

    public abstract void daxpy(int var1, double var2, double[] var4, int var5, int var6, double[] var7, int var8, int var9);

    public final void dcopy(int n, double[] dx, int incx, double[] dy, int incy) {
        this.dcopy(n, dx, 0, incx, dy, 0, incy);
    }

    public abstract void dcopy(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    public final void dscal(int n, double da, double[] dx, int incx) {
        this.dscal(n, da, dx, 0, incx);
    }

    public abstract void dscal(int var1, double var2, double[] var4, int var5, int var6);

    public final void dswap(int n, double[] dx, int incx, double[] dy, int incy) {
        this.dswap(n, dx, 0, incx, dy, 0, incy);
    }

    public abstract void dswap(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    public final double ddot(int n, double[] dx, int incx, double[] dy, int incy) {
        return this.ddot(n, dx, 0, incx, dy, 0, incy);
    }

    public abstract double ddot(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    public final void drot(int n, double[] dx, int incx, double[] dy, int incy, double c, double s) {
        this.drot(n, dx, 0, incx, dy, 0, incy, c, s);
    }

    public abstract void drot(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, double var8, double var10);

    public final int idamax(int n, double[] dx, int incx) {
        return this.idamax(n, dx, 0, incx);
    }

    public abstract int idamax(int var1, double[] var2, int var3, int var4);

    public final void sgemm(String transa, String transb, int m, int n, int k, float alpha, float[] a, int lda, float[] b, int ldb, float beta, float[] c, int ldc) {
        this.sgemm(transa, transb, m, n, k, alpha, a, 0, lda, b, 0, ldb, beta, c, 0, ldc);
    }

    public abstract void sgemm(String var1, String var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16);

    public abstract void sgemm_multi(String var1, String var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16, int var17, int var18, int var19, int var20);

    public abstract void cgemm(Trans var1, Trans var2, int var3, int var4, int var5, float var6, float var7, float[] var8, int var9, float[] var10, int var11, float var12, float var13, float[] var14, int var15);

    public abstract void zgemm(Trans var1, Trans var2, int var3, int var4, int var5, double var6, double var8, double[] var10, int var11, double[] var12, int var13, double var14, double var16, double[] var18, int var19);

    protected Blas() {
    }

    static {
        netlib = new BlasJ();
        mkl = Blas.loadNative();
    }
}

