/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FJPool;
import java.util.concurrent.FJWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.UnsafeAccess;
import java.util.concurrent.Utils;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

abstract class FJTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    static final int DONE_MASK = -268435456;
    static final int NORMAL = -268435456;
    static final int CANCELLED = -1073741824;
    static final int EXCEPTIONAL = Integer.MIN_VALUE;
    static final int SIGNAL = 65536;
    static final int SMASK = 65535;
    private static final ExceptionNode[] exceptionTable = new ExceptionNode[32];
    private static final ReentrantLock exceptionTableLock = new ReentrantLock();
    private static final ReferenceQueue<FJTask<?>> exceptionTableRefQueue = new ReferenceQueue();
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long STATUS;

    FJTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setCompletion(int completion) {
        int s;
        do {
            if ((s = this.status) >= 0) continue;
            return s;
        } while (!U.compareAndSwapInt(this, STATUS, s, s | completion));
        if (s >>> 16 != 0) {
            FJTask fJTask = this;
            synchronized (fJTask) {
                this.notifyAll();
            }
        }
        return completion;
    }

    final int doExec() {
        int s = this.status;
        if (s >= 0) {
            boolean completed;
            try {
                completed = this.exec();
            }
            catch (Throwable rex) {
                return this.setExceptionalCompletion(rex);
            }
            if (completed) {
                s = this.setCompletion(-268435456);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void internalWait(long timeout) {
        int s = this.status;
        if (s >= 0 && U.compareAndSwapInt(this, STATUS, s, s | 0x10000)) {
            FJTask fJTask = this;
            synchronized (fJTask) {
                if (this.status >= 0) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalAwaitDone() {
        int s;
        int n = s = FJPool.common.tryExternalUnpush(this) ? this.doExec() : 0;
        if (s >= 0 && (s = this.status) >= 0) {
            boolean interrupted = false;
            do {
                if (!U.compareAndSwapInt(this, STATUS, s, s | 0x10000)) continue;
                FJTask fJTask = this;
                synchronized (fJTask) {
                    if (this.status >= 0) {
                        try {
                            this.wait(0L);
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    } else {
                        this.notifyAll();
                    }
                }
            } while ((s = this.status) >= 0);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int externalInterruptibleAwaitDone() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int s = this.status;
        if (s >= 0 && (s = FJPool.common.tryExternalUnpush(this) ? this.doExec() : 0) >= 0) {
            while ((s = this.status) >= 0) {
                if (!U.compareAndSwapInt(this, STATUS, s, s | 0x10000)) continue;
                FJTask fJTask = this;
                synchronized (fJTask) {
                    if (this.status >= 0) {
                        this.wait(0L);
                    } else {
                        this.notifyAll();
                    }
                }
            }
        }
        return s;
    }

    private int doJoin() {
        int n;
        int s = this.status;
        if (s < 0) {
            n = s;
        } else {
            Thread t = Thread.currentThread();
            if (t instanceof FJWorkerThread) {
                FJWorkerThread wt = (FJWorkerThread)t;
                FJPool.WorkQueue w = wt.workQueue;
                n = w.tryUnpush(this) && (s = this.doExec()) < 0 ? s : wt.pool.awaitJoin(w, this, 0L);
            } else {
                n = this.externalAwaitDone();
            }
        }
        return n;
    }

    private int doInvoke() {
        int n;
        int s = this.doExec();
        if (s < 0) {
            n = s;
        } else {
            Thread t = Thread.currentThread();
            if (t instanceof FJWorkerThread) {
                FJWorkerThread wt = (FJWorkerThread)t;
                n = wt.pool.awaitJoin(wt.workQueue, this, 0L);
            } else {
                n = this.externalAwaitDone();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int recordExceptionalCompletion(Throwable ex) {
        int s = this.status;
        if (s >= 0) {
            int h = System.identityHashCode(this);
            ReentrantLock lock = exceptionTableLock;
            lock.lock();
            try {
                FJTask.expungeStaleExceptions();
                ExceptionNode[] t = exceptionTable;
                int i = h & t.length - 1;
                ExceptionNode e = t[i];
                while (true) {
                    if (e == null) {
                        t[i] = new ExceptionNode(this, ex, t[i], exceptionTableRefQueue);
                        break;
                    }
                    if (e.get() == this) {
                        break;
                    }
                    e = e.next;
                }
            }
            finally {
                lock.unlock();
            }
            s = this.setCompletion(Integer.MIN_VALUE);
        }
        return s;
    }

    private int setExceptionalCompletion(Throwable ex) {
        return this.recordExceptionalCompletion(ex);
    }

    static final void cancelIgnoringExceptions(FJTask<?> t) {
        if (t != null && t.status >= 0) {
            try {
                t.cancel(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getThrowableException() {
        Throwable ex;
        ExceptionNode e;
        int h = System.identityHashCode(this);
        ReentrantLock lock = exceptionTableLock;
        lock.lock();
        try {
            FJTask.expungeStaleExceptions();
            ExceptionNode[] t = exceptionTable;
            e = t[h & t.length - 1];
            while (e != null && e.get() != this) {
                e = e.next;
            }
        }
        finally {
            lock.unlock();
        }
        if (e == null || (ex = e.ex) == null) {
            return null;
        }
        if (e.thrower != Thread.currentThread().getId()) {
            try {
                Constructor<?> noArgCtor = null;
                for (Constructor<?> c : ex.getClass().getConstructors()) {
                    Class<?>[] ps = c.getParameterTypes();
                    if (ps.length == 0) {
                        noArgCtor = c;
                        continue;
                    }
                    if (ps.length != 1 || ps[0] != Throwable.class) continue;
                    return (Throwable)c.newInstance(ex);
                }
                if (noArgCtor != null) {
                    Throwable wx = (Throwable)noArgCtor.newInstance(new Object[0]);
                    wx.initCause(ex);
                    return wx;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ex;
    }

    private static void expungeStaleExceptions() {
        Reference<FJTask<?>> x;
        block0: while ((x = exceptionTableRefQueue.poll()) != null) {
            if (!(x instanceof ExceptionNode)) continue;
            ExceptionNode[] t = exceptionTable;
            int i = ((ExceptionNode)x).hashCode & t.length - 1;
            ExceptionNode e = t[i];
            ExceptionNode pred = null;
            while (e != null) {
                ExceptionNode next = e.next;
                if (e == x) {
                    if (pred == null) {
                        t[i] = next;
                        continue block0;
                    }
                    pred.next = next;
                    continue block0;
                }
                pred = e;
                e = next;
            }
        }
    }

    static final void helpExpungeStaleExceptions() {
        ReentrantLock lock = exceptionTableLock;
        if (lock.tryLock()) {
            try {
                FJTask.expungeStaleExceptions();
            }
            finally {
                lock.unlock();
            }
        }
    }

    static void rethrow(Throwable ex) {
        FJTask.uncheckedThrow(ex);
    }

    static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        if (t != null) {
            throw t;
        }
        throw new Error("Unknown Exception");
    }

    private void reportException(int s) {
        if (s == -1073741824) {
            throw new CancellationException();
        }
        if (s == Integer.MIN_VALUE) {
            FJTask.rethrow(this.getThrowableException());
        }
    }

    final V invoke() {
        int s = this.doInvoke() & 0xF0000000;
        if (s != -268435456) {
            this.reportException(s);
        }
        return this.getRawResult();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.setCompletion(-1073741824) & 0xF0000000) == -1073741824;
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0xF0000000) == -1073741824;
    }

    final Throwable getException() {
        int s = this.status & 0xF0000000;
        return s >= -268435456 ? null : (s == -1073741824 ? new CancellationException() : this.getThrowableException());
    }

    public void completeExceptionally(Throwable ex) {
        this.setExceptionalCompletion(ex instanceof RuntimeException || ex instanceof Error ? ex : new RuntimeException(ex));
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        int s;
        int n = s = Thread.currentThread() instanceof FJWorkerThread ? this.doJoin() : this.externalInterruptibleAwaitDone();
        if ((s &= 0xF0000000) == -1073741824) {
            throw new CancellationException();
        }
        if (s == Integer.MIN_VALUE) {
            throw new ExecutionException(this.getThrowableException());
        }
        return this.getRawResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int s = this.status;
        if (s >= 0 && nanos > 0L) {
            long d = System.nanoTime() + nanos;
            long deadline = d == 0L ? 1L : d;
            Thread t = Thread.currentThread();
            if (t instanceof FJWorkerThread) {
                FJWorkerThread wt = (FJWorkerThread)t;
                s = wt.pool.awaitJoin(wt.workQueue, this, deadline);
            } else {
                s = FJPool.common.tryExternalUnpush(this) ? this.doExec() : 0;
                if (s >= 0) {
                    long ns;
                    while ((s = this.status) >= 0 && (ns = deadline - System.nanoTime()) > 0L) {
                        long ms = TimeUnit.NANOSECONDS.toMillis(ns);
                        if (ms <= 0L || !U.compareAndSwapInt(this, STATUS, s, s | 0x10000)) continue;
                        FJTask fJTask = this;
                        synchronized (fJTask) {
                            if (this.status >= 0) {
                                this.wait(ms);
                            } else {
                                this.notifyAll();
                            }
                        }
                    }
                }
            }
        }
        if (s >= 0) {
            s = this.status;
        }
        if ((s &= 0xF0000000) != -268435456) {
            if (s == -1073741824) {
                throw new CancellationException();
            }
            if (s != Integer.MIN_VALUE) {
                throw new TimeoutException();
            }
            throw new ExecutionException(this.getThrowableException());
        }
        return this.getRawResult();
    }

    final void quietlyJoin() {
        this.doJoin();
    }

    static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof FJWorkerThread;
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    final boolean compareAndSetForkJoinTaskTag(short expect, short update) {
        int s;
        do {
            if ((short)(s = this.status) == expect) continue;
            return false;
        } while (!U.compareAndSwapInt(this, STATUS, s, s & 0xFFFF0000 | update & 0xFFFF));
        return true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object ex = s.readObject();
        if (ex != null) {
            this.setExceptionalCompletion((Throwable)ex);
        }
    }

    static {
        try {
            STATUS = U.objectFieldOffset(FJTask.class.getDeclaredField("status"));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static final class AdaptedCallable<T>
    extends FJTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            this.callable = Utils.requireNonNull(callable);
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public final boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.callable + "]";
        }
    }

    static final class RunnableExecuteAction
    extends FJTask<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        RunnableExecuteAction(Runnable runnable) {
            this.runnable = Utils.requireNonNull(runnable);
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        void internalPropagateException(Throwable ex) {
            RunnableExecuteAction.rethrow(ex);
        }
    }

    static final class AdaptedRunnableAction
    extends FJTask<Void>
    implements RunnableFuture<Void> {
        final Runnable runnable;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnableAction(Runnable runnable) {
            this.runnable = Utils.requireNonNull(runnable);
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.runnable + "]";
        }
    }

    static final class AdaptedRunnable<T>
    extends FJTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T result) {
            this.runnable = Utils.requireNonNull(runnable);
            this.result = result;
        }

        @Override
        public final T getRawResult() {
            return this.result;
        }

        @Override
        public final void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public final boolean exec() {
            this.runnable.run();
            return true;
        }

        @Override
        public final void run() {
            this.invoke();
        }

        public String toString() {
            return super.toString() + "[Wrapped task = " + this.runnable + "]";
        }
    }

    static final class ExceptionNode
    extends WeakReference<FJTask<?>> {
        final Throwable ex;
        ExceptionNode next;
        final long thrower;
        final int hashCode;

        ExceptionNode(FJTask<?> task, Throwable ex, ExceptionNode next, ReferenceQueue<FJTask<?>> exceptionTableRefQueue) {
            super(task, exceptionTableRefQueue);
            this.ex = ex;
            this.next = next;
            this.thrower = Thread.currentThread().getId();
            this.hashCode = System.identityHashCode(task);
        }
    }
}

