/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractIOReactor;
import org.apache.http.impl.nio.reactor.SessionHandle;
import org.apache.http.impl.nio.reactor.SessionSet;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;

public class BaseIOReactor
extends AbstractIOReactor {
    private final long timeoutCheckInterval;
    private SessionSet bufferingSessions = new SessionSet();
    private long lastTimeoutCheck;

    public BaseIOReactor(long selectTimeout) throws IOReactorException {
        super(selectTimeout);
        this.timeoutCheckInterval = selectTimeout;
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    protected void acceptable(SelectionKey key) {
    }

    protected void connectable(SelectionKey key) {
    }

    protected void readable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastRead();
        this.eventDispatch.inputReady(session);
        if (session.hasBufferedInput()) {
            this.bufferingSessions.add(session);
        }
    }

    protected void writable(SelectionKey key) {
        SessionHandle handle = (SessionHandle)key.attachment();
        IOSession session = handle.getSession();
        handle.resetLastWrite();
        this.eventDispatch.outputReady(session);
    }

    protected void validate(Set keys) {
        Iterator it;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck >= this.timeoutCheckInterval) {
            this.lastTimeoutCheck = currentTime;
            if (keys != null) {
                it = keys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = (SelectionKey)it.next();
                    this.timeoutCheck(key, currentTime);
                }
            }
        }
        if (!this.bufferingSessions.isEmpty()) {
            it = this.bufferingSessions.iterator();
            while (it.hasNext()) {
                IOSession session = (IOSession)it.next();
                if (!session.hasBufferedInput()) {
                    it.remove();
                    continue;
                }
                try {
                    int ops = session.getEventMask();
                    if ((ops & 1) <= 0) continue;
                    this.eventDispatch.inputReady(session);
                    if (session.hasBufferedInput()) continue;
                    it.remove();
                }
                catch (CancelledKeyException ex) {
                    it.remove();
                }
            }
        }
    }

    protected void timeoutCheck(SelectionKey key, long now) {
        SessionHandle handle;
        IOSession session;
        int timeout;
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle && (timeout = (session = (handle = (SessionHandle)key.attachment()).getSession()).getSocketTimeout()) > 0 && handle.getLastReadTime() + (long)timeout < now) {
            this.eventDispatch.timeout(session);
        }
    }

    protected void keyCreated(SelectionKey key, IOSession session) {
        SessionHandle handle = new SessionHandle(session);
        key.attach(handle);
    }

    protected IOSession keyCancelled(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SessionHandle) {
            SessionHandle handle = (SessionHandle)attachment;
            return handle.getSession();
        }
        return null;
    }
}

