/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.Map;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseCommandChainExecutable;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.text.base.BaseTextOptions;

public final class CommandDaisyChainExecutable
extends BaseCommandChainExecutable {
    public CommandDaisyChainExecutable(String commands) throws SchemaCrawlerException {
        super(commands);
    }

    @Override
    protected void executeOn(Database database, Connection connection) throws Exception {
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        for (String command : commands) {
            Executable executable = this.addNext(command);
            BaseTextOptions baseTextOptions = new BaseTextOptions(this.additionalConfiguration);
            if (commands.hasMultipleCommands()) {
                if (commands.isFirstCommand(command)) {
                    baseTextOptions.setNoFooter(true);
                } else if (commands.isLastCommand(command)) {
                    baseTextOptions.setNoHeader(true);
                    baseTextOptions.setNoInfo(true);
                    baseTextOptions.setAppendOutput(true);
                } else {
                    baseTextOptions.setNoHeader(true);
                    baseTextOptions.setNoInfo(true);
                    baseTextOptions.setNoFooter(true);
                    baseTextOptions.setAppendOutput(true);
                }
            }
            Config executableAdditionalConfig = new Config();
            if (this.additionalConfiguration != null) {
                executableAdditionalConfig.putAll((Map)this.additionalConfiguration);
            }
            executableAdditionalConfig.putAll((Map)baseTextOptions.toConfig());
            executable.setAdditionalConfiguration(executableAdditionalConfig);
        }
        this.executeChain(database, connection);
    }
}

