/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.RoutineReturnType;

public enum FunctionReturnType implements RoutineReturnType
{
    unknown(0, "result unknown"),
    noTable(1, "does not return a table"),
    returnsTable(2, "returns table");

    private static final Logger LOGGER;
    private final int id;
    private final String text;

    public static FunctionReturnType valueOf(int id) {
        for (FunctionReturnType type : FunctionReturnType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        LOGGER.log(Level.FINE, "Unknown id " + id);
        return unknown;
    }

    private FunctionReturnType(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.text;
    }

    static {
        LOGGER = Logger.getLogger(FunctionReturnType.class.getName());
    }
}

