/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.MutableFunctionColumn;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Function;
import schemacrawler.schema.FunctionColumn;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;

final class MutableFunction
extends MutableRoutine
implements Function {
    private static final long serialVersionUID = 3906925686089134130L;
    private FunctionReturnType functionType;
    private final NamedObjectList<MutableFunctionColumn> columns = new NamedObjectList();
    private RoutineBodyType routineBodyType;

    MutableFunction(Schema schema, String name) {
        super(schema, name);
        this.functionType = FunctionReturnType.unknown;
        this.routineBodyType = RoutineBodyType.unknown;
    }

    @Override
    public MutableFunctionColumn getColumn(String name) {
        return this.columns.lookup(this, name);
    }

    @Override
    public List<FunctionColumn> getColumns() {
        return new ArrayList<FunctionColumn>(this.columns.values());
    }

    @Override
    public FunctionReturnType getReturnType() {
        return this.functionType;
    }

    @Override
    public RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    @Override
    public RoutineType getType() {
        return RoutineType.function;
    }

    void addColumn(MutableFunctionColumn column) {
        this.columns.add(column);
    }

    @Override
    void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }

    void setType(FunctionReturnType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null function type");
        }
        this.functionType = type;
    }
}

