/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import schemacrawler.Version;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.Config;
import sf.util.Utility;

final class MutableSchemaCrawlerInfo
implements SchemaCrawlerInfo {
    private static final long serialVersionUID = 4051323422934251828L;
    private String schemaCrawlerProductName;
    private String schemaCrawlerVersion;
    private String schemaCrawlerAbout;
    private String crawlTimestamp;
    private final Map<String, String> systemProperties = new HashMap<String, String>();

    MutableSchemaCrawlerInfo() {
    }

    @Override
    public String getCrawlTimestamp() {
        return this.crawlTimestamp;
    }

    @Override
    public String getSchemaCrawlerAbout() {
        return this.schemaCrawlerAbout;
    }

    @Override
    public String getSchemaCrawlerProductName() {
        return this.schemaCrawlerProductName;
    }

    @Override
    public String getSchemaCrawlerVersion() {
        return this.schemaCrawlerVersion;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("-- generated by: ").append(this.getSchemaCrawlerProductName()).append(' ').append(this.getSchemaCrawlerVersion()).append(Utility.NEWLINE);
        return info.toString();
    }

    void setAdditionalSchemaCrawlerInfo() {
        this.systemProperties.putAll(new Config(System.getProperties()));
    }

    void setSchemaCrawlerInfo() {
        this.schemaCrawlerProductName = Version.getProductName();
        this.schemaCrawlerVersion = Version.getVersion();
        this.schemaCrawlerAbout = Version.about();
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(2, 3);
        this.crawlTimestamp = dateFormatter.format(new Date());
    }
}

