/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.crawl.ColumnDataTypes;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableSchemaCrawlerInfo;
import schemacrawler.crawl.MutableSynonym;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;

final class MutableDatabase
extends AbstractNamedObjectWithAttributes
implements Database {
    private static final long serialVersionUID = 4051323422934251828L;
    private final MutableDatabaseInfo databaseInfo;
    private final MutableJdbcDriverInfo jdbcDriverInfo;
    private final MutableSchemaCrawlerInfo schemaCrawlerInfo;
    private final Set<Schema> schemas;
    private final ColumnDataTypes columnDataTypes = new ColumnDataTypes();
    private final NamedObjectList<MutableTable> tables = new NamedObjectList();
    private final NamedObjectList<MutableRoutine> routines = new NamedObjectList();
    private final NamedObjectList<MutableSynonym> synonyms = new NamedObjectList();

    MutableDatabase(String name) {
        super(name);
        this.databaseInfo = new MutableDatabaseInfo();
        this.jdbcDriverInfo = new MutableJdbcDriverInfo();
        this.schemaCrawlerInfo = new MutableSchemaCrawlerInfo();
        this.schemas = new HashSet<Schema>();
    }

    @Override
    public MutableColumnDataType getColumnDataType(Schema schema, String name) {
        return (MutableColumnDataType)this.columnDataTypes.lookup(schema, name);
    }

    @Override
    public Collection<ColumnDataType> getColumnDataTypes() {
        return new ArrayList<ColumnDataType>(this.columnDataTypes.values());
    }

    @Override
    public Collection<ColumnDataType> getColumnDataTypes(Schema schema) {
        Collection<ColumnDataType> values = this.getColumnDataTypes();
        Iterator<ColumnDataType> iterator = values.iterator();
        while (iterator.hasNext()) {
            ColumnDataType mutableColumnDataType = iterator.next();
            if (mutableColumnDataType.getSchema().equals(schema)) continue;
            iterator.remove();
        }
        return values;
    }

    @Override
    public MutableDatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    @Override
    public MutableJdbcDriverInfo getJdbcDriverInfo() {
        return this.jdbcDriverInfo;
    }

    @Override
    public Routine getRoutine(Schema schema, String name) {
        return this.routines.lookup(schema, name);
    }

    @Override
    public Collection<Routine> getRoutines() {
        List<MutableRoutine> values = this.routines.values();
        return new ArrayList<Routine>(values);
    }

    @Override
    public Collection<Routine> getRoutines(Schema schema) {
        ArrayList<Routine> values = new ArrayList<Routine>(this.routines.values());
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            if (routine.getSchema().equals(schema)) continue;
            iterator.remove();
        }
        return values;
    }

    @Override
    public Schema getSchema(String name) {
        Collection<Schema> schemas = this.getSchemaNames();
        for (Schema schema : schemas) {
            if (!schema.getFullName().equals(name)) continue;
            return schema;
        }
        return null;
    }

    @Override
    public MutableSchemaCrawlerInfo getSchemaCrawlerInfo() {
        return this.schemaCrawlerInfo;
    }

    @Override
    public Collection<Schema> getSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>(this.schemas);
        Collections.sort(schemas);
        return schemas;
    }

    @Override
    public MutableSynonym getSynonym(Schema schemaRef, String name) {
        return this.synonyms.lookup(schemaRef, name);
    }

    @Override
    public Collection<Synonym> getSynonyms() {
        return new ArrayList<Synonym>(this.synonyms.values());
    }

    @Override
    public Collection<Synonym> getSynonyms(Schema schemaRef) {
        Collection<Synonym> values = this.getSynonyms();
        Iterator<Synonym> iterator = values.iterator();
        while (iterator.hasNext()) {
            Synonym mutableSynonym = iterator.next();
            if (mutableSynonym.getSchema().equals(schemaRef)) continue;
            iterator.remove();
        }
        return values;
    }

    @Override
    public MutableColumnDataType getSystemColumnDataType(String name) {
        return this.getColumnDataType(new SchemaReference(), name);
    }

    @Override
    public Collection<ColumnDataType> getSystemColumnDataTypes() {
        return this.getColumnDataTypes(new SchemaReference());
    }

    @Override
    public MutableTable getTable(Schema schemaRef, String name) {
        return this.tables.lookup(schemaRef, name);
    }

    @Override
    public Collection<Table> getTables() {
        ArrayList<Table> values = new ArrayList<Table>(this.tables.values());
        return values;
    }

    @Override
    public Collection<Table> getTables(Schema schema) {
        Collection<Table> values = this.getTables();
        Iterator<Table> iterator = values.iterator();
        while (iterator.hasNext()) {
            Table mutableTable = iterator.next();
            if (mutableTable.getSchema().equals(schema)) continue;
            iterator.remove();
        }
        return values;
    }

    void addColumnDataType(MutableColumnDataType columnDataType) {
        if (columnDataType != null) {
            this.columnDataTypes.add(columnDataType);
        }
    }

    void addRoutine(MutableRoutine routine) {
        this.routines.add(routine);
    }

    Schema addSchema(Schema schema) {
        this.schemas.add(schema);
        return schema;
    }

    Schema addSchema(String catalogName, String schemaName) {
        return this.addSchema(new SchemaReference(catalogName, schemaName));
    }

    void addSynonym(MutableSynonym synonym) {
        this.synonyms.add(synonym);
    }

    void addTable(MutableTable table) {
        this.tables.add(table);
    }

    NamedObjectList<MutableRoutine> getAllRoutines() {
        return this.routines;
    }

    NamedObjectList<MutableSynonym> getAllSynonyms() {
        return this.synonyms;
    }

    NamedObjectList<MutableTable> getAllTables() {
        return this.tables;
    }

    Collection<Schema> getSchemaNames() {
        return this.schemas;
    }

    MutableColumnDataType lookupColumnDataTypeByType(int type) {
        return this.columnDataTypes.lookupColumnDataTypeByType(type);
    }
}

