/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.schema.NamedObjectWithAttributes;
import sf.util.Utility;

abstract class AbstractNamedObjectWithAttributes
extends AbstractNamedObject
implements NamedObjectWithAttributes {
    private static final long serialVersionUID = -1486322887991472729L;
    private String remarks;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();

    AbstractNamedObjectWithAttributes(String name) {
        super(name);
    }

    @Override
    public final Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public final <T> T getAttribute(String name, T defaultValue) {
        Object attributeValue = this.getAttribute(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return (T)attributeValue;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @Override
    public final String getRemarks() {
        return this.remarks;
    }

    @Override
    public final void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    final void addAttributes(Map<String, Object> values) {
        if (values != null) {
            this.attributeMap.putAll(values);
        }
    }

    final void setRemarks(String remarks) {
        this.remarks = remarks == null ? "" : remarks;
    }
}

