/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.options.OutputFormat;
import sf.util.ObjectToString;
import sf.util.Utility;

public class OutputOptions
implements Options {
    private static final long serialVersionUID = 7018337388923813055L;
    private static final String SC_INPUT_ENCODING = "schemacrawler.encoding.input";
    private static final String SC_OUTPUT_ENCODING = "schemacrawler.encoding.output";
    private String outputFormatValue;
    private File outputFile;
    private Writer writer;
    private Charset inputCharset;
    private Charset outputCharset;

    public OutputOptions() {
        this(OutputFormat.text.name());
    }

    public OutputOptions(Config config) {
        this();
        Config configProperties = config == null ? new Config() : config;
        this.setInputEncoding(configProperties.getStringValue(SC_INPUT_ENCODING, "UTF-8"));
        this.setOutputEncoding(configProperties.getStringValue(SC_OUTPUT_ENCODING, "UTF-8"));
    }

    public OutputOptions(String outputFormatValue) {
        this(outputFormatValue, (File)null);
    }

    public OutputOptions(String outputFormatValue, File outputFile) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = outputFile;
        this.writer = null;
    }

    public OutputOptions(String outputFormatValue, Writer writer) {
        this.outputFormatValue = outputFormatValue;
        this.outputFile = null;
        this.writer = writer;
    }

    public Charset getInputCharset() {
        if (this.inputCharset == null) {
            return Charset.forName("UTF-8");
        }
        return this.inputCharset;
    }

    public Charset getOutputCharset() {
        if (this.outputCharset == null) {
            return this.getInputCharset();
        }
        return this.outputCharset;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public OutputFormat getOutputFormat() {
        OutputFormat outputFormat;
        try {
            outputFormat = OutputFormat.valueOf(this.outputFormatValue);
        }
        catch (IllegalArgumentException e) {
            outputFormat = null;
        }
        return outputFormat;
    }

    public String getOutputFormatValue() {
        return this.outputFormatValue;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean hasOutputFormat() {
        return this.getOutputFormat() != null;
    }

    public boolean isConsoleOutput() {
        return this.outputFile == null && this.writer == null;
    }

    public boolean isFileOutput() {
        return this.outputFile != null && this.writer == null;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputCharset = Utility.isBlank((String)inputEncoding) ? Charset.defaultCharset() : Charset.forName(inputEncoding);
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputCharset = Utility.isBlank((String)outputEncoding) ? Charset.defaultCharset() : Charset.forName(outputEncoding);
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setOutputFormatValue(String outputFormatValue) {
        if (outputFormatValue == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.outputFormatValue = outputFormatValue;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return ObjectToString.toString((Object)this);
    }
}

