/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.UUID;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;

public class GraphOutputOptions
extends OutputOptions {
    private static final long serialVersionUID = -7333423775806155323L;
    private final OutputOptions outputOptions;

    public GraphOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions;
    }

    public File getDiagramFile() {
        File diagramOutputFile = this.getOutputFile();
        File diagramFile = diagramOutputFile == null ? new File(".", "schemacrawler." + UUID.randomUUID() + "." + this.getGraphOutputFormat().getFormat()) : diagramOutputFile;
        return diagramFile;
    }

    public GraphOutputFormat getGraphOutputFormat() {
        GraphOutputFormat outputFormat;
        try {
            outputFormat = GraphOutputFormat.valueOf(this.getOutputFormatValue());
        }
        catch (IllegalArgumentException e) {
            outputFormat = GraphOutputFormat.echo;
        }
        return outputFormat;
    }

    @Override
    public Charset getInputCharset() {
        return this.outputOptions.getInputCharset();
    }

    @Override
    public Charset getOutputCharset() {
        return this.outputOptions.getOutputCharset();
    }

    @Override
    public File getOutputFile() {
        return this.outputOptions.getOutputFile();
    }

    @Override
    public OutputFormat getOutputFormat() {
        return this.outputOptions.getOutputFormat();
    }

    @Override
    public String getOutputFormatValue() {
        return this.outputOptions.getOutputFormatValue();
    }

    @Override
    public Writer getWriter() {
        return this.outputOptions.getWriter();
    }

    @Override
    public boolean hasOutputFormat() {
        return this.outputOptions.hasOutputFormat();
    }

    @Override
    public boolean isConsoleOutput() {
        return this.outputOptions.isConsoleOutput();
    }

    @Override
    public boolean isFileOutput() {
        return this.outputOptions.isFileOutput();
    }

    @Override
    public void setInputEncoding(String inputEncoding) {
        this.outputOptions.setInputEncoding(inputEncoding);
    }

    @Override
    public void setOutputEncoding(String outputEncoding) {
        this.outputOptions.setOutputEncoding(outputEncoding);
    }

    @Override
    public void setOutputFile(File outputFile) {
        this.outputOptions.setOutputFile(outputFile);
    }

    @Override
    public void setOutputFormatValue(String outputFormatValue) {
        this.outputOptions.setOutputFormatValue(outputFormatValue);
    }

    @Override
    public void setWriter(Writer writer) {
        this.outputOptions.setWriter(writer);
    }

    @Override
    public String toString() {
        return this.outputOptions.toString();
    }
}

