/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.OutputOptions;
import sf.util.ObjectToString;
import sf.util.Utility;

public abstract class BaseExecutable
implements Executable {
    protected final String command;
    protected SchemaCrawlerOptions schemaCrawlerOptions;
    protected OutputOptions outputOptions;
    protected Config additionalConfiguration;

    protected BaseExecutable(String command) {
        if (Utility.isBlank((String)command)) {
            throw new IllegalArgumentException("No command specified");
        }
        this.command = command;
        this.schemaCrawlerOptions = new SchemaCrawlerOptions();
        this.outputOptions = new OutputOptions();
    }

    @Override
    public final Config getAdditionalConfiguration() {
        return this.additionalConfiguration;
    }

    @Override
    public final String getCommand() {
        return this.command;
    }

    @Override
    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    @Override
    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    @Override
    public final void setAdditionalConfiguration(Config additionalConfiguration) {
        this.additionalConfiguration = additionalConfiguration == null ? new Config() : additionalConfiguration;
    }

    @Override
    public final void setOutputOptions(OutputOptions outputOptions) {
        if (outputOptions != null) {
            this.outputOptions = outputOptions;
        }
    }

    @Override
    public final void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        if (schemaCrawlerOptions != null) {
            this.schemaCrawlerOptions = schemaCrawlerOptions;
        }
    }

    public final String toString() {
        return ObjectToString.toString((Object)this);
    }
}

