/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.AdditionalConfigParser;
import schemacrawler.tools.commandline.BundledDriverConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandLineConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.commandline.ConfigParser;
import schemacrawler.tools.commandline.OutputOptionsParser;
import schemacrawler.tools.commandline.SchemaCrawlerOptionsParser;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.BundledDriverOptions;
import schemacrawler.tools.options.OutputOptions;
import sf.util.ObjectToString;

public final class SchemaCrawlerCommandLine
implements CommandLine {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerCommandLine.class.getName());
    private final String command;
    private final Config config;
    private final SchemaCrawlerOptions schemaCrawlerOptions;
    private final OutputOptions outputOptions;
    private final ConnectionOptions connectionOptions;
    private final BundledDriverOptions bundledDriverOptions;

    public SchemaCrawlerCommandLine(BundledDriverOptions bundledDriverOptions, String ... args) throws SchemaCrawlerException {
        this(bundledDriverOptions, (ConnectionOptions)null, args);
    }

    public SchemaCrawlerCommandLine(ConnectionOptions connectionOptions, String ... args) throws SchemaCrawlerException {
        this(null, connectionOptions, args);
    }

    private SchemaCrawlerCommandLine(BundledDriverOptions bundledDriverOptions, ConnectionOptions connectionOptions, String ... args) throws SchemaCrawlerException {
        if (args == null || args.length == 0) {
            throw new SchemaCrawlerException("No command line arguments provided");
        }
        String[] remainingArgs = args;
        CommandParser commandParser = new CommandParser();
        remainingArgs = commandParser.parse(remainingArgs);
        if (!commandParser.hasOptions()) {
            throw new SchemaCrawlerException("No command specified");
        }
        this.command = commandParser.getOptions().toString();
        this.bundledDriverOptions = bundledDriverOptions != null ? bundledDriverOptions : new BundledDriverOptions(){
            private static final long serialVersionUID = -8917733124364175122L;
        };
        this.config = this.bundledDriverOptions.getConfig();
        if (remainingArgs.length > 0) {
            ConfigParser configParser = new ConfigParser();
            remainingArgs = configParser.parse(remainingArgs);
            this.config.putAll((Map)configParser.getOptions());
        }
        if (remainingArgs.length > 0) {
            AdditionalConfigParser additionalConfigParser = new AdditionalConfigParser(this.config);
            remainingArgs = additionalConfigParser.parse(remainingArgs);
            this.config.putAll((Map)additionalConfigParser.getOptions());
        }
        if (connectionOptions != null) {
            this.connectionOptions = connectionOptions;
        } else if (this.bundledDriverOptions.hasConfig()) {
            BundledDriverConnectionOptionsParser bundledDriverConnectionOptionsParser = new BundledDriverConnectionOptionsParser(this.config);
            remainingArgs = bundledDriverConnectionOptionsParser.parse(remainingArgs);
            this.connectionOptions = (ConnectionOptions)bundledDriverConnectionOptionsParser.getOptions();
        } else {
            CommandLineConnectionOptionsParser commandLineConnectionOptionsParser = new CommandLineConnectionOptionsParser(this.config);
            remainingArgs = commandLineConnectionOptionsParser.parse(remainingArgs);
            this.connectionOptions = commandLineConnectionOptionsParser.getOptions();
        }
        SchemaCrawlerOptionsParser schemaCrawlerOptionsParser = new SchemaCrawlerOptionsParser(this.config);
        remainingArgs = schemaCrawlerOptionsParser.parse(remainingArgs);
        this.schemaCrawlerOptions = schemaCrawlerOptionsParser.getOptions();
        OutputOptionsParser outputOptionsParser = new OutputOptionsParser(this.config);
        remainingArgs = outputOptionsParser.parse(remainingArgs);
        this.outputOptions = outputOptionsParser.getOptions();
        if (remainingArgs.length > 0) {
            LOGGER.log(Level.INFO, "Too many command line arguments provided: " + ObjectToString.toString((Object)remainingArgs));
        }
    }

    @Override
    public void execute() throws Exception {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        Executable executableForList = this.bundledDriverOptions.newPreExecutable();
        this.initialize(executableForList);
        executables.add(executableForList);
        executableForList = new SchemaCrawlerExecutable(this.command);
        this.initialize(executableForList);
        executables.add(executableForList);
        executableForList = this.bundledDriverOptions.newPostExecutable();
        this.initialize(executableForList);
        executables.add(executableForList);
        if (this.connectionOptions != null) {
            try (Connection connection = this.connectionOptions.getConnection();){
                LOGGER.log(Level.INFO, "Made connection, " + connection);
                for (Executable executable : executables) {
                    executable.execute(connection);
                }
            }
        } else {
            throw new SchemaCrawlerException("No connection options provided");
        }
    }

    public final String getCommand() {
        return this.command;
    }

    public final Config getConfig() {
        return this.config;
    }

    public final ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    private void initialize(Executable executable) {
        if (this.outputOptions != null) {
            executable.setOutputOptions(this.outputOptions);
        }
        if (this.schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        }
        if (this.config != null) {
            executable.setAdditionalConfiguration(this.config);
        }
    }
}

