/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;

public final class OutputWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger(OutputWriter.class.getName());
    private final Writer writer;
    private boolean isClosed;
    private boolean isFileOutput;

    public OutputWriter(OutputOptions outputOptions) throws SchemaCrawlerException {
        this(outputOptions, false);
    }

    public OutputWriter(OutputOptions outputOptions, boolean appendOutput) throws SchemaCrawlerException {
        this.writer = this.openOutputWriter(outputOptions, appendOutput);
    }

    @Override
    public Writer append(char c) throws IOException {
        this.ensureOpen();
        return this.writer.append(c);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.ensureOpen();
        return this.writer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.ensureOpen();
        return this.writer.append(csq, start, end);
    }

    @Override
    public void close() throws IOException {
        this.ensureOpen();
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.isFileOutput) {
            if (this.writer != null) {
                this.writer.close();
                LOGGER.log(Level.INFO, "Closed output writer");
            }
        } else {
            LOGGER.log(Level.INFO, "Not closing output writer, since output is not to a file");
        }
        this.isClosed = true;
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.writer.flush();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.ensureOpen();
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.ensureOpen();
        this.writer.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.ensureOpen();
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.ensureOpen();
        this.writer.write(str, off, len);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed) {
            throw new IllegalStateException("Output writer was not closed");
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("Writer has already been closed");
        }
    }

    private Writer openOutputWriter(OutputOptions outputOptions, boolean appendOutput) throws SchemaCrawlerException {
        try {
            Writer writer;
            if (outputOptions == null || outputOptions.isConsoleOutput()) {
                writer = new OutputStreamWriter(System.out);
                LOGGER.log(Level.INFO, "Opened output writer to console");
            } else if (outputOptions.isFileOutput()) {
                this.isFileOutput = true;
                File outputFile = outputOptions.getOutputFile();
                FileOutputStream fileOutputStream = new FileOutputStream(outputFile, appendOutput);
                writer = new OutputStreamWriter((OutputStream)fileOutputStream, outputOptions.getOutputCharset());
                LOGGER.log(Level.INFO, "Opened output writer to file, " + outputFile.getAbsolutePath());
            } else {
                writer = outputOptions.getWriter();
                LOGGER.log(Level.INFO, "Output to provided writer");
            }
            return writer;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not obtain output writer", (Throwable)e);
        }
    }
}

