/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.MutableForeignKeyColumnReference;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TablePartial;
import schemacrawler.filter.FilterFactory;
import schemacrawler.filter.NamedObjectFilter;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

class TablesReducer {
    private final SchemaCrawlerOptions options;
    private final NamedObjectList<MutableTable> allTables;

    public TablesReducer(SchemaCrawlerOptions options, NamedObjectList<MutableTable> allTables) {
        this.options = options;
        this.allTables = allTables;
    }

    public void filter() {
        Collection<MutableTable> filteredTables = this.doFilter();
        for (MutableTable table : this.allTables) {
            if (filteredTables.contains(table)) continue;
            this.allTables.remove(table);
        }
        this.removeForeignKeys();
    }

    private Collection<MutableTable> doFilter() {
        NamedObjectFilter<Table> grepFilter = FilterFactory.grepTablesFilter(this.options);
        HashSet<MutableTable> greppedTables = new HashSet<MutableTable>();
        for (MutableTable table : this.allTables) {
            if (!grepFilter.include(table)) continue;
            greppedTables.add(table);
        }
        int childTableFilterDepth = this.options.getChildTableFilterDepth();
        Collection<MutableTable> childTables = this.includeRelatedTables(TableRelationshipType.child, childTableFilterDepth, greppedTables);
        int parentTableFilterDepth = this.options.getParentTableFilterDepth();
        Collection<MutableTable> parentTables = this.includeRelatedTables(TableRelationshipType.parent, parentTableFilterDepth, greppedTables);
        HashSet<MutableTable> filteredTables = new HashSet<MutableTable>();
        filteredTables.addAll(greppedTables);
        filteredTables.addAll(childTables);
        filteredTables.addAll(parentTables);
        return filteredTables;
    }

    private Collection<MutableTable> includeRelatedTables(TableRelationshipType tableRelationshipType, int depth, Set<MutableTable> greppedTables) {
        HashSet<MutableTable> includedTables = new HashSet<MutableTable>();
        includedTables.addAll(greppedTables);
        for (int i = 0; i < depth; ++i) {
            for (MutableTable table : new HashSet<MutableTable>(includedTables)) {
                for (Table relatedTable : table.getRelatedTables(tableRelationshipType)) {
                    if (!(relatedTable instanceof MutableTable)) continue;
                    includedTables.add((MutableTable)relatedTable);
                }
            }
        }
        return includedTables;
    }

    private void removeForeignKeys() {
        for (MutableTable table : this.allTables) {
            ColumnPartial columnPartial;
            boolean removeFk;
            Table referencedTable;
            for (ForeignKey fk : table.getExportedForeignKeys()) {
                for (ForeignKeyColumnReference fkColumnReference : fk.getColumnReferences()) {
                    referencedTable = (Table)fkColumnReference.getForeignKeyColumn().getParent();
                    removeFk = false;
                    if (!(referencedTable instanceof MutableTable)) {
                        removeFk = true;
                    } else if (!this.allTables.contains((MutableTable)referencedTable)) {
                        removeFk = true;
                    }
                    if (!removeFk) continue;
                    if (this.options.isGrepOnlyMatching()) {
                        table.removeForeignKey(fk.getFullName());
                        continue;
                    }
                    columnPartial = new ColumnPartial(fkColumnReference.getForeignKeyColumn());
                    ((TablePartial)columnPartial.getParent()).addForeignKey(fk);
                    ((MutableForeignKeyColumnReference)fkColumnReference).setForeignKeyColumn(columnPartial);
                }
            }
            for (ForeignKey fk : table.getImportedForeignKeys()) {
                for (ForeignKeyColumnReference fkColumnReference : fk.getColumnReferences()) {
                    referencedTable = (Table)fkColumnReference.getPrimaryKeyColumn().getParent();
                    removeFk = false;
                    if (!(referencedTable instanceof MutableTable)) {
                        removeFk = true;
                    } else if (!this.allTables.contains((MutableTable)referencedTable)) {
                        removeFk = true;
                    }
                    if (!removeFk) continue;
                    if (this.options.isGrepOnlyMatching()) {
                        table.removeForeignKey(fk.getFullName());
                        continue;
                    }
                    columnPartial = new ColumnPartial(fkColumnReference.getPrimaryKeyColumn());
                    ((TablePartial)columnPartial.getParent()).addForeignKey(fk);
                    ((MutableForeignKeyColumnReference)fkColumnReference).setPrimaryKeyColumn(columnPartial);
                }
            }
        }
    }
}

