/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.DatabaseSpecificOverrideOptions;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import sf.util.Utility;

final class RetrieverConnection {
    private static final Logger LOGGER = Logger.getLogger(RetrieverConnection.class.getName());
    private final Connection connection;
    private final DatabaseMetaData metaData;
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;
    private final String identifierQuoteString;
    private final List<String> reservedWords;
    private final InformationSchemaViews informationSchemaViews;

    RetrieverConnection(Connection connection, SchemaCrawlerOptions options) throws SQLException {
        SchemaCrawlerOptions schemaCrawlerOptions = options;
        if (schemaCrawlerOptions == null) {
            schemaCrawlerOptions = new SchemaCrawlerOptions();
        }
        if (connection == null) {
            throw new SQLException("No connection provided");
        }
        if (connection.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        this.connection = connection;
        this.metaData = connection.getMetaData();
        this.informationSchemaViews = schemaCrawlerOptions.getInformationSchemaViews();
        DatabaseSpecificOverrideOptions databaseSpecificOverrideOptions = schemaCrawlerOptions.getDatabaseSpecificOverrideOptions();
        this.supportsCatalogs = databaseSpecificOverrideOptions.hasOverrideForSupportsCatalogs() ? databaseSpecificOverrideOptions.isSupportsCatalogs() : this.metaData.supportsCatalogsInTableDefinitions();
        LOGGER.log(Level.CONFIG, String.format("Database %s catalogs", this.supportsCatalogs ? "supports" : "does not support"));
        this.supportsSchemas = databaseSpecificOverrideOptions.hasOverrideForSupportsSchemas() ? databaseSpecificOverrideOptions.isSupportsSchemas() : this.metaData.supportsSchemasInTableDefinitions();
        LOGGER.log(Level.CONFIG, String.format("Database %s schemas", this.supportsSchemas ? "supports" : "does not support"));
        String identifierQuoteString = databaseSpecificOverrideOptions.hasOverrideForIdentifierQuoteString() ? databaseSpecificOverrideOptions.getIdentifierQuoteString() : this.metaData.getIdentifierQuoteString();
        this.identifierQuoteString = Utility.isBlank(identifierQuoteString) ? "" : identifierQuoteString;
        LOGGER.log(Level.CONFIG, String.format("Database identifier quote string is \"%s\"", this.identifierQuoteString));
        HashSet<String> rawReservedWords = new HashSet<String>();
        rawReservedWords.addAll(Arrays.asList(this.metaData.getSQLKeywords().split(",")));
        rawReservedWords.addAll(Arrays.asList(Utility.readResourceFully("/sql2003_reserved_words.txt").split("\r\n")));
        ArrayList<String> reservedWordsList = new ArrayList<String>();
        for (String reservedWord : rawReservedWords) {
            reservedWordsList.add(reservedWord.trim().toUpperCase());
        }
        Collections.sort(reservedWordsList);
        this.reservedWords = Collections.unmodifiableList(reservedWordsList);
    }

    Connection getConnection() {
        return this.connection;
    }

    String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    DatabaseMetaData getMetaData() {
        return this.metaData;
    }

    List<String> getReservedWords() {
        return this.reservedWords;
    }

    boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }

    boolean needsToBeQuoted(String name) {
        boolean needsToBeQuoted = name != null && this.identifierQuoteString != null && (Utility.containsWhitespace(name) || this.reservedWords.contains(name.toUpperCase()));
        return needsToBeQuoted;
    }
}

