/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import schemacrawler.crawl.MutableDatabaseProperty;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;

final class MutableDatabaseInfo
implements DatabaseInfo {
    private static final long serialVersionUID = 4051323422934251828L;
    private static final String NEWLINE = System.getProperty("line.separator");
    private String userName;
    private String productName;
    private String productVersion;
    private final Set<DatabaseProperty> databaseProperties = new HashSet<DatabaseProperty>();

    MutableDatabaseInfo() {
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public Collection<DatabaseProperty> getProperties() {
        ArrayList<DatabaseProperty> properties = new ArrayList<DatabaseProperty>(this.databaseProperties);
        Collections.sort(properties);
        return properties;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("-- database: ").append(this.getProductName()).append(' ').append(this.getProductVersion()).append(NEWLINE);
        return info.toString();
    }

    void addAll(Collection<MutableDatabaseProperty> dbProperties) {
        if (dbProperties != null) {
            this.databaseProperties.addAll(dbProperties);
        }
    }

    void setProductName(String productName) {
        this.productName = productName;
    }

    void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }
}

