/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.ColumnDataTypes;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.NamedObjectSort;
import schemacrawler.crawl.SchemaReference;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;

class MutableSchema
extends AbstractNamedObject
implements Schema {
    private static final long serialVersionUID = 3258128063743931187L;
    private final SchemaReference schemaRef;
    private final ColumnDataTypes columnDataTypes = new ColumnDataTypes();
    private final NamedObjectList<MutableTable> tables = new NamedObjectList();
    private final NamedObjectList<MutableProcedure> procedures = new NamedObjectList();

    MutableSchema() {
        this(new SchemaReference(null, null));
    }

    MutableSchema(SchemaReference schemaRef) {
        super(schemaRef.getFullName());
        this.schemaRef = schemaRef;
    }

    @Override
    public String getCatalogName() {
        return this.schemaRef.getCatalogName();
    }

    @Override
    public MutableColumnDataType getColumnDataType(String name) {
        return (MutableColumnDataType)this.columnDataTypes.lookup(name);
    }

    @Override
    public ColumnDataType[] getColumnDataTypes() {
        return this.columnDataTypes.values().toArray(new ColumnDataType[this.columnDataTypes.size()]);
    }

    @Override
    public String getFullName() {
        return this.schemaRef.getFullName();
    }

    @Override
    public MutableProcedure getProcedure(String name) {
        return this.procedures.lookup(this, name);
    }

    @Override
    public Procedure[] getProcedures() {
        return this.procedures.values().toArray(new Procedure[this.procedures.size()]);
    }

    @Override
    public String getSchemaName() {
        return this.schemaRef.getSchemaName();
    }

    @Override
    public MutableTable getTable(String name) {
        return this.tables.lookup(this, name);
    }

    @Override
    public Table[] getTables() {
        return this.tables.values().toArray(new Table[this.tables.size()]);
    }

    void addColumnDataType(MutableColumnDataType columnDataType) {
        if (columnDataType != null) {
            this.columnDataTypes.add(columnDataType);
        }
    }

    void addProcedure(MutableProcedure procedure) {
        this.procedures.add(procedure);
    }

    void addTable(MutableTable table) {
        this.tables.add(table);
    }

    MutableColumnDataType lookupColumnDataTypeByType(int type) {
        return this.columnDataTypes.lookupColumnDataTypeByType(type);
    }

    void removeProcedure(Procedure procedure) {
        this.procedures.remove(procedure);
    }

    void removeTable(Table table) {
        this.tables.remove(table);
    }

    void setTablesSortOrder(NamedObjectSort sort) {
        this.tables.setSortOrder(sort);
    }
}

