/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.logging.Level;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnMap;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnMap;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.AnalyzedDatabase;
import schemacrawler.tools.analysis.Lint;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseJsonFormatter;
import schemacrawler.tools.text.schema.SchemaFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;

final class SchemaJsonFormatter
extends BaseJsonFormatter<SchemaTextOptions>
implements SchemaFormatter {
    private final boolean isVerbose;
    private final boolean isNotList;

    SchemaJsonFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.details);
        this.isNotList = schemaTextDetailType != SchemaTextDetailType.list;
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            try {
                JSONObject jsonColumnDataType = new JSONObject();
                this.jsonRoot.accumulate("columnDataypes", jsonColumnDataType);
                jsonColumnDataType.put("databaseSpecificTypeName", columnDataType.getDatabaseSpecificTypeName());
                jsonColumnDataType.put("basedOn", columnDataType.getBaseType() == null ? "" : columnDataType.getBaseType().getName());
                jsonColumnDataType.put("userDefined", columnDataType.isUserDefined());
                jsonColumnDataType.put("createParameters", columnDataType.getCreateParameters());
                jsonColumnDataType.put("nullable", columnDataType.isNullable());
                jsonColumnDataType.put("autoIncrementable", columnDataType.isAutoIncrementable());
                jsonColumnDataType.put("searchable", columnDataType.getSearchable().toString());
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting ColumnDataType: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void handle(Procedure procedure) {
        try {
            JSONObject jsonProcedure = new JSONObject();
            this.jsonRoot.accumulate("procedures", jsonProcedure);
            jsonProcedure.put("name", procedure.getName());
            jsonProcedure.put("fullName", procedure.getFullName());
            jsonProcedure.put("type", procedure.getType());
            if (this.isNotList) {
                JSONArray jsonParameters = new JSONArray();
                jsonProcedure.put("parameters", jsonParameters);
                for (ProcedureColumn column : procedure.getColumns()) {
                    jsonParameters.put(this.handleProcedureColumn(column));
                }
                jsonProcedure.put("definition", procedure.getDefinition());
                if (this.isVerbose) {
                    jsonProcedure.put("remarks", procedure.getRemarks());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Procedure: " + e.getMessage(), e);
        }
    }

    @Override
    public void handle(Table table) {
        JSONObject jsonTable = new JSONObject();
        try {
            this.jsonRoot.accumulate("tables", jsonTable);
            jsonTable.put("name", table.getName());
            jsonTable.put("fullName", table.getFullName());
            jsonTable.put("type", table.getType());
            if (this.isNotList) {
                JSONArray jsonColumns = new JSONArray();
                jsonTable.put("columns", jsonColumns);
                for (Column column : table.getColumns()) {
                    jsonColumns.put(this.handleTableColumn(column));
                }
                jsonTable.put("primaryKey", this.handleIndex((Index)table.getPrimaryKey()));
                jsonTable.put("foreignKeys", this.handleForeignKeys(table.getForeignKeys()));
                if (this.isVerbose) {
                    ColumnMap[] weakAssociations = AnalyzedDatabase.getWeakAssociations(table);
                    jsonTable.put("weakAssociations", this.handleColumnPairs(weakAssociations));
                }
                JSONArray jsonIndices = new JSONArray();
                jsonTable.put("indices", jsonIndices);
                for (Index index : table.getIndices()) {
                    jsonIndices.put(this.handleIndex(index));
                }
                if (this.isVerbose) {
                    for (Index index : table.getCheckConstraints()) {
                        if (index == null) continue;
                        JSONObject jsonConsraint = new JSONObject();
                        jsonTable.accumulate("constraints", jsonConsraint);
                        jsonConsraint.put("name", index.getName());
                        jsonConsraint.put("definition", index.getDefinition());
                    }
                    for (Index index : table.getPrivileges()) {
                        if (index == null) continue;
                        JSONObject jsonPrivilege = new JSONObject();
                        jsonTable.accumulate("privileges", jsonPrivilege);
                        jsonPrivilege.put("name", index.getName());
                        for (Privilege.Grant grant : index.getGrants()) {
                            JSONObject jsonGrant = new JSONObject();
                            jsonPrivilege.accumulate("grants", jsonGrant);
                            jsonGrant.put("grantor", grant.getGrantor());
                            jsonGrant.put("grantee", grant.getGrantee());
                            jsonGrant.put("grantable", grant.isGrantable());
                        }
                    }
                    Trigger[] triggers = table.getTriggers();
                    jsonTable.put("triggers", this.handleTriggers(triggers));
                }
                if (table instanceof View) {
                    View view = (View)table;
                    jsonTable.put("definition", view.getDefinition());
                }
                if (this.isVerbose) {
                    jsonTable.put("remarks", table.getRemarks());
                    Lint[] lints = AnalyzedDatabase.getLint(table);
                    jsonTable.put("lints", this.handleLint(lints));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Table: " + e.getMessage(), e);
        }
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleProceduresEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleProceduresStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
    }

    private JSONArray handleColumnPairs(ColumnMap ... columnPairs) {
        JSONArray jsonColumnPairs = new JSONArray();
        for (ColumnMap columnPair : columnPairs) {
            try {
                JSONObject jsonColumnPair = new JSONObject();
                jsonColumnPair.put("pkColumn", columnPair.getPrimaryKeyColumn());
                jsonColumnPair.put("fkColumn", columnPair.getForeignKeyColumn());
                if (columnPair instanceof ForeignKeyColumnMap && ((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                    int keySequence = ((ForeignKeyColumnMap)columnPair).getKeySequence();
                    jsonColumnPair.put("keySequence", keySequence);
                }
                jsonColumnPairs.put(jsonColumnPair);
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting ColumnMap: " + e.getMessage(), e);
            }
        }
        return jsonColumnPairs;
    }

    private JSONArray handleForeignKeys(ForeignKey[] foreignKeys) {
        JSONArray jsonFks = new JSONArray();
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            try {
                ForeignKeyUpdateRule deleteRule;
                JSONObject jsonFk = new JSONObject();
                jsonFks.put(jsonFk);
                jsonFk.put("name", foreignKey.getName());
                ForeignKeyUpdateRule updateRule = foreignKey.getUpdateRule();
                if (updateRule != null && updateRule != ForeignKeyUpdateRule.unknown) {
                    jsonFk.put("updateRule", updateRule.toString());
                }
                if ((deleteRule = foreignKey.getDeleteRule()) != null && deleteRule != ForeignKeyUpdateRule.unknown) {
                    jsonFk.put("deleteRule", deleteRule.toString());
                }
                ForeignKeyColumnMap[] columnPairs = foreignKey.getColumnPairs();
                jsonFk.put("columnPairs", this.handleColumnPairs((ColumnMap[])columnPairs));
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting ForeignKey: " + e.getMessage(), e);
            }
        }
        return jsonFks;
    }

    private JSONObject handleIndex(Index index) {
        JSONObject jsonIndex = new JSONObject();
        if (index == null) {
            return jsonIndex;
        }
        try {
            IndexColumn[] columns;
            jsonIndex.put("name", index.getName());
            IndexType indexType = index.getType();
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                jsonIndex.put("type", indexType.toString());
            }
            jsonIndex.put("unique", index.isUnique());
            for (IndexColumn indexColumn : columns = index.getColumns()) {
                jsonIndex.accumulate("columns", this.handleTableColumn((Column)indexColumn));
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Index: " + e.getMessage(), e);
        }
        return jsonIndex;
    }

    private JSONArray handleLint(Lint[] lints) {
        JSONArray jsonLints = new JSONArray();
        if (lints != null && lints.length > 0) {
            for (Lint lint : lints) {
                try {
                    JSONObject jsonLint = new JSONObject();
                    jsonLints.put(jsonLint);
                    jsonLint.put("description", lint.getDescription());
                    jsonLint.put("value", lint.getLintValueAsString());
                }
                catch (JSONException e) {
                    LOGGER.log(Level.FINER, "Error outputting Lint: " + e.getMessage(), e);
                }
            }
        }
        return jsonLints;
    }

    private JSONObject handleProcedureColumn(ProcedureColumn column) {
        JSONObject jsonColumn = new JSONObject();
        try {
            jsonColumn.put("dataType", column.getType().getTypeName());
            jsonColumn.put("databaseSpecificType", column.getType().getDatabaseSpecificTypeName());
            jsonColumn.put("width", column.getWidth());
            jsonColumn.put("type", column.getProcedureColumnType().toString());
            jsonColumn.put("ordinal", column.getOrdinalPosition() + 1);
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting ProcedureColumn: " + e.getMessage(), e);
        }
        return jsonColumn;
    }

    private JSONObject handleTableColumn(Column column) {
        JSONObject jsonColumn = new JSONObject();
        try {
            jsonColumn.put("name", column.getName());
            if (column instanceof IndexColumn) {
                jsonColumn.put("sortSequence", ((IndexColumn)column).getSortSequence().name());
            } else {
                jsonColumn.put("dataType", column.getType().getTypeName());
                jsonColumn.put("databaseSpecificType", column.getType().getDatabaseSpecificTypeName());
                jsonColumn.put("width", column.getWidth());
                jsonColumn.put("size", column.getSize());
                jsonColumn.put("decimalDigits", column.getDecimalDigits());
                jsonColumn.put("nullable", column.isNullable());
            }
            jsonColumn.put("ordinal", column.getOrdinalPosition());
            if (this.isVerbose) {
                jsonColumn.put("remarks", column.getRemarks());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Column: " + e.getMessage(), e);
        }
        return jsonColumn;
    }

    private JSONArray handleTriggers(Trigger[] triggers) {
        JSONArray jsonTriggers = new JSONArray();
        for (Trigger trigger : triggers) {
            if (trigger == null) continue;
            try {
                JSONObject jsonTrigger = new JSONObject();
                jsonTriggers.put(jsonTrigger);
                ConditionTimingType conditionTiming = trigger.getConditionTiming();
                EventManipulationType eventManipulationType = trigger.getEventManipulationType();
                if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown && eventManipulationType != null && eventManipulationType != EventManipulationType.unknown) {
                    jsonTrigger.put("conditionTiming", conditionTiming);
                    jsonTrigger.put("eventManipulationType", eventManipulationType);
                }
                jsonTrigger.put("actionOrientation", trigger.getActionOrientation());
                jsonTrigger.put("actionCondition", trigger.getActionCondition());
                jsonTrigger.put("actionStatement", trigger.getActionStatement());
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting Trigger: " + e.getMessage(), e);
            }
        }
        return jsonTriggers;
    }
}

