/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.io.PrintWriter;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputWriter;
import schemacrawler.tools.text.utility.HtmlFormattingHelper;
import schemacrawler.tools.text.utility.PlainTextFormattingHelper;
import schemacrawler.tools.text.utility.TextFormattingHelper;

public abstract class BaseFormatter<O extends Options> {
    protected final O options;
    protected final OutputOptions outputOptions;
    protected final PrintWriter out;
    protected final TextFormattingHelper formattingHelper;
    protected final boolean printVerboseDatabaseInfo;

    protected BaseFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions) throws SchemaCrawlerException {
        if (options == null) {
            throw new IllegalArgumentException("Options not provided");
        }
        if (outputOptions == null) {
            throw new IllegalArgumentException("Output options not provided");
        }
        this.options = options;
        this.printVerboseDatabaseInfo = !outputOptions.isNoInfo() && printVerboseDatabaseInfo;
        this.outputOptions = outputOptions;
        OutputFormat outputFormat = outputOptions.getOutputFormat();
        this.formattingHelper = outputFormat == OutputFormat.html ? new HtmlFormattingHelper(outputFormat) : new PlainTextFormattingHelper(outputFormat);
        this.out = new PrintWriter(new OutputWriter(outputOptions));
    }

    abstract void handle(DatabaseInfo var1) throws SchemaCrawlerException;

    abstract void handle(JdbcDriverInfo var1) throws SchemaCrawlerException;

    abstract void handle(SchemaCrawlerInfo var1) throws SchemaCrawlerException;

    abstract void handleInfoEnd() throws SchemaCrawlerException;

    abstract void handleInfoStart() throws SchemaCrawlerException;
}

