/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnMap;

public final class WeakAssociation
implements ColumnMap,
Comparable<ColumnMap> {
    private static final long serialVersionUID = -4411771492159843382L;
    private final Column foreignKeyColumn;
    private final Column primaryKeyColumn;

    WeakAssociation(Column primaryKeyColumn, Column foreignKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
        this.foreignKeyColumn = foreignKeyColumn;
    }

    @Override
    public int compareTo(ColumnMap o) {
        int compare = 0;
        if (compare == 0) {
            compare = this.primaryKeyColumn.compareTo((Object)o.getPrimaryKeyColumn());
        }
        if (compare == 0) {
            compare = this.foreignKeyColumn.compareTo((Object)o.getForeignKeyColumn());
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeakAssociation other = (WeakAssociation)obj;
        if (this.foreignKeyColumn == null ? other.foreignKeyColumn != null : !this.foreignKeyColumn.equals(other.foreignKeyColumn)) {
            return false;
        }
        return !(this.primaryKeyColumn == null ? other.primaryKeyColumn != null : !this.primaryKeyColumn.equals(other.primaryKeyColumn));
    }

    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.foreignKeyColumn == null ? 0 : this.foreignKeyColumn.hashCode());
        result = 31 * result + (this.primaryKeyColumn == null ? 0 : this.primaryKeyColumn.hashCode());
        return result;
    }

    public String toString() {
        return this.primaryKeyColumn + " --> " + this.foreignKeyColumn;
    }
}

