/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.utility;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.utility.BaseTextFormattingHelper;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import sf.util.Utility;

public final class HtmlFormattingHelper
extends BaseTextFormattingHelper {
    private static final String HTML_FOOTER = "</body>" + Utility.NEWLINE + "</html>";
    private static final String HTML_HEADER = HtmlFormattingHelper.htmlHeader();

    private static String htmlHeader() {
        String styleSheet = Utility.readResourceFully((String)"/schemacrawler-output.css");
        return "<!DOCTYPE html>" + Utility.NEWLINE + "<html xmlns='http://www.w3.org/1999/xhtml'>" + Utility.NEWLINE + "<head>" + Utility.NEWLINE + "  <title>SchemaCrawler Output</title>" + Utility.NEWLINE + "  <meta charset=\"utf-8\"/>" + Utility.NEWLINE + "  <style>" + Utility.NEWLINE + styleSheet + Utility.NEWLINE + "  </style>" + Utility.NEWLINE + "</head>" + Utility.NEWLINE + "<body>" + Utility.NEWLINE;
    }

    public HtmlFormattingHelper(OutputFormat outputFormat) {
        super(outputFormat);
    }

    @Override
    public String createArrow() {
        return " \u2192 ";
    }

    @Override
    public String createDocumentEnd() {
        return HTML_FOOTER;
    }

    @Override
    public String createDocumentStart() {
        return HTML_HEADER;
    }

    @Override
    public String createHeader(TextFormattingHelper.DocumentHeaderType type, String header) {
        if (!Utility.isBlank((String)header)) {
            String headerTag;
            String prefix;
            if (type == null) {
                prefix = "<p>&#160;</p>";
                headerTag = "h2";
            } else {
                switch (type) {
                    case title: {
                        prefix = "<p>&#160;</p>";
                        headerTag = "h1";
                        break;
                    }
                    case subTitle: {
                        prefix = "<p>&#160;</p>";
                        headerTag = "h2";
                        break;
                    }
                    case section: {
                        prefix = "";
                        headerTag = "h3";
                        break;
                    }
                    default: {
                        prefix = "<p>&#160;</p>";
                        headerTag = "h2";
                    }
                }
            }
            return String.format("%s%n<%s>%s</%s>%n", prefix, headerTag, header, headerTag);
        }
        return "";
    }

    @Override
    public String createObjectEnd() {
        return "</table>" + Utility.NEWLINE + "<p>&#160;</p>" + Utility.NEWLINE;
    }

    @Override
    public String createObjectStart(String name) {
        String objectStart = "<table>" + Utility.NEWLINE;
        if (!Utility.isBlank((String)name)) {
            objectStart = objectStart + "  <caption>" + name + "</caption>" + Utility.NEWLINE;
        }
        return objectStart;
    }
}

