/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.NamedObjectFilter;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

class RoutineGrepFilter
implements NamedObjectFilter<Routine> {
    private static final Logger LOGGER = Logger.getLogger(RoutineGrepFilter.class.getName());
    private final boolean invertMatch;
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;

    public RoutineGrepFilter(SchemaCrawlerOptions options) {
        this.invertMatch = options.isGrepInvertMatch();
        this.grepColumnInclusionRule = options.getGrepRoutineColumnInclusionRule();
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
    }

    @Override
    public boolean include(Routine routine) {
        boolean include;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (RoutineColumn<? extends Routine> routineColumn : routine.getColumns()) {
            if (checkIncludeForColumns && this.grepColumnInclusionRule.include(routineColumn.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !this.grepDefinitionInclusionRule.include(routineColumn.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (this.grepDefinitionInclusionRule.include(routine.getRemarks())) {
                includeForDefinitions = true;
            }
            if (this.grepDefinitionInclusionRule.include(routine.getDefinition())) {
                includeForDefinitions = true;
            }
        }
        boolean bl2 = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, "Removing table " + routine + " since it does not match the grep pattern");
        }
        return include;
    }
}

