/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;

final class SchemaRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SchemaRetriever.class.getName());
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;

    SchemaRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
        this.supportsCatalogs = retrieverConnection.isSupportsCatalogs();
        this.supportsSchemas = retrieverConnection.isSupportsSchemas();
    }

    void retrieveSchemas(InclusionRule schemaInclusionRule) throws SQLException {
        InclusionRuleFilter<SchemaReference> schemaFilter = new InclusionRuleFilter<SchemaReference>(schemaInclusionRule, true);
        if (schemaFilter.isExcludeAll()) {
            return;
        }
        Set<SchemaReference> schemaRefs = this.retrieveAllSchemasFromInformationSchemaViews();
        if (schemaRefs.isEmpty()) {
            schemaRefs.addAll(this.retrieveAllSchemas());
        }
        Iterator<SchemaReference> iterator = schemaRefs.iterator();
        while (iterator.hasNext()) {
            SchemaReference schemaRef = iterator.next();
            if (schemaFilter.include(schemaRef)) continue;
            LOGGER.log(Level.FINER, "Dropping schema, since schema is excluded: " + schemaRef.getFullName());
            iterator.remove();
        }
        for (SchemaReference schemaRef : schemaRefs) {
            this.database.addSchema(schemaRef);
        }
        if (!this.supportsCatalogs && !this.supportsSchemas) {
            this.database.addSchema(new SchemaReference(null, null));
        }
    }

    private Set<String> retrieveAllCatalogs() {
        HashSet<String> catalogNames = new HashSet<String>();
        if (this.supportsCatalogs) {
            try {
                List<String> metaDataCatalogNames = SchemaRetriever.readResultsVector(this.getMetaData().getCatalogs());
                for (String catalogName : metaDataCatalogNames) {
                    catalogNames.add(this.quotedName(catalogName));
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            LOGGER.log(Level.FINER, "Retrieved catalogs: " + catalogNames);
        }
        return catalogNames;
    }

    /*
     * Unable to fully structure code
     */
    private Set<SchemaReference> retrieveAllSchemas() throws SQLException {
        block16: {
            schemaRefs = new HashSet<SchemaReference>();
            allCatalogNames = this.retrieveAllCatalogs();
            if (!this.supportsSchemas) break block16;
            results = new MetadataResultSet(this.getMetaData().getSchemas());
            var4_5 = null;
lbl6:
            // 2 sources

            try {
                while (results.next()) {
                    block17: {
                        catalogName = this.supportsCatalogs != false ? this.quotedName(results.getString("TABLE_CATALOG")) : null;
                        schemaName = this.quotedName(results.getString("TABLE_SCHEM"));
                        SchemaRetriever.LOGGER.log(Level.FINER, String.format("Retrieving schema: %s --> %s", new Object[]{catalogName, schemaName}));
                        if (catalogName != null) break block17;
                        if (allCatalogNames.isEmpty()) {
                            schemaRefs.add(new SchemaReference(null, schemaName));
                            continue;
                        }
                        for (String expectedCatalogName : allCatalogNames) {
                            schemaRefs.add(new SchemaReference(expectedCatalogName, schemaName));
                        }
                        ** GOTO lbl6
                    }
                    schemaRefs.add(new SchemaReference(catalogName, schemaName));
                }
            }
            catch (Throwable var5_9) {
                var4_5 = var5_9;
                throw var5_9;
            }
            finally {
                if (results != null) {
                    if (var4_5 != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable x2) {
                            var4_5.addSuppressed(x2);
                        }
                    } else {
                        results.close();
                    }
                }
            }
        }
        for (String catalogName : allCatalogNames) {
            SchemaRetriever.LOGGER.log(Level.FINER, String.format("Retrieving schema: %s --> %s", new Object[]{catalogName, null}));
            schemaRefs.add(new SchemaReference(catalogName, null));
        }
        return schemaRefs;
    }

    private Set<SchemaReference> retrieveAllSchemasFromInformationSchemaViews() throws SQLException {
        HashSet<SchemaReference> schemaRefs = new HashSet<SchemaReference>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasSchemataSql()) {
            LOGGER.log(Level.FINE, "Schemata SQL statement was not provided");
            return schemaRefs;
        }
        String schemataSql = informationSchemaViews.getSchemataSql();
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(statement.executeQuery(schemataSql));){
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("CATALOG_NAME"));
                String schemaName = this.quotedName(results.getString("SCHEMA_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving schema: %s --> %s", catalogName, schemaName));
                schemaRefs.add(new SchemaReference(catalogName, schemaName));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve schemas", e);
        }
        return schemaRefs;
    }
}

