/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.BaseDatabaseDecorator;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.serialization.SerializableDatabase;

public final class XmlDatabase
extends BaseDatabaseDecorator
implements SerializableDatabase {
    private static final long serialVersionUID = 5314326260124511414L;

    private static XStream newXStream() throws SchemaCrawlerException {
        try {
            String[] immutable;
            String[] mutable;
            XStream xStream = new XStream();
            xStream.setMode(1002);
            xStream.registerConverter((Converter)new CollectionConverter(xStream.getMapper()){

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    ArrayList collection = (ArrayList)source;
                    if (collection instanceof Set) {
                        ArrayList list = new ArrayList(collection);
                        Collections.sort(list);
                        collection = list;
                    }
                    for (Object item : collection) {
                        this.writeItem(item, context, writer);
                    }
                }
            }, 5000);
            xStream.registerConverter((Converter)new MapConverter(xStream.getMapper()){

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    Map map = (Map)source;
                    ArrayList entryList = new ArrayList(map.entrySet());
                    Collections.sort(entryList, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((Comparable)((Map.Entry)o1).getKey()).compareTo(((Map.Entry)o2).getKey());
                        }
                    });
                    for (Object e : entryList) {
                        Map.Entry entry = (Map.Entry)e;
                        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)this.mapper().serializedClass(Map.Entry.class), Map.Entry.class);
                        this.writeItem(entry.getKey(), context, writer);
                        this.writeItem(entry.getValue(), context, writer);
                        writer.endNode();
                    }
                }
            }, 5000);
            for (String xmlElement : mutable = new String[]{"checkConstraint", "column", "columnDataType", "database", "foreignKey", "foreignKeyColumnReference", "index", "indexColumn", "primaryKey", "privilege", "procedure", "procedureColumn", "resultsColumn", "resultsColumns", "table", "trigger", "view"}) {
                xStream.alias(xmlElement, Class.forName("schemacrawler.crawl.Mutable" + xmlElement.substring(0, 1).toUpperCase() + xmlElement.substring(1)));
            }
            for (String xmlElement : immutable = new String[]{"databaseProperty", "jdbcDriverProperty"}) {
                xStream.alias(xmlElement, Class.forName("schemacrawler.crawl.Immutable" + xmlElement.substring(0, 1).toUpperCase() + xmlElement.substring(1)));
            }
            xStream.alias("grant", Class.forName("schemacrawler.crawl.MutablePrivilege$PrivilegeGrant"));
            xStream.alias("schema", Class.forName("schemacrawler.schema.SchemaReference"));
            return xStream;
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load internal classes", (Throwable)e);
        }
    }

    public XmlDatabase(Database database) {
        super(database);
    }

    public XmlDatabase(Reader reader) throws SchemaCrawlerException {
        this((Database)XmlDatabase.newXStream().fromXML(reader));
    }

    @Override
    public void save(Writer writer) throws SchemaCrawlerException {
        if (writer == null) {
            throw new SchemaCrawlerException("Writer not provided");
        }
        try {
            XmlDatabase.newXStream().toXML((Object)this.database, writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not write XML", (Throwable)e);
        }
    }
}

